/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.appindexing.AppIndexApi;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzip;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zziz;
import com.google.android.gms.internal.zzjc;
import com.google.android.gms.internal.zzop;
import com.google.android.gms.internal.zzwy;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.zip.CRC32;

public class zzjb
implements SafeParcelable {
    public static final zzjc CREATOR = new zzjc();
    final int zzFG;
    final zzip zzGw;
    final long zzGx;
    final int zzGy;
    public final String zzpZ;
    final zzin zzGz;
    final boolean zzGA;
    int zzGB;

    public zzjb(zzip zzip2, long l, int n) {
        this(1, zzip2, l, n, null, null, false, -1);
    }

    public zzjb(zzip zzip2, long l, int n, String string, zzin zzin2, boolean bl, int n2) {
        this(1, zzip2, l, n, string, zzin2, bl, n2);
    }

    public zzjb(String string, Intent intent, String string2, Uri uri, String string3, List<AppIndexApi.AppIndexingLink> list) {
        this(1, zzjb.zza(string, intent), System.currentTimeMillis(), 0, null, zzjb.zza(intent, string2, uri, string3, list).zzgU(), false, -1);
    }

    zzjb(int n, zzip zzip2, long l, int n2, String string, zzin zzin2, boolean bl, int n3) {
        this.zzFG = n;
        this.zzGw = zzip2;
        this.zzGx = l;
        this.zzGy = n2;
        this.zzpZ = string;
        this.zzGz = zzin2;
        this.zzGA = bl;
        this.zzGB = n3;
    }

    public static zzip zza(String string, Intent intent) {
        return zzjb.zzl(string, zzjb.zzg(intent));
    }

    private static zzip zzl(String string, String string2) {
        return new zzip(string, "", string2);
    }

    private static zzir zzaB(String string) {
        return new zzir(string, new zziz.zza("title").zzW(1).zzJ(true).zzaA("name").zzgX(), "text1");
    }

    private static zzir zzh(Uri uri) {
        return new zzir(uri.toString(), new zziz.zza("web_url").zzW(4).zzI(true).zzaA("url").zzgX());
    }

    private static zzir zzm(String string, String string2) {
        return new zzir(string2, new zziz.zza(string).zzI(true).zzgX(), string);
    }

    private static String zzg(Intent intent) {
        String string = intent.toUri(1);
        CRC32 cRC32 = new CRC32();
        try {
            cRC32.update(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
        return Long.toHexString(cRC32.getValue());
    }

    private static zzir zzd(List<AppIndexApi.AppIndexingLink> list) {
        zzop.zza zza2 = new zzop.zza();
        zzop.zza.zza[] zzaArray = new zzop.zza.zza[list.size()];
        for (int i = 0; i < zzaArray.length; ++i) {
            zzaArray[i] = new zzop.zza.zza();
            AppIndexApi.AppIndexingLink appIndexingLink = list.get(i);
            zzaArray[i].zzalg = appIndexingLink.appIndexingUrl.toString();
            zzaArray[i].viewId = appIndexingLink.viewId;
            if (appIndexingLink.webUrl == null) continue;
            zzaArray[i].zzalh = appIndexingLink.webUrl.toString();
        }
        zza2.zzale = zzaArray;
        return new zzir(zzwy.zzf((zzwy)zza2), new zziz.zza("outlinks").zzI(true).zzaA(".private:outLinks").zzaz("blob").zzgX());
    }

    public static zzin.zza zza(Intent intent, String string, Uri uri, String string2, List<AppIndexApi.AppIndexingLink> list) {
        String string3;
        Bundle bundle;
        ComponentName componentName;
        String string4;
        String string5;
        zzin.zza zza2 = new zzin.zza();
        zza2.zza(zzjb.zzaB(string));
        if (uri != null) {
            zza2.zza(zzjb.zzh(uri));
        }
        if (list != null) {
            zza2.zza(zzjb.zzd(list));
        }
        if ((string5 = intent.getAction()) != null) {
            zza2.zza(zzjb.zzm("intent_action", string5));
        }
        if ((string4 = intent.getDataString()) != null) {
            zza2.zza(zzjb.zzm("intent_data", string4));
        }
        if ((componentName = intent.getComponent()) != null) {
            zza2.zza(zzjb.zzm("intent_activity", componentName.getClassName()));
        }
        if ((bundle = intent.getExtras()) != null && (string3 = bundle.getString("intent_extra_data_key")) != null) {
            zza2.zza(zzjb.zzm("intent_extra_data", string3));
        }
        return zza2.zzax(string2).zzH(true);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzjc.zza(this, dest, flags);
    }

    public String toString() {
        return String.format("UsageInfo[documentId=%s, timestamp=%d, usageType=%d]", this.zzGw, this.zzGx, this.zzGy);
    }
}

