/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.RemoteException;
import com.google.android.gms.appdatasearch.UsageInfo;
import com.google.android.gms.appdatasearch.zzk;
import com.google.android.gms.appindexing.Action;
import com.google.android.gms.appindexing.AppIndexApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.internal.zzgq;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zzgs;
import com.google.android.gms.internal.zzgt;
import com.google.android.gms.internal.zzgu;
import java.util.List;

public final class zzgv
implements zzk,
AppIndexApi {
    public PendingResult<Status> zza(GoogleApiClient googleApiClient, final UsageInfo ... usageInfoArray) {
        final String string = googleApiClient.getContext().getPackageName();
        return googleApiClient.zza((zza.zza)new zzc<Status>(googleApiClient){

            @Override
            protected void zza(zzgq zzgq2) throws RemoteException {
                zzgq2.zza((zzgr)new zzd((zza.zzb<Status>)this), string, usageInfoArray);
            }
        });
    }

    @Override
    public PendingResult<Status> view(GoogleApiClient apiClient, Activity activity, Intent viewIntent, String title, Uri webUrl, List<AppIndexApi.AppIndexingLink> outLinks) {
        String string = apiClient.getContext().getPackageName();
        zzgv.zzj(outLinks);
        return this.zza(apiClient, new UsageInfo(string, viewIntent, title, webUrl, null, outLinks, 1));
    }

    @Override
    public PendingResult<Status> viewEnd(GoogleApiClient apiClient, Activity activity, Intent viewIntent) {
        String string = apiClient.getContext().getPackageName();
        UsageInfo usageInfo = new UsageInfo.zza().zza(UsageInfo.zza(string, viewIntent)).zzu(System.currentTimeMillis()).zzac(0).zzad(2).zzjH();
        return this.zza(apiClient, usageInfo);
    }

    public static Intent zza(String string, Uri uri) {
        zzgv.zzb(string, uri);
        List list = uri.getPathSegments();
        String string2 = (String)list.get(0);
        Uri.Builder builder = new Uri.Builder();
        builder.scheme(string2);
        if (list.size() > 1) {
            builder.authority((String)list.get(1));
            for (int i = 2; i < list.size(); ++i) {
                builder.appendPath((String)list.get(i));
            }
        }
        builder.encodedQuery(uri.getEncodedQuery());
        builder.encodedFragment(uri.getEncodedFragment());
        return new Intent("android.intent.action.VIEW", builder.build());
    }

    private static void zzb(String string, Uri uri) {
        String string2 = uri.getScheme();
        if (!"android-app".equals(string2)) {
            throw new IllegalArgumentException("AppIndex: The URI scheme must be 'android-app' and follow the format (android-app://<package_name>/<scheme>/[host_path]). Provided URI: " + uri);
        }
        String string3 = uri.getHost();
        if (string != null && !string.equals(string3)) {
            throw new IllegalArgumentException("AppIndex: The URI host must match the package name and follow the format (android-app://<package_name>/<scheme>/[host_path]). Provided URI: " + uri);
        }
        List list = uri.getPathSegments();
        if (list.isEmpty() || ((String)list.get(0)).isEmpty()) {
            throw new IllegalArgumentException("AppIndex: The app URI scheme must exist and follow the format android-app://<package_name>/<scheme>/[host_path]). Provided URI: " + uri);
        }
    }

    public static void zzj(List<AppIndexApi.AppIndexingLink> list) {
        if (list == null) {
            return;
        }
        for (AppIndexApi.AppIndexingLink appIndexingLink : list) {
            zzgv.zzb(null, appIndexingLink.appIndexingUrl);
        }
    }

    @Override
    public PendingResult<Status> view(GoogleApiClient apiClient, Activity activity, Uri appIndexingUrl, String title, Uri webUrl, List<AppIndexApi.AppIndexingLink> outLinks) {
        String string = apiClient.getContext().getPackageName();
        zzgv.zzb(string, appIndexingUrl);
        Intent intent = zzgv.zza(string, appIndexingUrl);
        return this.view(apiClient, activity, intent, title, webUrl, outLinks);
    }

    @Override
    public PendingResult<Status> viewEnd(GoogleApiClient apiClient, Activity activity, Uri appUri) {
        String string = apiClient.getContext().getPackageName();
        Intent intent = zzgv.zza(string, appUri);
        return this.viewEnd(apiClient, activity, intent);
    }

    @Override
    public AppIndexApi.ActionResult action(GoogleApiClient apiClient, Action action) {
        PendingResult<Status> pendingResult = this.zza(apiClient, action, 1);
        return new zza(this, pendingResult, action);
    }

    @Override
    public PendingResult<Status> start(GoogleApiClient apiClient, Action action) {
        return this.zza(apiClient, action, 1);
    }

    @Override
    public PendingResult<Status> end(GoogleApiClient apiClient, Action action) {
        return this.zza(apiClient, action, 2);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, Action action, int n) {
        String string = googleApiClient.getContext().getPackageName();
        long l = System.currentTimeMillis();
        UsageInfo usageInfo = zzgu.zza(action, l, string, n);
        return this.zza(googleApiClient, usageInfo);
    }

    @Deprecated
    private static final class zza
    implements AppIndexApi.ActionResult {
        private zzgv zzJW;
        private PendingResult<Status> zzJX;
        private Action zzJY;

        zza(zzgv zzgv2, PendingResult<Status> pendingResult, Action action) {
            this.zzJW = zzgv2;
            this.zzJX = pendingResult;
            this.zzJY = action;
        }

        @Override
        public PendingResult<Status> end(GoogleApiClient apiClient) {
            String string = apiClient.getContext().getPackageName();
            long l = System.currentTimeMillis();
            UsageInfo usageInfo = zzgu.zza(this.zzJY, l, string, 2);
            return this.zzJW.zza(apiClient, usageInfo);
        }

        @Override
        public PendingResult<Status> getPendingResult() {
            return this.zzJX;
        }
    }

    private static final class zzd
    extends zzgs<Status> {
        public zzd(zza.zzb<Status> zzb2) {
            super(zzb2);
        }

        @Override
        public void zza(Status status) {
            this.zzJS.zzj((Object)status);
        }
    }

    private static abstract class zzc<T extends Result>
    extends zzb<Status> {
        zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected Status zzb(Status status) {
            return status;
        }

        protected /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzb(x0);
        }
    }

    private static abstract class zzb<T extends Result>
    extends zza.zza<T, zzgt> {
        public zzb(GoogleApiClient googleApiClient) {
            super(com.google.android.gms.appdatasearch.zza.zzIS, googleApiClient);
        }

        protected final void zza(zzgt zzgt2) throws RemoteException {
            this.zza(zzgt2.zzjI());
        }

        protected abstract void zza(zzgq var1) throws RemoteException;
    }
}

