/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appdatasearch;

import android.content.ComponentName;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.appdatasearch.DocumentContents;
import com.google.android.gms.appdatasearch.DocumentId;
import com.google.android.gms.appdatasearch.DocumentSection;
import com.google.android.gms.appdatasearch.RegisterSectionInfo;
import com.google.android.gms.appdatasearch.zzj;
import com.google.android.gms.appindexing.AppIndexApi;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.zzox;
import com.google.android.gms.internal.zzse;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.zip.CRC32;

public class UsageInfo
implements SafeParcelable {
    public static final zzj CREATOR = new zzj();
    final int mVersionCode;
    final DocumentId zzQU;
    final long zzQV;
    int zzQW;
    public final String zzub;
    final DocumentContents zzQX;
    final boolean zzQY;
    int zzQZ;
    int zzRa;

    private UsageInfo(DocumentId documentId, long timestampMs, int usageType, String query, DocumentContents document, boolean isDeviceOnly, int taskPosition, int eventStatus) {
        this(1, documentId, timestampMs, usageType, query, document, isDeviceOnly, taskPosition, eventStatus);
    }

    public UsageInfo(String packageName, Intent viewIntent, String title, Uri webUrl, String schemaOrgType, List<AppIndexApi.AppIndexingLink> outLinks, int eventStatus) {
        this(1, UsageInfo.zza(packageName, viewIntent), System.currentTimeMillis(), 0, null, UsageInfo.zza(viewIntent, title, webUrl, schemaOrgType, outLinks).zzlo(), false, -1, eventStatus);
    }

    UsageInfo(int versionCode, DocumentId documentId, long timestamp, int usageType, String query, DocumentContents document, boolean isDeviceOnly, int taskPosition, int eventStatus) {
        this.mVersionCode = versionCode;
        this.zzQU = documentId;
        this.zzQV = timestamp;
        this.zzQW = usageType;
        this.zzub = query;
        this.zzQX = document;
        this.zzQY = isDeviceOnly;
        this.zzQZ = taskPosition;
        this.zzRa = eventStatus;
    }

    public DocumentContents zzlu() {
        return this.zzQX;
    }

    public static DocumentId zza(String string, Intent intent) {
        return UsageInfo.zzp(string, UsageInfo.zzg(intent));
    }

    private static DocumentId zzp(String string, String string2) {
        return new DocumentId(string, "", string2);
    }

    private static DocumentSection zzbC(String string) {
        return new DocumentSection(string, new RegisterSectionInfo.zza("title").zzal(1).zzN(true).zzbB("name").zzlt(), "text1");
    }

    private static DocumentSection zzi(Uri uri) {
        return new DocumentSection(uri.toString(), new RegisterSectionInfo.zza("web_url").zzal(4).zzM(true).zzbB("url").zzlt());
    }

    private static DocumentSection zzq(String string, String string2) {
        return new DocumentSection(string2, new RegisterSectionInfo.zza(string).zzM(true).zzlt(), string);
    }

    private static String zzg(Intent intent) {
        String string = intent.toUri(1);
        CRC32 cRC32 = new CRC32();
        try {
            cRC32.update(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
        return Long.toHexString(cRC32.getValue());
    }

    private static DocumentSection zzo(List<AppIndexApi.AppIndexingLink> list) {
        zzox.zza zza2 = new zzox.zza();
        zzox.zza.zza[] zzaArray = new zzox.zza.zza[list.size()];
        for (int i = 0; i < zzaArray.length; ++i) {
            zzaArray[i] = new zzox.zza.zza();
            AppIndexApi.AppIndexingLink appIndexingLink = list.get(i);
            zzaArray[i].zzaCW = appIndexingLink.appIndexingUrl.toString();
            zzaArray[i].viewId = appIndexingLink.viewId;
            if (appIndexingLink.webUrl == null) continue;
            zzaArray[i].zzaCX = appIndexingLink.webUrl.toString();
        }
        zza2.zzaCU = zzaArray;
        return new DocumentSection(zzse.zzf((zzse)zza2), new RegisterSectionInfo.zza("outlinks").zzM(true).zzbB(".private:outLinks").zzbA("blob").zzlt());
    }

    public static DocumentContents.zza zza(Intent intent, String string, Uri uri, String string2, List<AppIndexApi.AppIndexingLink> list) {
        String string3;
        Bundle bundle;
        ComponentName componentName;
        String string4;
        String string5;
        DocumentContents.zza zza2 = new DocumentContents.zza();
        zza2.zza(UsageInfo.zzbC(string));
        if (uri != null) {
            zza2.zza(UsageInfo.zzi(uri));
        }
        if (list != null) {
            zza2.zza(UsageInfo.zzo(list));
        }
        if ((string5 = intent.getAction()) != null) {
            zza2.zza(UsageInfo.zzq("intent_action", string5));
        }
        if ((string4 = intent.getDataString()) != null) {
            zza2.zza(UsageInfo.zzq("intent_data", string4));
        }
        if ((componentName = intent.getComponent()) != null) {
            zza2.zza(UsageInfo.zzq("intent_activity", componentName.getClassName()));
        }
        if ((bundle = intent.getExtras()) != null && (string3 = bundle.getString("intent_extra_data_key")) != null) {
            zza2.zza(UsageInfo.zzq("intent_extra_data", string3));
        }
        return zza2.zzbx(string2).zzK(true);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzj.zza(this, dest, flags);
    }

    public String toString() {
        return String.format("UsageInfo[documentId=%s, timestamp=%d, usageType=%d, status=%d]", this.zzQU, this.zzQV, this.zzQW, this.zzRa);
    }

    public static final class zza {
        private DocumentId zzQU;
        private long zzQV = -1L;
        private int zzQW = -1;
        private String zzLe;
        private DocumentContents zzQX;
        private boolean zzQY = false;
        private int zzQZ = -1;
        private int zzRa = 0;

        public zza zza(DocumentId documentId) {
            this.zzQU = documentId;
            return this;
        }

        public zza zzw(long l) {
            this.zzQV = l;
            return this;
        }

        public zza zzan(int n) {
            this.zzQW = n;
            return this;
        }

        public zza zza(DocumentContents documentContents) {
            this.zzQX = documentContents;
            return this;
        }

        public zza zzO(boolean bl) {
            this.zzQY = bl;
            return this;
        }

        public zza zzao(int n) {
            this.zzRa = n;
            return this;
        }

        public UsageInfo zzlv() {
            return new UsageInfo(this.zzQU, this.zzQV, this.zzQW, this.zzLe, this.zzQX, this.zzQY, this.zzQZ, this.zzRa);
        }
    }
}

