/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appindexing;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzx;
import java.util.ArrayList;

public class Thing {
    final Bundle zzTm;

    Thing(Bundle propertyBundle) {
        this.zzTm = propertyBundle;
    }

    public Bundle zzlT() {
        return this.zzTm;
    }

    public static class Builder {
        final Bundle zzTn = new Bundle();

        public Builder setName(String name) {
            zzx.zzy((Object)name);
            this.put("name", name);
            return this;
        }

        public Builder setUrl(Uri url) {
            zzx.zzy((Object)url);
            this.put("url", url.toString());
            return this;
        }

        public Builder setId(String id) {
            if (id != null) {
                this.put("id", id);
            }
            return this;
        }

        public Builder setType(String type) {
            this.put("type", type);
            return this;
        }

        public Builder setDescription(String description) {
            this.put("description", description);
            return this;
        }

        public Builder put(String key, String value) {
            zzx.zzy((Object)key);
            if (value != null) {
                this.zzTn.putString(key, value);
            }
            return this;
        }

        public Builder put(String key, String[] values) {
            zzx.zzy((Object)key);
            if (values != null) {
                this.zzTn.putStringArray(key, values);
            }
            return this;
        }

        public Builder put(String key, Thing value) {
            zzx.zzy((Object)key);
            if (value != null) {
                this.zzTn.putParcelable(key, (Parcelable)value.zzTm);
            }
            return this;
        }

        public Builder put(String key, Thing[] values) {
            zzx.zzy((Object)key);
            if (values != null) {
                ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
                for (Thing thing : values) {
                    if (thing == null) continue;
                    arrayList.add(thing.zzTm);
                }
                this.zzTn.putParcelableArray(key, (Parcelable[])arrayList.toArray(new Bundle[arrayList.size()]));
            }
            return this;
        }

        public Thing build() {
            return new Thing(this.zzTn);
        }
    }
}

