/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.RemoteException;
import com.google.android.gms.appdatasearch.UsageInfo;
import com.google.android.gms.appdatasearch.zzk;
import com.google.android.gms.appindexing.Action;
import com.google.android.gms.appindexing.AppIndexApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzkd;
import com.google.android.gms.internal.zzke;
import com.google.android.gms.internal.zzkf;
import com.google.android.gms.internal.zzkg;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzlx;
import java.util.List;

public final class zzki
implements zzk,
AppIndexApi {
    public PendingResult<Status> zza(GoogleApiClient googleApiClient, final UsageInfo ... usageInfoArray) {
        final String string = googleApiClient.getContext().getPackageName();
        return googleApiClient.zza((zzlx.zza)new zzc<Status>(googleApiClient){

            @Override
            protected void zza(zzkd zzkd2) throws RemoteException {
                zzkd2.zza((zzke)new zzd((zzlx.zzb<Status>)this), string, usageInfoArray);
            }
        });
    }

    @Override
    public PendingResult<Status> view(GoogleApiClient apiClient, Activity activity, Intent viewIntent, String title, Uri webUrl, List<AppIndexApi.AppIndexingLink> outLinks) {
        String string = apiClient.getContext().getPackageName();
        zzki.zzr(outLinks);
        return this.zza(apiClient, new UsageInfo(string, viewIntent, title, webUrl, null, outLinks, 1));
    }

    @Override
    public PendingResult<Status> viewEnd(GoogleApiClient apiClient, Activity activity, Intent viewIntent) {
        String string = apiClient.getContext().getPackageName();
        UsageInfo usageInfo = new UsageInfo.zza().zza(UsageInfo.zza(string, viewIntent)).zzw(System.currentTimeMillis()).zzar(0).zzas(2).zzlR();
        return this.zza(apiClient, usageInfo);
    }

    public static Intent zza(String string, Uri uri) {
        zzki.zzb(string, uri);
        if (zzki.zzk(uri)) {
            return new Intent("android.intent.action.VIEW", uri);
        }
        if (zzki.zzl(uri)) {
            return new Intent("android.intent.action.VIEW", zzki.zzj(uri));
        }
        throw new RuntimeException("appIndexingUri is neither an HTTP(S) URL nor an \"android-app://\" URL: " + uri);
    }

    private static Uri zzj(Uri uri) {
        List list = uri.getPathSegments();
        String string = (String)list.get(0);
        Uri.Builder builder = new Uri.Builder();
        builder.scheme(string);
        if (list.size() > 1) {
            builder.authority((String)list.get(1));
            for (int i = 2; i < list.size(); ++i) {
                builder.appendPath((String)list.get(i));
            }
        }
        builder.encodedQuery(uri.getEncodedQuery());
        builder.encodedFragment(uri.getEncodedFragment());
        return builder.build();
    }

    private static void zzb(String string, Uri uri) {
        if (zzki.zzk(uri)) {
            if (uri.getHost().isEmpty()) {
                throw new IllegalArgumentException("AppIndex: The web URL must have a host (follow the format http(s)://<host>/[path]). Provided URI: " + uri);
            }
            return;
        }
        if (zzki.zzl(uri)) {
            if (string != null && !string.equals(uri.getHost())) {
                throw new IllegalArgumentException("AppIndex: The android-app URI host must match the package name and follow the format android-app://<package_name>/<scheme>/[host_path]. Provided URI: " + uri);
            }
            List list = uri.getPathSegments();
            if (list.isEmpty() || ((String)list.get(0)).isEmpty()) {
                throw new IllegalArgumentException("AppIndex: The app URI scheme must exist and follow the format android-app://<package_name>/<scheme>/[host_path]). Provided URI: " + uri);
            }
            return;
        }
        throw new IllegalArgumentException("AppIndex: The URI scheme must either be 'http(s)' or 'android-app'. If the latter, it must follow the format 'android-app://<package_name>/<scheme>/[host_path]'. Provided URI: " + uri);
    }

    private static boolean zzk(Uri uri) {
        String string = uri.getScheme();
        return "http".equals(string) || "https".equals(string);
    }

    private static boolean zzl(Uri uri) {
        String string = uri.getScheme();
        return "android-app".equals(string);
    }

    public static void zzr(List<AppIndexApi.AppIndexingLink> list) {
        if (list == null) {
            return;
        }
        for (AppIndexApi.AppIndexingLink appIndexingLink : list) {
            zzki.zzb(null, appIndexingLink.appIndexingUrl);
        }
    }

    @Override
    public PendingResult<Status> view(GoogleApiClient apiClient, Activity activity, Uri appIndexingUrl, String title, Uri webUrl, List<AppIndexApi.AppIndexingLink> outLinks) {
        String string = apiClient.getContext().getPackageName();
        zzki.zzb(string, appIndexingUrl);
        Intent intent = zzki.zza(string, appIndexingUrl);
        return this.view(apiClient, activity, intent, title, webUrl, outLinks);
    }

    @Override
    public PendingResult<Status> viewEnd(GoogleApiClient apiClient, Activity activity, Uri appUri) {
        String string = apiClient.getContext().getPackageName();
        Intent intent = zzki.zza(string, appUri);
        return this.viewEnd(apiClient, activity, intent);
    }

    @Override
    public AppIndexApi.ActionResult action(GoogleApiClient apiClient, Action action) {
        PendingResult<Status> pendingResult = this.zza(apiClient, action, 1);
        return new zza(this, pendingResult, action);
    }

    @Override
    public PendingResult<Status> start(GoogleApiClient apiClient, Action action) {
        return this.zza(apiClient, action, 1);
    }

    @Override
    public PendingResult<Status> end(GoogleApiClient apiClient, Action action) {
        return this.zza(apiClient, action, 2);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, Action action, int n) {
        String string = googleApiClient.getContext().getPackageName();
        long l = System.currentTimeMillis();
        UsageInfo usageInfo = zzkh.zza(action, l, string, n);
        return this.zza(googleApiClient, usageInfo);
    }

    @Deprecated
    private static final class zza
    implements AppIndexApi.ActionResult {
        private zzki zzTj;
        private PendingResult<Status> zzTk;
        private Action zzTl;

        zza(zzki zzki2, PendingResult<Status> pendingResult, Action action) {
            this.zzTj = zzki2;
            this.zzTk = pendingResult;
            this.zzTl = action;
        }

        @Override
        public PendingResult<Status> end(GoogleApiClient apiClient) {
            String string = apiClient.getContext().getPackageName();
            long l = System.currentTimeMillis();
            UsageInfo usageInfo = zzkh.zza(this.zzTl, l, string, 2);
            return this.zzTj.zza(apiClient, usageInfo);
        }

        @Override
        public PendingResult<Status> getPendingResult() {
            return this.zzTk;
        }
    }

    private static final class zzd
    extends zzkf<Status> {
        public zzd(zzlx.zzb<Status> zzb2) {
            super(zzb2);
        }

        @Override
        public void zza(Status status) {
            this.zzTf.zzr((Object)status);
        }
    }

    private static abstract class zzc<T extends Result>
    extends zzb<Status> {
        zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected Status zzb(Status status) {
            return status;
        }

        protected /* synthetic */ Result zzc(Status status) {
            return this.zzb(status);
        }
    }

    private static abstract class zzb<T extends Result>
    extends zzlx.zza<T, zzkg> {
        public zzb(GoogleApiClient googleApiClient) {
            super(com.google.android.gms.appdatasearch.zza.zzSe, googleApiClient);
        }

        protected final void zza(zzkg zzkg2) throws RemoteException {
            this.zza(zzkg2.zzlS());
        }

        protected abstract void zza(zzkd var1) throws RemoteException;
    }
}

