/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appindexing.builders;

import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.internal.zzaa;
import com.google.firebase.appindexing.FirebaseAppIndexingInvalidArgumentException;
import com.google.firebase.appindexing.Indexable;
import com.google.firebase.appindexing.internal.Thing;
import com.google.firebase.appindexing.internal.zzg;
import java.util.Arrays;

public abstract class IndexableBuilder<T extends IndexableBuilder<?>> {
    final Bundle he;
    final String zzcpo;
    Thing.Metadata aWz;
    String zzae;

    protected IndexableBuilder(@NonNull String string) {
        zzaa.zzy((Object)string);
        zzaa.zzib((String)string);
        this.he = new Bundle();
        this.zzcpo = string;
    }

    @KeepName
    public T put(@NonNull String string, String ... stringArray) {
        zzaa.zzy((Object)string);
        zzaa.zzy((Object)stringArray);
        if (stringArray.length > 0) {
            int n = 0;
            for (int i = 0; i < Math.min(stringArray.length, 100); ++i) {
                int n2;
                stringArray[n] = stringArray[i];
                if (stringArray[i] == null) {
                    n2 = i;
                    zzg.zzrr(new StringBuilder(59).append("String at ").append(n2).append(" is null and is ignored by put method.").toString());
                    continue;
                }
                if (stringArray[n].length() > 20000) {
                    n2 = i;
                    zzg.zzrr(new StringBuilder(53).append("String at ").append(n2).append(" is too long, truncating string.").toString());
                    stringArray[n] = stringArray[n].substring(0, 20000);
                }
                ++n;
            }
            if (n > 0) {
                stringArray = Arrays.copyOfRange(stringArray, 0, n);
                this.he.putStringArray(string, IndexableBuilder.zzd(stringArray));
            }
        } else {
            zzg.zzrr("String array is empty and is ignored by put method.");
        }
        return this.zzcoa();
    }

    @KeepName
    public T put(@NonNull String string, Indexable ... indexableArray) throws FirebaseAppIndexingInvalidArgumentException {
        zzaa.zzy((Object)string);
        zzaa.zzy((Object)indexableArray);
        Thing[] thingArray = new Thing[indexableArray.length];
        for (int i = 0; i < indexableArray.length; ++i) {
            if (indexableArray[i] != null && !(indexableArray[i] instanceof Thing)) {
                throw new FirebaseAppIndexingInvalidArgumentException("Invalid Indexable encountered. Use Indexable.Builder or convenience methods under Indexables to create the Indexable.");
            }
            thingArray[i] = (Thing)indexableArray[i];
        }
        this.zza(string, thingArray);
        return this.zzcoa();
    }

    private T zza(@NonNull String string, Thing ... thingArray) {
        zzaa.zzy((Object)string);
        zzaa.zzy((Object)thingArray);
        if (thingArray.length > 0) {
            int n = 0;
            for (int i = 0; i < thingArray.length; ++i) {
                thingArray[n] = thingArray[i];
                if (thingArray[i] == null) {
                    int n2 = i;
                    zzg.zzrr(new StringBuilder(58).append("Thing at ").append(n2).append(" is null and is ignored by put method.").toString());
                    continue;
                }
                ++n;
            }
            if (n > 0) {
                thingArray = Arrays.copyOfRange(thingArray, 0, n);
                this.he.putParcelableArray(string, (Parcelable[])IndexableBuilder.zzd(thingArray));
            }
        } else {
            zzg.zzrr("Thing array is empty and is ignored by put method.");
        }
        return this.zzcoa();
    }

    @KeepName
    public T put(@NonNull String string, boolean ... blArray) {
        zzaa.zzy((Object)string);
        zzaa.zzy((Object)blArray);
        if (blArray.length > 0) {
            this.he.putBooleanArray(string, IndexableBuilder.zza(blArray));
        } else {
            zzg.zzrr("Boolean array is empty and is ignored by put method.");
        }
        return this.zzcoa();
    }

    @KeepName
    public T put(@NonNull String string, long ... lArray) {
        zzaa.zzy((Object)string);
        zzaa.zzy((Object)lArray);
        if (lArray.length > 0) {
            this.he.putLongArray(string, IndexableBuilder.zzb(lArray));
        } else {
            zzg.zzrr("Long array is empty and is ignored by put method.");
        }
        return this.zzcoa();
    }

    @KeepName
    public final T setName(@NonNull String string) {
        zzaa.zzy((Object)string);
        return this.put("name", string);
    }

    @KeepName
    public final T setUrl(@NonNull String string) {
        zzaa.zzy((Object)string);
        this.zzae = string;
        return this.zzcoa();
    }

    @KeepName
    public final T setImage(@NonNull String string) {
        zzaa.zzy((Object)string);
        return this.put("image", string);
    }

    @KeepName
    public final T setDescription(@NonNull String string) {
        zzaa.zzy((Object)string);
        return this.put("description", string);
    }

    @KeepName
    public final T setSameAs(@NonNull String string) {
        zzaa.zzy((Object)string);
        return this.put("sameAs", string);
    }

    @KeepName
    public T setMetadata(@NonNull Indexable.Metadata.Builder builder) {
        zzaa.zza((this.aWz == null ? 1 : 0) != 0, (Object)"setMetadata may only be called once");
        zzaa.zzy((Object)builder);
        this.aWz = builder.zzcnz();
        return this.zzcoa();
    }

    @KeepName
    public final Indexable build() {
        return new Thing(new Bundle(this.he), this.aWz == null ? Indexable.Metadata.aWv : this.aWz, this.zzae, this.zzcpo);
    }

    protected <S extends IndexableBuilder> T put(@NonNull String string, S ... SArray) {
        zzaa.zzy((Object)string);
        zzaa.zzy(SArray);
        if (SArray.length > 0) {
            Thing[] thingArray = new Thing[SArray.length];
            for (int i = 0; i < SArray.length; ++i) {
                if (SArray[i] == null) {
                    int n = i;
                    zzg.zzrr(new StringBuilder(60).append("Builder at ").append(n).append(" is null and is ignored by put method.").toString());
                    continue;
                }
                thingArray[i] = (Thing)((IndexableBuilder)SArray[i]).build();
            }
            if (thingArray.length > 0) {
                this.zza(string, thingArray);
            }
        } else {
            zzg.zzrr("Builder array is empty and is ignored by put method.");
        }
        return this.zzcoa();
    }

    private T zzcoa() {
        return (T)this;
    }

    private static <S> S[] zzd(S[] SArray) {
        if (SArray.length < 100) {
            return SArray;
        }
        zzg.zzrr("Input Array of elements is too big, cutting off.");
        return Arrays.copyOf(SArray, 100);
    }

    private static long[] zzb(long[] lArray) {
        if (lArray.length < 100) {
            return lArray;
        }
        zzg.zzrr("Input Array of elements is too big, cutting off.");
        return Arrays.copyOf(lArray, 100);
    }

    private static boolean[] zza(boolean[] blArray) {
        if (blArray.length < 100) {
            return blArray;
        }
        zzg.zzrr("Input Array of elements is too big, cutting off.");
        return Arrays.copyOf(blArray, 100);
    }
}

