/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appinvite;

import android.accounts.Account;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbp;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;

public final class AppInviteInvitation {
    private static final String[] zzdwq = new String[]{"jpg", "jpeg", "png"};

    private AppInviteInvitation() {
    }

    public static String[] getInvitationIds(int n, @NonNull Intent intent) {
        if (n == -1) {
            return intent.getStringArrayExtra("com.google.android.gms.appinvite.RESULT_INVITATION_IDS");
        }
        return null;
    }

    private static Bundle zzm(Map<String, String> map) {
        Bundle bundle = new Bundle();
        for (String string : map.keySet()) {
            bundle.putString(string, map.get(string));
        }
        return bundle;
    }

    private static boolean zzei(String string) {
        for (int i = 0; i < zzdwq.length; ++i) {
            if (!zzdwq[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static final class IntentBuilder {
        public static final int MAX_MESSAGE_LENGTH = 100;
        public static final int MAX_EMAIL_HTML_CONTENT = 512000;
        public static final int MIN_CALL_TO_ACTION_TEXT_LENGTH = 2;
        public static final int MAX_CALL_TO_ACTION_TEXT_LENGTH = 20;
        private final Intent mIntent;
        private String zzdwr;
        private String zzdws;

        public IntentBuilder(@NonNull CharSequence charSequence) {
            zzbp.zzu((Object)charSequence);
            this.mIntent = new Intent("com.google.android.gms.appinvite.ACTION_APP_INVITE");
            this.mIntent.putExtra("com.google.android.gms.appinvite.TITLE", charSequence);
            this.mIntent.setPackage("com.google.android.gms");
        }

        public final IntentBuilder setAccount(Account account) {
            if (account != null && "com.google".equals(account.type)) {
                this.mIntent.putExtra("com.google.android.gms.appinvite.ACCOUNT_NAME", (Parcelable)account);
            } else {
                this.mIntent.removeExtra("com.google.android.gms.appinvite.ACCOUNT_NAME");
            }
            return this;
        }

        public final IntentBuilder setMessage(CharSequence charSequence) {
            if (charSequence != null && charSequence.length() > 100) {
                throw new IllegalArgumentException(String.format("Message must be %d chars or less.", 100));
            }
            this.mIntent.putExtra("com.google.android.gms.appinvite.MESSAGE", charSequence);
            return this;
        }

        public final IntentBuilder setEmailSubject(String string) {
            this.zzdwr = string;
            return this;
        }

        public final IntentBuilder setEmailHtmlContent(String string) {
            if (string != null && string.getBytes().length > 512000) {
                throw new IllegalArgumentException(String.format("Email html content must be %d bytes or less.", 512000));
            }
            this.zzdws = string;
            return this;
        }

        public final IntentBuilder setDeepLink(Uri uri) {
            if (uri != null) {
                this.mIntent.putExtra("com.google.android.gms.appinvite.DEEP_LINK_URL", (Parcelable)uri);
            } else {
                this.mIntent.removeExtra("com.google.android.gms.appinvite.DEEP_LINK_URL");
            }
            return this;
        }

        public final IntentBuilder setAdditionalReferralParameters(Map<String, String> map) {
            if (map != null) {
                this.mIntent.putExtra("com.google.android.gms.appinvite.REFERRAL_PARAMETERS_URI", AppInviteInvitation.zzm(map));
            } else {
                this.mIntent.removeExtra("com.google.android.gms.appinvite.REFERRAL_PARAMETERS_URI");
            }
            return this;
        }

        public final IntentBuilder setGoogleAnalyticsTrackingId(String string) {
            this.mIntent.putExtra("com.google.android.gms.appinvite.GOOGLE_ANALYTICS_TRACKING_ID", string);
            return this;
        }

        public final IntentBuilder setAndroidMinimumVersionCode(int n) {
            this.mIntent.putExtra("com.google.android.gms.appinvite.appMinimumVersionCode", n);
            return this;
        }

        public final IntentBuilder setCustomImage(Uri uri) {
            String string;
            zzbp.zzu((Object)uri);
            zzbp.zzb((boolean)uri.isAbsolute(), (Object)"Image uri is not an absolute uri. Did you forget to add a scheme to the Uri?");
            String string2 = uri.getScheme().toLowerCase();
            boolean bl = string2.equals("android.resource") || string2.equals("content") || string2.equals("file");
            zzbp.zzb((bl || string2.equals("http") || string2.equals("https") ? 1 : 0) != 0, (Object)"Image uri must be a content URI with scheme \"android.resource\", \"content\" or \"file\", or a network url with scheme \"http\" or \"https\".");
            if (!bl) {
                string = uri.toString();
                String string3 = string.substring(string.lastIndexOf("/") + 1, string.length());
                String string4 = string3 == null ? null : (string3.lastIndexOf(".") == -1 ? null : string3.substring(string3.lastIndexOf(".") + 1, string3.length()).toLowerCase());
                zzbp.zzb((TextUtils.isEmpty(string4) || AppInviteInvitation.zzei(string4) ? 1 : 0) != 0, (Object)String.valueOf(string4).concat(" images are not supported. Only jpg, jpeg, or png images are supported."));
            }
            string = uri.buildUpon().scheme(string2).build();
            this.mIntent.setData((Uri)string);
            if (bl) {
                this.mIntent.addFlags(1);
            }
            return this;
        }

        public final IntentBuilder setCallToActionText(CharSequence charSequence) {
            if (charSequence == null || charSequence.length() < 2 || charSequence.length() > 20) {
                throw new IllegalArgumentException(String.format("Text must be between %d and %d chars in length.", 2, 20));
            }
            this.mIntent.putExtra("com.google.android.gms.appinvite.BUTTON_TEXT", charSequence);
            return this;
        }

        public final IntentBuilder setOtherPlatformsTargetApplication(int n, String string) throws IllegalArgumentException {
            switch (n) {
                case 1: {
                    this.mIntent.putExtra("com.google.android.gms.appinvite.iosTargetApplication", string);
                    break;
                }
                case 2: {
                    this.mIntent.putExtra("com.google.android.gms.appinvite.androidTargetApplication", string);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("targetPlatform must be either PROJECT_PLATFORM_IOS or PROJECT_PLATFORM_ANDROID.");
                }
            }
            return this;
        }

        public final Intent build() {
            if (!TextUtils.isEmpty((CharSequence)this.zzdwr)) {
                zzbp.zzh((String)this.zzdws, (Object)"Email html content must be set when email subject is set.");
                zzbp.zzb((this.mIntent.getData() == null ? 1 : 0) != 0, (Object)"Custom image must not be set when email html content is set.");
                zzbp.zzb((boolean)TextUtils.isEmpty((CharSequence)this.mIntent.getCharSequenceExtra("com.google.android.gms.appinvite.BUTTON_TEXT")), (Object)"Call to action text must not be set when email html content is set.");
                this.mIntent.putExtra("com.google.android.gms.appinvite.EMAIL_SUBJECT", this.zzdwr);
                this.mIntent.putExtra("com.google.android.gms.appinvite.EMAIL_CONTENT", this.zzdws);
            } else if (!TextUtils.isEmpty((CharSequence)this.zzdws)) {
                throw new IllegalArgumentException("Email subject must be set when email html content is set.");
            }
            return this.mIntent;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface PlatformMode {
            public static final int PROJECT_PLATFORM_IOS = 1;
            public static final int PROJECT_PLATFORM_ANDROID = 2;
        }
    }
}

