/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appinvite;

import android.accounts.Account;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzx;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;

public final class AppInviteInvitation {
    private AppInviteInvitation() {
    }

    public static String[] getInvitationIds(int resultCode, Intent result) {
        if (resultCode == -1) {
            return result.getStringArrayExtra("com.google.android.gms.appinvite.RESULT_INVITATION_IDS");
        }
        return null;
    }

    private static Bundle zzC(Map<String, String> map) {
        Bundle bundle = new Bundle();
        for (String string : map.keySet()) {
            bundle.putString(string, map.get(string));
        }
        return bundle;
    }

    public static final class IntentBuilder {
        public static final int MAX_MESSAGE_LENGTH = 100;
        public static final int MIN_CALL_TO_ACTION_TEXT_LENGTH = 2;
        public static final int MAX_CALL_TO_ACTION_TEXT_LENGTH = 20;
        private final Intent mIntent;

        public IntentBuilder(CharSequence title) {
            zzx.zzw((Object)title);
            this.mIntent = new Intent("com.google.android.gms.appinvite.ACTION_APP_INVITE");
            this.mIntent.putExtra("com.google.android.gms.appinvite.TITLE", title);
            this.mIntent.setPackage("com.google.android.gms");
        }

        public IntentBuilder setAccount(Account account) {
            if (account != null && "com.google".equals(account.type)) {
                this.mIntent.putExtra("com.google.android.gms.appinvite.ACCOUNT_NAME", (Parcelable)account);
            } else {
                this.mIntent.removeExtra("com.google.android.gms.appinvite.ACCOUNT_NAME");
            }
            return this;
        }

        public IntentBuilder setMessage(CharSequence message) {
            if (message != null && message.length() > 100) {
                throw new IllegalArgumentException(String.format("Message must be %d chars or less.", 100));
            }
            this.mIntent.putExtra("com.google.android.gms.appinvite.MESSAGE", message);
            return this;
        }

        public IntentBuilder setDeepLink(Uri deepLink) {
            if (deepLink != null) {
                this.mIntent.putExtra("com.google.android.gms.appinvite.DEEP_LINK_URL", (Parcelable)deepLink);
            } else {
                this.mIntent.removeExtra("com.google.android.gms.appinvite.DEEP_LINK_URL");
            }
            return this;
        }

        public IntentBuilder setAdditionalReferralParameters(Map<String, String> params) {
            if (params != null) {
                this.mIntent.putExtra("com.google.android.gms.appinvite.REFERRAL_PARAMETERS_URI", AppInviteInvitation.zzC(params));
            } else {
                this.mIntent.removeExtra("com.google.android.gms.appinvite.REFERRAL_PARAMETERS_URI");
            }
            return this;
        }

        public IntentBuilder setGoogleAnalyticsTrackingId(String trackingId) {
            this.mIntent.putExtra("com.google.android.gms.appinvite.GOOGLE_ANALYTICS_TRACKING_ID", trackingId);
            return this;
        }

        public IntentBuilder setAndroidMinimumVersionCode(int versionCode) {
            this.mIntent.putExtra("com.google.android.gms.appinvite.appMinimumVersionCode", versionCode);
            return this;
        }

        public IntentBuilder setCustomImage(Uri imageUri) {
            zzx.zzw((Object)imageUri);
            zzx.zzb((boolean)imageUri.isAbsolute(), (Object)"Image uri is not an absolute uri. Did you forget to add a scheme to the Uri?");
            String string = imageUri.getScheme().toLowerCase();
            zzx.zzb((string.equals("http") || string.equals("https") ? 1 : 0) != 0, (Object)"Image uri must be a network url with scheme \"http\" or \"https\".");
            Uri uri = imageUri.buildUpon().scheme(string).build();
            this.mIntent.setData(uri);
            return this;
        }

        public IntentBuilder setCallToActionText(CharSequence callToActionText) {
            if (callToActionText == null || callToActionText.length() < 2 || callToActionText.length() > 20) {
                throw new IllegalArgumentException(String.format("Text must be between %d and %d chars in length.", 2, 20));
            }
            this.mIntent.putExtra("com.google.android.gms.appinvite.BUTTON_TEXT", callToActionText);
            return this;
        }

        public IntentBuilder setOtherPlatformsTargetApplication(int targetPlatform, String clientId) throws IllegalArgumentException {
            switch (targetPlatform) {
                case 1: {
                    this.mIntent.putExtra("com.google.android.gms.appinvite.iosTargetApplication", clientId);
                    break;
                }
                case 2: {
                    this.mIntent.putExtra("com.google.android.gms.appinvite.androidTargetApplication", clientId);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("targetPlatform must be either PROJECT_PLATFORM_IOS or PROJECT_PLATFORM_ANDROID.");
                }
            }
            return this;
        }

        public Intent build() {
            return this.mIntent;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface PlatformMode {
            public static final int PROJECT_PLATFORM_IOS = 1;
            public static final int PROJECT_PLATFORM_ANDROID = 2;
        }
    }
}

