/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appstate;

import android.content.Context;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.appstate.AppStateBuffer;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzjl;

@Deprecated
public final class AppStateManager {
    static final Api.zzc<zzjl> zzGR = new Api.zzc();
    private static final Api.zzb<zzjl, Api.ApiOptions.NoOptions> zzGS = new Api.zzb<zzjl, Api.ApiOptions.NoOptions>(){

        public zzjl zzb(Context context, Looper looper, zzf zzf2, Api.ApiOptions.NoOptions noOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return new zzjl(context, looper, zzf2, connectionCallbacks, onConnectionFailedListener);
        }

        public int getPriority() {
            return Integer.MAX_VALUE;
        }

        public /* synthetic */ Api.zza zza(Context context, Looper looper, zzf zzf2, Object object, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return this.zzb(context, looper, zzf2, (Api.ApiOptions.NoOptions)object, connectionCallbacks, onConnectionFailedListener);
        }
    };
    public static final Scope SCOPE_APP_STATE = new Scope("https://www.googleapis.com/auth/appstate");
    public static final Api<Api.ApiOptions.NoOptions> API = new Api(zzGS, zzGR, new Scope[]{SCOPE_APP_STATE});

    private AppStateManager() {
    }

    public static zzjl zza(GoogleApiClient googleApiClient) {
        zzx.zzb((googleApiClient != null ? 1 : 0) != 0, (Object)"GoogleApiClient parameter is required.");
        zzx.zza((boolean)googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        zzx.zza((boolean)googleApiClient.zza(API), (Object)"GoogleApiClient is not configured to use the AppState API. Pass AppStateManager.API into GoogleApiClient.Builder#addApi() to use this feature.");
        return (zzjl)googleApiClient.zza(zzGR);
    }

    public static int getMaxStateSize(GoogleApiClient googleApiClient) {
        return AppStateManager.zza(googleApiClient).zzhd();
    }

    public static int getMaxNumKeys(GoogleApiClient googleApiClient) {
        return AppStateManager.zza(googleApiClient).zzhe();
    }

    private static StateResult zzc(final Status status) {
        return new StateResult(){

            public Status getStatus() {
                return status;
            }

            @Override
            public StateLoadedResult getLoadedResult() {
                return null;
            }

            @Override
            public StateConflictResult getConflictResult() {
                return null;
            }

            public void release() {
            }
        };
    }

    public static void update(GoogleApiClient googleApiClient, final int stateKey, final byte[] data) {
        googleApiClient.zzb((zza.zza)new zze(googleApiClient){

            protected void zza(zzjl zzjl2) throws RemoteException {
                zzjl2.zza(null, stateKey, data);
            }
        });
    }

    public static PendingResult<StateResult> updateImmediate(GoogleApiClient googleApiClient, final int stateKey, final byte[] data) {
        return googleApiClient.zzb((zza.zza)new zze(googleApiClient){

            protected void zza(zzjl zzjl2) throws RemoteException {
                zzjl2.zza((zza.zzb<StateResult>)this, stateKey, data);
            }
        });
    }

    public static PendingResult<StateDeletedResult> delete(GoogleApiClient googleApiClient, final int stateKey) {
        return googleApiClient.zzb((zza.zza)new zzb(googleApiClient){

            protected void zza(zzjl zzjl2) throws RemoteException {
                zzjl2.zza((zza.zzb<StateDeletedResult>)this, stateKey);
            }

            public StateDeletedResult zze(final Status status) {
                return new StateDeletedResult(){

                    public Status getStatus() {
                        return status;
                    }

                    @Override
                    public int getStateKey() {
                        return stateKey;
                    }
                };
            }

            public /* synthetic */ Result createFailedResult(Status x0) {
                return this.zze(x0);
            }
        });
    }

    public static PendingResult<StateResult> load(GoogleApiClient googleApiClient, final int stateKey) {
        return googleApiClient.zza((zza.zza)new zze(googleApiClient){

            protected void zza(zzjl zzjl2) throws RemoteException {
                zzjl2.zzb((zza.zzb<StateResult>)this, stateKey);
            }
        });
    }

    public static PendingResult<StateListResult> list(GoogleApiClient googleApiClient) {
        return googleApiClient.zza((zza.zza)new zzc(googleApiClient){

            protected void zza(zzjl zzjl2) throws RemoteException {
                zzjl2.zza((zza.zzb<StateListResult>)this);
            }
        });
    }

    public static PendingResult<StateResult> resolve(GoogleApiClient googleApiClient, final int stateKey, final String resolvedVersion, final byte[] resolvedData) {
        return googleApiClient.zzb((zza.zza)new zze(googleApiClient){

            protected void zza(zzjl zzjl2) throws RemoteException {
                zzjl2.zza((zza.zzb<StateResult>)this, stateKey, resolvedVersion, resolvedData);
            }
        });
    }

    public static PendingResult<Status> signOut(GoogleApiClient googleApiClient) {
        return googleApiClient.zzb((zza.zza)new zzd(googleApiClient){

            protected void zza(zzjl zzjl2) throws RemoteException {
                zzjl2.zzb((zza.zzb<Status>)this);
            }
        });
    }

    private static abstract class zzd
    extends zza<Status> {
        public zzd(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Status zzb(Status status) {
            return status;
        }

        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzb(x0);
        }
    }

    private static abstract class zzc
    extends zza<StateListResult> {
        public zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public StateListResult zzf(final Status status) {
            return new StateListResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public AppStateBuffer getStateBuffer() {
                    return new AppStateBuffer(null);
                }
            };
        }

        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzf(x0);
        }
    }

    public static interface StateListResult
    extends Result {
        public AppStateBuffer getStateBuffer();
    }

    private static abstract class zzb
    extends zza<StateDeletedResult> {
        zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }
    }

    public static interface StateDeletedResult
    extends Result {
        public int getStateKey();
    }

    private static abstract class zze
    extends zza<StateResult> {
        public zze(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public StateResult zzg(Status status) {
            return AppStateManager.zzc(status);
        }

        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzg(x0);
        }
    }

    public static interface StateConflictResult
    extends Releasable,
    Result {
        public int getStateKey();

        public String getResolvedVersion();

        public byte[] getLocalData();

        public byte[] getServerData();
    }

    public static interface StateLoadedResult
    extends Releasable,
    Result {
        public int getStateKey();

        public byte[] getLocalData();
    }

    public static interface StateResult
    extends Releasable,
    Result {
        public StateLoadedResult getLoadedResult();

        public StateConflictResult getConflictResult();
    }

    public static abstract class zza<R extends Result>
    extends zza.zza<R, zzjl> {
        public zza(GoogleApiClient googleApiClient) {
            super(zzGR, googleApiClient);
        }
    }
}

