/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth;

import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;

public final class CookieUtil {
    private CookieUtil() {
    }

    private static boolean zza(Boolean bl) {
        return bl != null && bl != false;
    }

    public static String getCookieUrl(String string, Boolean bl) {
        Preconditions.checkNotEmpty((String)string);
        String string2 = CookieUtil.zza(bl) ? "https" : "http";
        return new StringBuilder(3 + String.valueOf(string2).length() + String.valueOf(string).length()).append(string2).append("://").append(string).toString();
    }

    public static String getCookieValue(String string, String string2, String string3, String string4, Boolean bl, Boolean bl2, Long l) {
        StringBuilder stringBuilder = new StringBuilder(string).append('=');
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            stringBuilder.append(string2);
        }
        if (CookieUtil.zza(bl)) {
            stringBuilder.append(";HttpOnly");
        }
        if (CookieUtil.zza(bl2)) {
            stringBuilder.append(";Secure");
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            stringBuilder.append(";Domain=").append(string3);
        }
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            stringBuilder.append(";Path=").append(string4);
        }
        if (l != null && l > 0L) {
            stringBuilder.append(";Max-Age=").append(l);
        }
        return stringBuilder.toString();
    }
}

