/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import android.support.annotation.RequiresPermission;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.auth.AccountChangeEvent;
import com.google.android.gms.auth.AccountChangeEventsRequest;
import com.google.android.gms.auth.AccountChangeEventsResponse;
import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GooglePlayServicesAvailabilityException;
import com.google.android.gms.auth.TokenData;
import com.google.android.gms.auth.UserRecoverableAuthException;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzm;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzbn;
import com.google.android.gms.internal.zzmx;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;

public class zzd {
    public static final String GOOGLE_ACCOUNT_TYPE = "com.google";
    public static final String WORK_ACCOUNT_TYPE = "com.google.work";
    public static final String KEY_REQUEST_ACTIONS = "request_visible_actions";
    public static final String KEY_SUPPRESS_PROGRESS_SCREEN = "suppressProgressScreen";
    @Deprecated
    public static final String KEY_REQUEST_VISIBLE_ACTIVITIES = "request_visible_actions";
    public static final String KEY_CALLER_UID = Build.VERSION.SDK_INT >= 11 ? "callerUid" : "callerUid";
    public static final String KEY_ANDROID_PACKAGE_NAME = Build.VERSION.SDK_INT >= 14 ? "androidPackageName" : "androidPackageName";
    public static final int CHANGE_TYPE_ACCOUNT_ADDED = 1;
    public static final int CHANGE_TYPE_ACCOUNT_REMOVED = 2;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_FROM = 3;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_TO = 4;
    private static final ComponentName zzaaV = new ComponentName("com.google.android.gms", "com.google.android.gms.auth.GetToken");
    private static final ComponentName zzaaW = new ComponentName("com.google.android.gms", "com.google.android.gms.recovery.RecoveryService");

    @Deprecated
    public static String getToken(Context context, String string, String string2) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        Account account = new Account(string, GOOGLE_ACCOUNT_TYPE);
        return zzd.getToken(context, account, string2);
    }

    @Deprecated
    public static String getToken(Context context, String string, String string2, Bundle bundle) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        Account account = new Account(string, GOOGLE_ACCOUNT_TYPE);
        return zzd.getToken(context, account, string2, bundle);
    }

    public static String getToken(Context context, Account account, String string) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        return zzd.getToken(context, account, string, new Bundle());
    }

    public static String getToken(Context context, Account account, String string, Bundle bundle) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        TokenData tokenData = zzd.zzc(context, account, string, bundle);
        return tokenData.getToken();
    }

    public static TokenData zzc(Context context, final Account account, final String string, Bundle bundle) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        zzaa.zzdd((String)"Calling this from your main thread can lead to deadlock");
        zzaa.zzh((String)string, (Object)"Scope cannot be empty or null.");
        zzaa.zzb((Object)account, (Object)"Account cannot be null.");
        zzd.zzaa(context);
        final Bundle bundle2 = bundle == null ? new Bundle() : new Bundle(bundle);
        String string2 = context.getApplicationInfo().packageName;
        bundle2.putString("clientPackageName", string2);
        if (TextUtils.isEmpty((CharSequence)bundle2.getString(KEY_ANDROID_PACKAGE_NAME))) {
            bundle2.putString(KEY_ANDROID_PACKAGE_NAME, string2);
        }
        bundle2.putLong("service_connection_start_time_millis", SystemClock.elapsedRealtime());
        zza<TokenData> zza2 = new zza<TokenData>(){

            public TokenData zzar(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                zzbn zzbn2 = zzbn.zza.zza(iBinder);
                Bundle bundle = (Bundle)zzd.zzn(zzbn2.zza(account, string, bundle2));
                TokenData tokenData = TokenData.zzd(bundle, "tokenDetails");
                if (tokenData != null) {
                    return tokenData;
                }
                String string2 = bundle.getString("Error");
                Intent intent = (Intent)bundle.getParcelable("userRecoveryIntent");
                zzmx zzmx2 = zzmx.zzcv(string2);
                if (zzmx.zza(zzmx2)) {
                    throw new UserRecoverableAuthException(string2, intent);
                }
                if (zzmx.zzb(zzmx2)) {
                    throw new IOException(string2);
                }
                throw new GoogleAuthException(string2);
            }

            @Override
            public /* synthetic */ Object zzas(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                return this.zzar(iBinder);
            }
        };
        return zzd.zza(context, zzaaV, zza2);
    }

    @Deprecated
    @RequiresPermission(value="android.permission.MANAGE_ACCOUNTS")
    public static void invalidateToken(Context context, String string) {
        AccountManager.get((Context)context).invalidateAuthToken(GOOGLE_ACCOUNT_TYPE, string);
    }

    public static void clearToken(Context context, final String string) throws GooglePlayServicesAvailabilityException, GoogleAuthException, IOException {
        zzaa.zzdd((String)"Calling this from your main thread can lead to deadlock");
        zzd.zzaa(context);
        final Bundle bundle = new Bundle();
        String string2 = context.getApplicationInfo().packageName;
        bundle.putString("clientPackageName", string2);
        if (!bundle.containsKey(KEY_ANDROID_PACKAGE_NAME)) {
            bundle.putString(KEY_ANDROID_PACKAGE_NAME, string2);
        }
        zza<Void> zza2 = new zza<Void>(){

            public Void zzat(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                zzbn zzbn2 = zzbn.zza.zza(iBinder);
                Bundle bundle2 = (Bundle)zzd.zzn(zzbn2.zza(string, bundle));
                String string2 = bundle2.getString("Error");
                if (!bundle2.getBoolean("booleanResult")) {
                    throw new GoogleAuthException(string2);
                }
                return null;
            }

            @Override
            public /* synthetic */ Object zzas(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                return this.zzat(iBinder);
            }
        };
        zzd.zza(context, zzaaV, zza2);
    }

    public static List<AccountChangeEvent> getAccountChangeEvents(Context context, final int n, final String string) throws GoogleAuthException, IOException {
        zzaa.zzh((String)string, (Object)"accountName must be provided");
        zzaa.zzdd((String)"Calling this from your main thread can lead to deadlock");
        zzd.zzaa(context);
        zza<List<AccountChangeEvent>> zza2 = new zza<List<AccountChangeEvent>>(){

            public List<AccountChangeEvent> zzau(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                zzbn zzbn2 = zzbn.zza.zza(iBinder);
                AccountChangeEventsRequest accountChangeEventsRequest = new AccountChangeEventsRequest().setAccountName(string).setEventIndex(n);
                AccountChangeEventsResponse accountChangeEventsResponse = (AccountChangeEventsResponse)((Object)zzd.zzn((Object)zzbn2.zza(accountChangeEventsRequest)));
                return accountChangeEventsResponse.getEvents();
            }

            @Override
            public /* synthetic */ Object zzas(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                return this.zzau(iBinder);
            }
        };
        return zzd.zza(context, zzaaV, zza2);
    }

    public static String getAccountId(Context context, String string) throws GoogleAuthException, IOException {
        zzaa.zzh((String)string, (Object)"accountName must be provided");
        zzaa.zzdd((String)"Calling this from your main thread can lead to deadlock");
        zzd.zzaa(context);
        return zzd.getToken(context, string, "^^_account_id_^^", new Bundle());
    }

    @TargetApi(value=23)
    public static Bundle removeAccount(Context context, final Account account) throws GoogleAuthException, IOException {
        zzaa.zzz((Object)context);
        zzaa.zzb((Object)account, (Object)"Account cannot be null.");
        zzd.zzaa(context);
        zza<Bundle> zza2 = new zza<Bundle>(){

            public Bundle zzav(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                zzbn zzbn2 = zzbn.zza.zza(iBinder);
                return (Bundle)zzd.zzn(zzbn2.zza(account));
            }

            @Override
            public /* synthetic */ Object zzas(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                return this.zzav(iBinder);
            }
        };
        return zzd.zza(context, zzaaV, zza2);
    }

    static void zzi(Intent intent) {
        if (intent == null) {
            throw new IllegalArgumentException("Callback cannot be null.");
        }
        String string = intent.toUri(1);
        try {
            Intent.parseUri((String)string, (int)1);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Parameter callback contains invalid data. It must be serializable using toUri() and parseUri().");
        }
    }

    private static void zzaa(Context context) throws GoogleAuthException {
        try {
            zze.zzaa((Context)context.getApplicationContext());
        }
        catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
            throw new GooglePlayServicesAvailabilityException(googlePlayServicesRepairableException.getConnectionStatusCode(), googlePlayServicesRepairableException.getMessage(), googlePlayServicesRepairableException.getIntent());
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            throw new GoogleAuthException(googlePlayServicesNotAvailableException.getMessage());
        }
    }

    private static <T> T zzn(T t) throws IOException {
        if (t == null) {
            Log.w((String)"GoogleAuthUtil", (String)"Binder call returned null.");
            throw new IOException("Service unavailable.");
        }
        return t;
    }

    private static <T> T zza(Context context, ComponentName componentName, zza<T> zza2) throws IOException, GoogleAuthException {
        com.google.android.gms.common.zza zza3 = new com.google.android.gms.common.zza();
        zzm zzm2 = zzm.zzav((Context)context);
        if (zzm2.zza(componentName, (ServiceConnection)zza3, "GoogleAuthUtil")) {
            try {
                T t = zza2.zzas(zza3.zzqU());
                return t;
            }
            catch (RemoteException | InterruptedException throwable) {
                Log.i((String)"GoogleAuthUtil", (String)"Error on service connection.", (Throwable)throwable);
                throw new IOException("Error on service connection.", throwable);
            }
            finally {
                zzm2.zzb(componentName, (ServiceConnection)zza3, "GoogleAuthUtil");
            }
        }
        throw new IOException("Could not bind to service.");
    }

    zzd() {
    }

    private static interface zza<T> {
        public T zzas(IBinder var1) throws RemoteException, IOException, GoogleAuthException;
    }
}

