/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.blockstore;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.google.android.gms.auth.blockstore.zzb;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@SafeParcelable.Class(creator="DeleteBytesRequestCreator")
public class DeleteBytesRequest
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<DeleteBytesRequest> CREATOR = new zzb();
    @SafeParcelable.Field(id=1, getter="getKeys")
    private final List zza;
    @SafeParcelable.Field(id=2, getter="getDeleteAll", defaultValue="false")
    private final boolean zzb;

    @NonNull
    public List<String> getKeys() {
        return Collections.unmodifiableList(this.zza);
    }

    /*
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    DeleteBytesRequest(@SafeParcelable.Param(id=1) List iterator, @SafeParcelable.Param(id=2) boolean bl) {
        if (bl) {
            boolean bl2 = iterator != null ? iterator.isEmpty() : true;
            Preconditions.checkState((boolean)bl2, (Object)"deleteAll was set to true but other constraint(s) was also provided: keys");
        }
        this.zzb = bl;
        this.zza = new ArrayList();
        if (iterator != null) {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Preconditions.checkNotEmpty((String)string, (Object)"Element in keys cannot be null or empty");
                this.zza.add(string);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int n) {
        void var1_1;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeStringList((Parcel)var1_1, (int)1, this.getKeys(), (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeBoolean((Parcel)v1, (int)2, (boolean)this.getDeleteAll());
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    public boolean getDeleteAll() {
        return this.zzb;
    }

    public static final class Builder {
        private List zza = new ArrayList();
        private boolean zzb = false;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setDeleteAll(boolean deleteAll) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setKeys(@NonNull List<String> keys) {
            void var1_1;
            Preconditions.checkNotNull(keys, (Object)"Keys cannot be set to null");
            this.zza = var1_1;
            return this;
        }

        @NonNull
        public DeleteBytesRequest build() {
            return new DeleteBytesRequest(this.zza, this.zzb);
        }
    }
}

