/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.blockstore;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.google.android.gms.auth.blockstore.zze;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;

@SafeParcelable.Class(creator="StoreBytesDataCreator")
public class StoreBytesData
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<StoreBytesData> CREATOR = new zze();
    @SafeParcelable.Field(id=1, getter="getBytes")
    private final byte[] zza;
    @SafeParcelable.Field(id=2, getter="shouldBackupToCloud", defaultValue="false")
    private final boolean zzb;
    @SafeParcelable.Field(id=3, getter="getKey", defaultValue="com.google.android.gms.auth.blockstore.DEFAULT_BYTES_DATA_KEY")
    private final String zzc;

    @NonNull
    public String getKey() {
        return this.zzc;
    }

    @SafeParcelable.Constructor
    StoreBytesData(@SafeParcelable.Param(id=1) byte[] byArray, @SafeParcelable.Param(id=2) boolean bl, @SafeParcelable.Param(id=3) String string) {
        this.zza = byArray;
        this.zzb = bl;
        this.zzc = string;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int n) {
        void var1_1;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeByteArray((Parcel)var1_1, (int)1, (byte[])this.getBytes(), (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)2, (boolean)this.shouldBackupToCloud());
        void v1 = var1_1;
        SafeParcelWriter.writeString((Parcel)v1, (int)3, (String)this.getKey(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    public boolean shouldBackupToCloud() {
        return this.zzb;
    }

    @NonNull
    public byte[] getBytes() {
        return this.zza;
    }

    public static final class Builder {
        private byte[] zza;
        private boolean zzb;
        private String zzc = "com.google.android.gms.auth.blockstore.DEFAULT_BYTES_DATA_KEY";

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setBytes(@NonNull byte[] bytes) {
            void var1_1;
            this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setKey(@NonNull String key) {
            void var1_1;
            Preconditions.checkNotEmpty((String)key, (Object)"key cannot be null or empty");
            this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setShouldBackupToCloud(boolean shouldBackupToCloud) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        @NonNull
        public StoreBytesData build() {
            return new StoreBytesData(this.zza, this.zzb, this.zzc);
        }
    }
}

