/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.android.gms.auth.api.credentials.zzf;
import com.google.android.gms.common.internal.ReflectedParcelable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;

public final class PasswordSpecification
extends com.google.android.gms.common.internal.safeparcel.zza
implements ReflectedParcelable {
    public static final Parcelable.Creator<PasswordSpecification> CREATOR = new zzf();
    public static final PasswordSpecification zzajC = new zza().zzm(12, 16).zzcs("abcdefghijkmnopqrstxyzABCDEFGHJKLMNPQRSTXY3456789").zzf("abcdefghijkmnopqrstxyz", 1).zzf("ABCDEFGHJKLMNPQRSTXY", 1).zzf("3456789", 1).zzqZ();
    public static final PasswordSpecification zzajD = new zza().zzm(12, 16).zzcs("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890").zzf("abcdefghijklmnopqrstuvwxyz", 1).zzf("ABCDEFGHIJKLMNOPQRSTUVWXYZ", 1).zzf("1234567890", 1).zzqZ();
    final int zzaiI;
    final String zzajE;
    final List<String> zzajF;
    final List<Integer> zzajG;
    final int zzajH;
    final int zzajI;
    private final int[] zzajJ;
    private final Random zzzW;

    PasswordSpecification(int n, String string, List<String> list, List<Integer> list2, int n2, int n3) {
        this.zzaiI = n;
        this.zzajE = string;
        this.zzajF = Collections.unmodifiableList(list);
        this.zzajG = Collections.unmodifiableList(list2);
        this.zzajH = n2;
        this.zzajI = n3;
        this.zzajJ = this.zzqY();
        this.zzzW = new SecureRandom();
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzf.zza(this, parcel, n);
    }

    private int[] zzqY() {
        int[] nArray = new int[95];
        Arrays.fill(nArray, -1);
        int n = 0;
        for (String string : this.zzajF) {
            for (char c : string.toCharArray()) {
                nArray[this.zza((char)c)] = n;
            }
            ++n;
        }
        return nArray;
    }

    private int zza(char c) {
        return c - 32;
    }

    private static String zzb(Collection<Character> collection) {
        char[] cArray = new char[collection.size()];
        int n = 0;
        for (char c : collection) {
            cArray[n++] = c;
        }
        return new String(cArray);
    }

    private static boolean zzc(int n, int n2, int n3) {
        return n < n2 || n > n3;
    }

    public static class zzb
    extends Error {
        public zzb(String string) {
            super(string);
        }
    }

    public static class zza {
        private final TreeSet<Character> zzajK = new TreeSet();
        private final List<String> zzajF = new ArrayList<String>();
        private final List<Integer> zzajG = new ArrayList<Integer>();
        private int zzajH = 12;
        private int zzajI = 16;

        public zza zzcs(@NonNull String string) {
            this.zzajK.addAll(this.zzw(string, "allowedChars"));
            return this;
        }

        public zza zzf(@NonNull String string, int n) {
            if (n < 1) {
                throw new zzb("count must be at least 1");
            }
            TreeSet<Character> treeSet = this.zzw(string, "requiredChars");
            this.zzajF.add(PasswordSpecification.zzb(treeSet));
            this.zzajG.add(n);
            return this;
        }

        public zza zzm(int n, int n2) {
            if (n < 1) {
                throw new zzb("minimumSize must be at least 1");
            }
            if (n > n2) {
                throw new zzb("maximumSize must be greater than or equal to minimumSize");
            }
            this.zzajH = n;
            this.zzajI = n2;
            return this;
        }

        public PasswordSpecification zzqZ() {
            if (this.zzajK.isEmpty()) {
                throw new zzb("no allowed characters specified");
            }
            this.zzra();
            this.zzrb();
            return new PasswordSpecification(1, PasswordSpecification.zzb(this.zzajK), this.zzajF, this.zzajG, this.zzajH, this.zzajI);
        }

        private TreeSet<Character> zzw(String string, String string2) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                throw new zzb(String.valueOf(string2).concat(" cannot be null or empty"));
            }
            TreeSet<Character> treeSet = new TreeSet<Character>();
            for (char c : string.toCharArray()) {
                if (PasswordSpecification.zzc(c, 32, 126)) {
                    throw new zzb(String.valueOf(string2).concat(" must only contain ASCII printable characters"));
                }
                treeSet.add(Character.valueOf(c));
            }
            return treeSet;
        }

        private void zzra() {
            int n = 0;
            for (int n2 : this.zzajG) {
                n += n2;
            }
            if (n > this.zzajI) {
                throw new zzb("required character count cannot be greater than the max password size");
            }
        }

        private void zzrb() {
            boolean[] blArray = new boolean[95];
            for (String string : this.zzajF) {
                for (char c : string.toCharArray()) {
                    if (blArray[c - 32]) {
                        throw new zzb(new StringBuilder(58).append("character ").append(c).append(" occurs in more than one required character set").toString());
                    }
                    blArray[c - 32] = true;
                }
            }
        }
    }
}

