/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.credentials.IdToken;
import com.google.android.gms.auth.api.credentials.zza;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Credential
extends com.google.android.gms.common.internal.safeparcel.zza
implements ReflectedParcelable {
    public static final String EXTRA_KEY = "com.google.android.gms.credentials.Credential";
    public static final Parcelable.Creator<Credential> CREATOR = new zza();
    private final String zzbsx;
    @Nullable
    private final String mName;
    @Nullable
    private final Uri zzeab;
    private final List<IdToken> zzeac;
    @Nullable
    private final String zzead;
    @Nullable
    private final String zzdzs;
    @Nullable
    private final String zzeae;
    @Nullable
    private final String zzeaf;
    @Nullable
    private final String zzeag;
    @Nullable
    private final String zzeah;

    /*
     * Unable to fully structure code
     */
    Credential(String var1_1, String var2_2, Uri var3_3, List<IdToken> var4_4, String var5_5, String var6_6, String var7_7, String var8_8, String var9_9, String var10_10) {
        block8: {
            super();
            var11_11 = ((String)zzbp.zzb((Object)var1_1, (Object)"credential identifier cannot be null")).trim();
            zzbp.zzh((String)var11_11, (Object)"credential identifier cannot be empty");
            if (var5_5 != null && TextUtils.isEmpty((CharSequence)var5_5)) {
                throw new IllegalArgumentException("Password must not be empty if set");
            }
            if (var6_6 == null) break block8;
            var12_12 = var6_6;
            if (TextUtils.isEmpty((CharSequence)var12_12)) ** GOTO lbl-1000
            var13_13 = Uri.parse((String)var12_12);
            if (!var13_13.isAbsolute() || !var13_13.isHierarchical() || TextUtils.isEmpty((CharSequence)var13_13.getScheme()) || TextUtils.isEmpty((CharSequence)var13_13.getAuthority())) {
                v0 = false;
            } else if ("http".equalsIgnoreCase(var13_13.getScheme()) || "https".equalsIgnoreCase(var13_13.getScheme())) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            if (!Boolean.valueOf(v0).booleanValue()) {
                throw new IllegalArgumentException("Account type must be a valid Http/Https URI");
            }
        }
        if (!TextUtils.isEmpty((CharSequence)var6_6) && !TextUtils.isEmpty((CharSequence)var5_5)) {
            throw new IllegalArgumentException("Password and AccountType are mutually exclusive");
        }
        if (var2_2 != null && TextUtils.isEmpty((CharSequence)var2_2.trim())) {
            var2_2 = null;
        }
        this.mName = var2_2;
        this.zzeab = var3_3;
        this.zzeac = var4_4 == null ? Collections.emptyList() : Collections.unmodifiableList(var4_4);
        this.zzbsx = var11_11;
        this.zzead = var5_5;
        this.zzdzs = var6_6;
        this.zzeae = var7_7;
        this.zzeaf = var8_8;
        this.zzeag = var9_9;
        this.zzeah = var10_10;
    }

    public String getId() {
        return this.zzbsx;
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    @Nullable
    public Uri getProfilePictureUri() {
        return this.zzeab;
    }

    public List<IdToken> getIdTokens() {
        return this.zzeac;
    }

    @Nullable
    public String getPassword() {
        return this.zzead;
    }

    @Nullable
    public String getGeneratedPassword() {
        return this.zzeae;
    }

    @Nullable
    public String getAccountType() {
        return this.zzdzs;
    }

    @Nullable
    public String getGivenName() {
        return this.zzeag;
    }

    @Nullable
    public String getFamilyName() {
        return this.zzeah;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Credential credential = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (String)credential.getId(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (String)credential.getName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (Parcelable)credential.getProfilePictureUri(), (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)4, credential.getIdTokens(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (String)credential.getPassword(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (String)credential.getAccountType(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)7, (String)credential.getGeneratedPassword(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)8, (String)credential.zzeaf, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)9, (String)credential.getGivenName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)10, (String)credential.getFamilyName(), (boolean)false);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Credential)) {
            return false;
        }
        Credential credential = (Credential)((Object)object);
        return TextUtils.equals((CharSequence)this.zzbsx, (CharSequence)credential.zzbsx) && TextUtils.equals((CharSequence)this.mName, (CharSequence)credential.mName) && zzbf.equal((Object)this.zzeab, (Object)credential.zzeab) && TextUtils.equals((CharSequence)this.zzead, (CharSequence)credential.zzead) && TextUtils.equals((CharSequence)this.zzdzs, (CharSequence)credential.zzdzs) && TextUtils.equals((CharSequence)this.zzeae, (CharSequence)credential.zzeae);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzbsx, this.mName, this.zzeab, this.zzead, this.zzdzs, this.zzeae});
    }

    public static class Builder {
        private final String zzbsx;
        private String mName;
        private Uri zzeab;
        private List<IdToken> zzeac;
        private String zzead;
        private String zzdzs;
        private String zzeae;
        private String zzeaf;
        private String zzeag;
        private String zzeah;

        public Builder(String string) {
            this.zzbsx = string;
        }

        public Builder(Credential credential) {
            this.zzbsx = credential.zzbsx;
            this.mName = credential.mName;
            this.zzeab = credential.zzeab;
            this.zzeac = credential.zzeac;
            this.zzead = credential.zzead;
            this.zzdzs = credential.zzdzs;
            this.zzeae = credential.zzeae;
            this.zzeaf = credential.zzeaf;
            this.zzeag = credential.zzeag;
            this.zzeah = credential.zzeah;
        }

        public Builder setName(String string) {
            this.mName = string;
            return this;
        }

        public Builder setProfilePictureUri(Uri uri) {
            this.zzeab = uri;
            return this;
        }

        public Builder setPassword(String string) {
            this.zzead = string;
            return this;
        }

        public Builder setAccountType(String string) {
            this.zzdzs = string;
            return this;
        }

        public Credential build() {
            return new Credential(this.zzbsx, this.mName, this.zzeab, this.zzeac, this.zzead, this.zzdzs, this.zzeae, this.zzeaf, this.zzeag, this.zzeah);
        }
    }
}

