/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import com.google.android.gms.auth.api.credentials.zzi;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;

public final class PasswordSpecification
extends com.google.android.gms.common.internal.safeparcel.zza
implements ReflectedParcelable {
    public static final Parcelable.Creator<PasswordSpecification> CREATOR = new zzi();
    public static final PasswordSpecification zzeay = new zza().zzi(12, 16).zzel("abcdefghijkmnopqrstxyzABCDEFGHJKLMNPQRSTXY3456789").zze("abcdefghijkmnopqrstxyz", 1).zze("ABCDEFGHJKLMNPQRSTXY", 1).zze("3456789", 1).zzzy();
    private static PasswordSpecification zzeaz = new zza().zzi(12, 16).zzel("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890").zze("abcdefghijklmnopqrstuvwxyz", 1).zze("ABCDEFGHIJKLMNOPQRSTUVWXYZ", 1).zze("1234567890", 1).zzzy();
    @VisibleForTesting
    private String zzeba;
    @VisibleForTesting
    private List<String> zzebb;
    @VisibleForTesting
    private List<Integer> zzebc;
    @VisibleForTesting
    private int zzebd;
    @VisibleForTesting
    private int zzebe;
    private final int[] zzebf;
    private final Random zzbdm;

    PasswordSpecification(String string, List<String> list, List<Integer> list2, int n, int n2) {
        this.zzeba = string;
        this.zzebb = Collections.unmodifiableList(list);
        this.zzebc = Collections.unmodifiableList(list2);
        this.zzebd = n;
        this.zzebe = n2;
        PasswordSpecification passwordSpecification = this;
        int[] nArray = new int[95];
        Arrays.fill(nArray, -1);
        int n3 = 0;
        Iterator<String> iterator = passwordSpecification.zzebb.iterator();
        while (iterator.hasNext()) {
            for (char c : iterator.next().toCharArray()) {
                nArray[c - 32] = n3;
            }
            ++n3;
        }
        this.zzebf = nArray;
        this.zzbdm = new SecureRandom();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PasswordSpecification passwordSpecification = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (String)passwordSpecification.zzeba, (boolean)false);
        zzd.zzb((Parcel)parcel2, (int)2, passwordSpecification.zzebb, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, passwordSpecification.zzebc, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)4, (int)passwordSpecification.zzebd);
        zzd.zzc((Parcel)parcel2, (int)5, (int)passwordSpecification.zzebe);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }

    private static String zzb(Collection<Character> collection) {
        char[] cArray = new char[collection.size()];
        int n = 0;
        for (char c : collection) {
            cArray[n++] = c;
        }
        return new String(cArray);
    }

    private static boolean zzc(int n, int n2, int n3) {
        return n < 32 || n > 126;
    }

    public static final class zzb
    extends Error {
        public zzb(String string) {
            super(string);
        }
    }

    public static final class zza {
        private final TreeSet<Character> zzebg = new TreeSet();
        private final List<String> zzebb = new ArrayList<String>();
        private final List<Integer> zzebc = new ArrayList<Integer>();
        private int zzebd = 12;
        private int zzebe = 16;

        public final zza zzel(@NonNull String string) {
            this.zzebg.addAll(zza.zzq(string, "allowedChars"));
            return this;
        }

        public final zza zze(@NonNull String string, int n) {
            TreeSet<Character> treeSet = zza.zzq(string, "requiredChars");
            this.zzebb.add(PasswordSpecification.zzb(treeSet));
            this.zzebc.add(1);
            return this;
        }

        public final zza zzi(int n, int n2) {
            this.zzebd = 12;
            this.zzebe = 16;
            return this;
        }

        public final PasswordSpecification zzzy() {
            if (this.zzebg.isEmpty()) {
                throw new zzb("no allowed characters specified");
            }
            zza zza2 = this;
            int n = 0;
            Iterator<Object> iterator = zza2.zzebc.iterator();
            while (iterator.hasNext()) {
                int n2 = iterator.next();
                n += n2;
            }
            if (n > zza2.zzebe) {
                throw new zzb("required character count cannot be greater than the max password size");
            }
            zza2 = this;
            boolean[] blArray = new boolean[95];
            iterator = zza2.zzebb.iterator();
            while (iterator.hasNext()) {
                for (char c : ((String)iterator.next()).toCharArray()) {
                    if (blArray[c - 32]) {
                        throw new zzb(new StringBuilder(58).append("character ").append(c).append(" occurs in more than one required character set").toString());
                    }
                    blArray[c - 32] = true;
                }
            }
            return new PasswordSpecification(PasswordSpecification.zzb(this.zzebg), this.zzebb, this.zzebc, this.zzebd, this.zzebe);
        }

        private static TreeSet<Character> zzq(String string, String string2) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                throw new zzb(String.valueOf(string2).concat(" cannot be null or empty"));
            }
            TreeSet<Character> treeSet = new TreeSet<Character>();
            for (char c : string.toCharArray()) {
                if (PasswordSpecification.zzc(c, 32, 126)) {
                    throw new zzb(String.valueOf(string2).concat(" must only contain ASCII printable characters"));
                }
                treeSet.add(Character.valueOf(c));
            }
            return treeSet;
        }
    }
}

