/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInClient;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.auth.api.signin.GoogleSignInOptionsExtension;
import com.google.android.gms.auth.api.signin.GoogleSignInResult;
import com.google.android.gms.auth.api.signin.internal.zze;
import com.google.android.gms.auth.api.signin.internal.zzo;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public final class GoogleSignIn {
    private GoogleSignIn() {
    }

    public static GoogleSignInClient getClient(@NonNull Context context, @NonNull GoogleSignInOptions googleSignInOptions) {
        return new GoogleSignInClient(context, (GoogleSignInOptions)zzbq.checkNotNull((Object)googleSignInOptions));
    }

    public static GoogleSignInClient getClient(@NonNull Activity activity, @NonNull GoogleSignInOptions googleSignInOptions) {
        return new GoogleSignInClient(activity, (GoogleSignInOptions)zzbq.checkNotNull((Object)googleSignInOptions));
    }

    public static Task<GoogleSignInAccount> getSignedInAccountFromIntent(@Nullable Intent intent) {
        GoogleSignInResult googleSignInResult = zze.getSignInResultFromIntent(intent);
        if (googleSignInResult == null) {
            return Tasks.forException((Exception)zzb.zzy((Status)Status.zzfnk));
        }
        if (!googleSignInResult.getStatus().isSuccess() || null == googleSignInResult.getSignInAccount()) {
            return Tasks.forException((Exception)zzb.zzy((Status)googleSignInResult.getStatus()));
        }
        return Tasks.forResult((Object)googleSignInResult.getSignInAccount());
    }

    @Nullable
    public static GoogleSignInAccount getLastSignedInAccount(Context context) {
        return zzo.zzbr(context).zzabl();
    }

    @NonNull
    public static GoogleSignInAccount getAccountForScopes(@NonNull Context context, @NonNull Scope scope, Scope ... scopeArray) {
        zzbq.checkNotNull((Object)context, (Object)"please provide a valid Context object");
        zzbq.checkNotNull((Object)scope, (Object)"please provide at least one valid scope");
        GoogleSignInAccount googleSignInAccount = GoogleSignIn.getLastSignedInAccount(context);
        if (googleSignInAccount == null) {
            googleSignInAccount = GoogleSignInAccount.zzaaz();
        }
        googleSignInAccount.zza(new Scope[]{scope});
        googleSignInAccount.zza(scopeArray);
        return googleSignInAccount;
    }

    @NonNull
    public static GoogleSignInAccount getAccountForExtension(@NonNull Context context, @NonNull GoogleSignInOptionsExtension googleSignInOptionsExtension) {
        zzbq.checkNotNull((Object)context, (Object)"please provide a valid Context object");
        zzbq.checkNotNull((Object)googleSignInOptionsExtension, (Object)"please provide valid GoogleSignInOptionsExtension");
        GoogleSignInAccount googleSignInAccount = GoogleSignIn.getLastSignedInAccount(context);
        if (googleSignInAccount == null) {
            googleSignInAccount = GoogleSignInAccount.zzaaz();
        }
        return googleSignInAccount.zza(GoogleSignIn.zzw(googleSignInOptionsExtension.getImpliedScopes()));
    }

    public static boolean hasPermissions(@Nullable GoogleSignInAccount googleSignInAccount, @NonNull GoogleSignInOptionsExtension googleSignInOptionsExtension) {
        zzbq.checkNotNull((Object)googleSignInOptionsExtension, (Object)"Please provide a non-null GoogleSignInOptionsExtension");
        return GoogleSignIn.hasPermissions(googleSignInAccount, GoogleSignIn.zzw(googleSignInOptionsExtension.getImpliedScopes()));
    }

    public static boolean hasPermissions(@Nullable GoogleSignInAccount googleSignInAccount, Scope ... scopeArray) {
        if (googleSignInAccount == null) {
            return false;
        }
        HashSet hashSet = new HashSet();
        Collections.addAll(hashSet, scopeArray);
        return googleSignInAccount.getGrantedScopes().containsAll(hashSet);
    }

    public static void requestPermissions(@NonNull Activity activity, int n, @Nullable GoogleSignInAccount googleSignInAccount, @NonNull GoogleSignInOptionsExtension googleSignInOptionsExtension) {
        zzbq.checkNotNull((Object)activity, (Object)"Please provide a non-null Activity");
        zzbq.checkNotNull((Object)googleSignInOptionsExtension, (Object)"Please provide a non-null GoogleSignInOptionsExtension");
        GoogleSignIn.requestPermissions(activity, n, googleSignInAccount, GoogleSignIn.zzw(googleSignInOptionsExtension.getImpliedScopes()));
    }

    public static void requestPermissions(@NonNull Fragment fragment, int n, @Nullable GoogleSignInAccount googleSignInAccount, @NonNull GoogleSignInOptionsExtension googleSignInOptionsExtension) {
        zzbq.checkNotNull((Object)fragment, (Object)"Please provide a non-null Fragment");
        zzbq.checkNotNull((Object)googleSignInOptionsExtension, (Object)"Please provide a non-null GoogleSignInOptionsExtension");
        GoogleSignIn.requestPermissions(fragment, n, googleSignInAccount, GoogleSignIn.zzw(googleSignInOptionsExtension.getImpliedScopes()));
    }

    public static void requestPermissions(@NonNull Activity activity, int n, @Nullable GoogleSignInAccount googleSignInAccount, Scope ... scopeArray) {
        zzbq.checkNotNull((Object)activity, (Object)"Please provide a non-null Activity");
        zzbq.checkNotNull((Object)scopeArray, (Object)"Please provide at least one scope");
        Intent intent = GoogleSignIn.zza(activity, googleSignInAccount, scopeArray);
        activity.startActivityForResult(intent, n);
    }

    public static void requestPermissions(@NonNull Fragment fragment, int n, @Nullable GoogleSignInAccount googleSignInAccount, Scope ... scopeArray) {
        zzbq.checkNotNull((Object)fragment, (Object)"Please provide a non-null Fragment");
        zzbq.checkNotNull((Object)scopeArray, (Object)"Please provide at least one scope");
        Intent intent = GoogleSignIn.zza((Activity)fragment.getActivity(), googleSignInAccount, scopeArray);
        fragment.startActivityForResult(intent, n);
    }

    @NonNull
    private static Intent zza(@NonNull Activity activity, @Nullable GoogleSignInAccount googleSignInAccount, Scope ... scopeArray) {
        GoogleSignInOptions.Builder builder = new GoogleSignInOptions.Builder();
        if (scopeArray.length > 0) {
            builder.requestScopes(scopeArray[0], scopeArray);
        }
        if (googleSignInAccount != null && !TextUtils.isEmpty((CharSequence)googleSignInAccount.getEmail())) {
            builder.setAccountName(googleSignInAccount.getEmail());
        }
        return new GoogleSignInClient(activity, builder.build()).getSignInIntent();
    }

    @NonNull
    private static Scope[] zzw(@Nullable List<Scope> list) {
        if (list == null) {
            return new Scope[0];
        }
        return list.toArray(new Scope[list.size()]);
    }
}

