/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin.internal;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.util.Log;
import android.view.accessibility.AccessibilityEvent;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.SignInAccount;
import com.google.android.gms.auth.api.signin.internal.SignInConfiguration;
import com.google.android.gms.auth.api.signin.internal.zzb;
import com.google.android.gms.auth.api.signin.internal.zzo;
import com.google.android.gms.auth.api.signin.internal.zzy;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;

@KeepName
public class SignInHubActivity
extends FragmentActivity {
    private static boolean zzein = false;
    private boolean zzeio = false;
    @VisibleForTesting
    private SignInConfiguration zzeip;
    private boolean zzeiq;
    private int zzeir;
    private Intent zzeis;

    public SignInHubActivity() {
    }

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        Intent intent = this.getIntent();
        String string = intent.getAction();
        if ("com.google.android.gms.auth.NO_IMPL".equals(string)) {
            this.zzba(12500);
            return;
        }
        if (zzein) {
            this.setResult(0);
            this.zzba(12502);
            return;
        }
        zzein = true;
        if (!string.equals("com.google.android.gms.auth.GOOGLE_SIGN_IN") && !string.equals("com.google.android.gms.auth.APPAUTH_SIGN_IN")) {
            String string2 = String.valueOf(intent.getAction());
            Log.e((String)"AuthSignInClient", (String)(string2.length() != 0 ? "Unknown action: ".concat(string2) : new String("Unknown action: ")));
            this.finish();
            return;
        }
        Bundle bundle2 = intent.getBundleExtra("config");
        this.zzeip = (SignInConfiguration)bundle2.getParcelable("config");
        if (this.zzeip == null) {
            Log.e((String)"AuthSignInClient", (String)"Activity started with invalid configuration.");
            this.setResult(0);
            this.finish();
            return;
        }
        if (bundle == null) {
            String string3 = string;
            SignInHubActivity signInHubActivity = this;
            Intent intent2 = new Intent(string3);
            if (string3.equals("com.google.android.gms.auth.GOOGLE_SIGN_IN")) {
                intent2.setPackage("com.google.android.gms");
            } else {
                intent2.setPackage(signInHubActivity.getPackageName());
            }
            intent2.putExtra("config", (Parcelable)signInHubActivity.zzeip);
            try {
                signInHubActivity.startActivityForResult(intent2, 40962);
                return;
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                signInHubActivity.zzeio = true;
                Log.w((String)"AuthSignInClient", (String)"Could not launch sign in Intent. Google Play Service is probably being updated...");
                signInHubActivity.zzba(17);
                return;
            }
        }
        this.zzeiq = bundle.getBoolean("signingInGoogleApiClients");
        if (this.zzeiq) {
            this.zzeir = bundle.getInt("signInResultCode");
            this.zzeis = (Intent)bundle.getParcelable("signInResultData");
            this.zzabs();
        }
    }

    protected void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean("signingInGoogleApiClients", this.zzeiq);
        if (this.zzeiq) {
            bundle.putInt("signInResultCode", this.zzeir);
            bundle.putParcelable("signInResultData", (Parcelable)this.zzeis);
        }
    }

    protected void onActivityResult(int n, int n2, Intent intent) {
        if (this.zzeio) {
            return;
        }
        this.setResult(0);
        switch (n) {
            case 40962: {
                Intent intent2 = intent;
                SignInHubActivity signInHubActivity = this;
                if (intent2 != null) {
                    SignInAccount signInAccount = (SignInAccount)intent2.getParcelableExtra("signInAccount");
                    if (signInAccount != null && signInAccount.getGoogleSignInAccount() != null) {
                        GoogleSignInAccount googleSignInAccount = signInAccount.getGoogleSignInAccount();
                        zzo.zzbr((Context)signInHubActivity).zza(signInHubActivity.zzeip.zzabr(), googleSignInAccount);
                        intent2.removeExtra("signInAccount");
                        intent2.putExtra("googleSignInAccount", (Parcelable)googleSignInAccount);
                        signInHubActivity.zzeiq = true;
                        signInHubActivity.zzeir = n2;
                        signInHubActivity.zzeis = intent2;
                        signInHubActivity.zzabs();
                        return;
                    }
                    if (intent2.hasExtra("errorCode")) {
                        int n3 = intent2.getIntExtra("errorCode", 8);
                        signInHubActivity.zzba(n3);
                        return;
                    }
                }
                signInHubActivity.zzba(8);
            }
        }
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        return true;
    }

    private final void zzabs() {
        this.getSupportLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)new zza(this, null));
        zzein = false;
    }

    private final void zzba(int n) {
        Status status = new Status(n);
        Intent intent = new Intent();
        intent.putExtra("googleSignInStatus", (Parcelable)status);
        this.setResult(0, intent);
        this.finish();
        zzein = false;
    }

    final class zza
    implements LoaderManager.LoaderCallbacks<Void> {
        private /* synthetic */ SignInHubActivity zzeit;

        private zza(SignInHubActivity signInHubActivity) {
            this.zzeit = signInHubActivity;
        }

        public final Loader<Void> onCreateLoader(int n, Bundle bundle) {
            return new zzb((Context)this.zzeit, GoogleApiClient.zzagr());
        }

        public final void onLoaderReset(Loader<Void> loader) {
        }

        public final /* synthetic */ void onLoadFinished(Loader loader, Object object) {
            zza zza2 = this;
            zza2.zzeit.setResult(zza2.zzeit.zzeir, zza2.zzeit.zzeis);
            zza2.zzeit.finish();
        }

        /* synthetic */ zza(SignInHubActivity signInHubActivity, zzy zzy2) {
            this(signInHubActivity);
        }
    }
}

