/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.credentials.IdToken;
import com.google.android.gms.auth.api.credentials.zza;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Credential
extends zzbgl
implements ReflectedParcelable {
    public static final String EXTRA_KEY = "com.google.android.gms.credentials.Credential";
    public static final Parcelable.Creator<Credential> CREATOR = new zza();
    private final String zza;
    @Nullable
    private final String zzb;
    @Nullable
    private final Uri zzc;
    private final List<IdToken> zzd;
    @Nullable
    private final String zze;
    @Nullable
    private final String zzf;
    @Nullable
    private final String zzg;
    @Nullable
    private final String zzh;
    @Nullable
    private final String zzi;
    @Nullable
    private final String zzj;

    /*
     * Unable to fully structure code
     */
    @Hide
    Credential(String var1_1, String var2_2, Uri var3_3, List<IdToken> var4_4, String var5_5, String var6_6, String var7_7, String var8_8, String var9_9, String var10_10) {
        block8: {
            super();
            var11_11 = ((String)zzbq.zza((Object)var1_1, (Object)"credential identifier cannot be null")).trim();
            zzbq.zza((String)var11_11, (Object)"credential identifier cannot be empty");
            if (var5_5 != null && TextUtils.isEmpty((CharSequence)var5_5)) {
                throw new IllegalArgumentException("Password must not be empty if set");
            }
            if (var6_6 == null) break block8;
            var12_12 = var6_6;
            if (TextUtils.isEmpty((CharSequence)var12_12)) ** GOTO lbl-1000
            var13_13 = Uri.parse((String)var12_12);
            if (!var13_13.isAbsolute() || !var13_13.isHierarchical() || TextUtils.isEmpty((CharSequence)var13_13.getScheme()) || TextUtils.isEmpty((CharSequence)var13_13.getAuthority())) {
                v0 = false;
            } else if ("http".equalsIgnoreCase(var13_13.getScheme()) || "https".equalsIgnoreCase(var13_13.getScheme())) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            if (!Boolean.valueOf(v0).booleanValue()) {
                throw new IllegalArgumentException("Account type must be a valid Http/Https URI");
            }
        }
        if (!TextUtils.isEmpty((CharSequence)var6_6) && !TextUtils.isEmpty((CharSequence)var5_5)) {
            throw new IllegalArgumentException("Password and AccountType are mutually exclusive");
        }
        if (var2_2 != null && TextUtils.isEmpty((CharSequence)var2_2.trim())) {
            var2_2 = null;
        }
        this.zzb = var2_2;
        this.zzc = var3_3;
        this.zzd = var4_4 == null ? Collections.emptyList() : Collections.unmodifiableList(var4_4);
        this.zza = var11_11;
        this.zze = var5_5;
        this.zzf = var6_6;
        this.zzg = var7_7;
        this.zzh = var8_8;
        this.zzi = var9_9;
        this.zzj = var10_10;
    }

    public String getId() {
        return this.zza;
    }

    @Nullable
    public String getName() {
        return this.zzb;
    }

    @Nullable
    public Uri getProfilePictureUri() {
        return this.zzc;
    }

    public List<IdToken> getIdTokens() {
        return this.zzd;
    }

    @Nullable
    public String getPassword() {
        return this.zze;
    }

    @Nullable
    public String getGeneratedPassword() {
        return this.zzg;
    }

    @Nullable
    public String getAccountType() {
        return this.zzf;
    }

    @Nullable
    public String getGivenName() {
        return this.zzi;
    }

    @Nullable
    public String getFamilyName() {
        return this.zzj;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Credential credential = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (String)credential.getId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)credential.getName(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (Parcelable)credential.getProfilePictureUri(), (int)n, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)4, credential.getIdTokens(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (String)credential.getPassword(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (String)credential.getAccountType(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (String)credential.getGeneratedPassword(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)8, (String)credential.zzh, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)9, (String)credential.getGivenName(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)10, (String)credential.getFamilyName(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Credential)) {
            return false;
        }
        Credential credential = (Credential)((Object)object);
        return TextUtils.equals((CharSequence)this.zza, (CharSequence)credential.zza) && TextUtils.equals((CharSequence)this.zzb, (CharSequence)credential.zzb) && zzbg.zza((Object)this.zzc, (Object)credential.zzc) && TextUtils.equals((CharSequence)this.zze, (CharSequence)credential.zze) && TextUtils.equals((CharSequence)this.zzf, (CharSequence)credential.zzf) && TextUtils.equals((CharSequence)this.zzg, (CharSequence)credential.zzg);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zza, this.zzb, this.zzc, this.zze, this.zzf, this.zzg});
    }

    public static class Builder {
        private final String zza;
        private String zzb;
        private Uri zzc;
        private List<IdToken> zzd;
        private String zze;
        private String zzf;
        private String zzg;
        private String zzh;
        private String zzi;
        private String zzj;

        public Builder(String string) {
            this.zza = string;
        }

        public Builder(Credential credential) {
            this.zza = credential.zza;
            this.zzb = credential.zzb;
            this.zzc = credential.zzc;
            this.zzd = credential.zzd;
            this.zze = credential.zze;
            this.zzf = credential.zzf;
            this.zzg = credential.zzg;
            this.zzh = credential.zzh;
            this.zzi = credential.zzi;
            this.zzj = credential.zzj;
        }

        public Builder setName(String string) {
            this.zzb = string;
            return this;
        }

        public Builder setProfilePictureUri(Uri uri) {
            this.zzc = uri;
            return this;
        }

        public Builder setPassword(String string) {
            this.zze = string;
            return this;
        }

        public Builder setAccountType(String string) {
            this.zzf = string;
            return this;
        }

        public Credential build() {
            return new Credential(this.zza, this.zzb, this.zzc, this.zzd, this.zze, this.zzf, this.zzg, this.zzh, this.zzi, this.zzj);
        }
    }
}

