/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.credentials.IdToken;
import com.google.android.gms.auth.api.credentials.zzd;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="CredentialCreator")
public class Credential
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final String EXTRA_KEY = "com.google.android.gms.credentials.Credential";
    public static final Parcelable.Creator<Credential> CREATOR = new zzd();
    @Nonnull
    @SafeParcelable.Field(id=1, getter="getId")
    private final String zzci;
    @SafeParcelable.Field(id=2, getter="getName")
    @Nullable
    private final String mName;
    @SafeParcelable.Field(id=3, getter="getProfilePictureUri")
    @Nullable
    private final Uri zzcj;
    @Nonnull
    @SafeParcelable.Field(id=4, getter="getIdTokens")
    private final List<IdToken> zzck;
    @SafeParcelable.Field(id=5, getter="getPassword")
    @Nullable
    private final String zzcl;
    @SafeParcelable.Field(id=6, getter="getAccountType")
    @Nullable
    private final String zzbx;
    @SafeParcelable.Field(id=7, getter="getGeneratedPassword")
    @Nullable
    private final String zzcm;
    @SafeParcelable.Field(id=8, getter="getGeneratedHintId")
    @Nullable
    private final String zzcn;
    @SafeParcelable.Field(id=9, getter="getGivenName")
    @Nullable
    private final String zzco;
    @SafeParcelable.Field(id=10, getter="getFamilyName")
    @Nullable
    private final String zzcp;

    /*
     * Unable to fully structure code
     */
    @SafeParcelable.Constructor
    Credential(@SafeParcelable.Param(id=1) String var1_1, @SafeParcelable.Param(id=2) String var2_2, @SafeParcelable.Param(id=3) Uri var3_3, @SafeParcelable.Param(id=4) List<IdToken> var4_4, @SafeParcelable.Param(id=5) String var5_5, @SafeParcelable.Param(id=6) String var6_6, @SafeParcelable.Param(id=7) String var7_7, @SafeParcelable.Param(id=8) String var8_8, @SafeParcelable.Param(id=9) String var9_9, @SafeParcelable.Param(id=10) String var10_10) {
        block8: {
            super();
            var11_11 = ((String)Preconditions.checkNotNull((Object)var1_1, (Object)"credential identifier cannot be null")).trim();
            Preconditions.checkNotEmpty((String)var11_11, (Object)"credential identifier cannot be empty");
            if (var5_5 != null && TextUtils.isEmpty((CharSequence)var5_5)) {
                throw new IllegalArgumentException("Password must not be empty if set");
            }
            if (var6_6 == null) break block8;
            var12_12 = var6_6;
            if (TextUtils.isEmpty((CharSequence)var12_12)) ** GOTO lbl-1000
            var13_13 = Uri.parse((String)var12_12);
            if (!var13_13.isAbsolute() || !var13_13.isHierarchical() || TextUtils.isEmpty((CharSequence)var13_13.getScheme()) || TextUtils.isEmpty((CharSequence)var13_13.getAuthority())) {
                v0 = false;
            } else if ("http".equalsIgnoreCase(var13_13.getScheme()) || "https".equalsIgnoreCase(var13_13.getScheme())) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            if (!Boolean.valueOf(v0).booleanValue()) {
                throw new IllegalArgumentException("Account type must be a valid Http/Https URI");
            }
        }
        if (!TextUtils.isEmpty((CharSequence)var6_6) && !TextUtils.isEmpty((CharSequence)var5_5)) {
            throw new IllegalArgumentException("Password and AccountType are mutually exclusive");
        }
        if (var2_2 != null && TextUtils.isEmpty((CharSequence)var2_2.trim())) {
            var2_2 = null;
        }
        this.mName = var2_2;
        this.zzcj = var3_3;
        this.zzck = var4_4 == null ? Collections.emptyList() : Collections.unmodifiableList(var4_4);
        this.zzci = var11_11;
        this.zzcl = var5_5;
        this.zzbx = var6_6;
        this.zzcm = var7_7;
        this.zzcn = var8_8;
        this.zzco = var9_9;
        this.zzcp = var10_10;
    }

    @Nonnull
    public String getId() {
        return this.zzci;
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    @Nullable
    public Uri getProfilePictureUri() {
        return this.zzcj;
    }

    @Nonnull
    public List<IdToken> getIdTokens() {
        return this.zzck;
    }

    @Nullable
    public String getPassword() {
        return this.zzcl;
    }

    @Nullable
    public String getGeneratedPassword() {
        return this.zzcm;
    }

    @Nullable
    public String getAccountType() {
        return this.zzbx;
    }

    @Nullable
    public String getGivenName() {
        return this.zzco;
    }

    @Nullable
    public String getFamilyName() {
        return this.zzcp;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Credential credential = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)1, (String)credential.getId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)credential.getName(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)3, (Parcelable)credential.getProfilePictureUri(), (int)n, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)4, credential.getIdTokens(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)credential.getPassword(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)6, (String)credential.getAccountType(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)credential.getGeneratedPassword(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)8, (String)credential.zzcn, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)9, (String)credential.getGivenName(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)10, (String)credential.getFamilyName(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Credential)) {
            return false;
        }
        Credential credential = (Credential)((Object)object);
        return TextUtils.equals((CharSequence)this.zzci, (CharSequence)credential.zzci) && TextUtils.equals((CharSequence)this.mName, (CharSequence)credential.mName) && Objects.equal((Object)this.zzcj, (Object)credential.zzcj) && TextUtils.equals((CharSequence)this.zzcl, (CharSequence)credential.zzcl) && TextUtils.equals((CharSequence)this.zzbx, (CharSequence)credential.zzbx) && TextUtils.equals((CharSequence)this.zzcm, (CharSequence)credential.zzcm);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zzci, this.mName, this.zzcj, this.zzcl, this.zzbx, this.zzcm});
    }

    public static class Builder {
        private final String zzci;
        private String mName;
        private Uri zzcj;
        private List<IdToken> zzck;
        private String zzcl;
        private String zzbx;
        private String zzcm;
        private String zzcn;
        private String zzco;
        private String zzcp;

        public Builder(String string) {
            this.zzci = string;
        }

        public Builder(Credential credential) {
            this.zzci = credential.zzci;
            this.mName = credential.mName;
            this.zzcj = credential.zzcj;
            this.zzck = credential.zzck;
            this.zzcl = credential.zzcl;
            this.zzbx = credential.zzbx;
            this.zzcm = credential.zzcm;
            this.zzcn = credential.zzcn;
            this.zzco = credential.zzco;
            this.zzcp = credential.zzcp;
        }

        public Builder setName(String string) {
            this.mName = string;
            return this;
        }

        public Builder setProfilePictureUri(Uri uri) {
            this.zzcj = uri;
            return this;
        }

        public Builder setPassword(String string) {
            this.zzcl = string;
            return this;
        }

        public Builder setAccountType(String string) {
            this.zzbx = string;
            return this;
        }

        public Credential build() {
            return new Credential(this.zzci, this.mName, this.zzcj, this.zzck, this.zzcl, this.zzbx, this.zzcm, this.zzcn, this.zzco, this.zzcp);
        }
    }
}

