/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import com.google.android.gms.auth.api.Auth;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.auth.api.signin.GoogleSignInResult;
import com.google.android.gms.auth.api.signin.internal.zzi;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.ApiExceptionMapper;
import com.google.android.gms.common.api.internal.StatusExceptionMapper;
import com.google.android.gms.common.internal.PendingResultUtil;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.tasks.Task;

public class GoogleSignInClient
extends GoogleApi<GoogleSignInOptions> {
    private static final zzd zzef = new zzd(null);
    @VisibleForTesting
    private static int zzeg = zze.zzei;

    GoogleSignInClient(@NonNull Context context, GoogleSignInOptions googleSignInOptions) {
        super(context, Auth.GOOGLE_SIGN_IN_API, (Api.ApiOptions)googleSignInOptions, (StatusExceptionMapper)new ApiExceptionMapper());
    }

    GoogleSignInClient(@NonNull Activity activity, GoogleSignInOptions googleSignInOptions) {
        super(activity, Auth.GOOGLE_SIGN_IN_API, (Api.ApiOptions)googleSignInOptions, (StatusExceptionMapper)new ApiExceptionMapper());
    }

    private final synchronized int zzl() {
        if (zzeg == zze.zzei) {
            Context context = this.getApplicationContext();
            GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
            int n = googleApiAvailability.isGooglePlayServicesAvailable(context, 12451000);
            zzeg = n == 0 ? zze.zzel : (googleApiAvailability.getErrorResolutionIntent(context, n, null) == null && DynamiteModule.getLocalVersion((Context)context, (String)"com.google.android.gms.auth.api.fallback") != 0 ? zze.zzek : zze.zzej);
        }
        return zzeg;
    }

    @NonNull
    public Intent getSignInIntent() {
        Context context = this.getApplicationContext();
        switch (com.google.android.gms.auth.api.signin.zzd.zzeh[this.zzl() - 1]) {
            case 1: {
                return zzi.zze(context, (GoogleSignInOptions)this.getApiOptions());
            }
            case 2: {
                return zzi.zzd(context, (GoogleSignInOptions)this.getApiOptions());
            }
        }
        return zzi.zzf(context, (GoogleSignInOptions)this.getApiOptions());
    }

    public Task<GoogleSignInAccount> silentSignIn() {
        return PendingResultUtil.toTask(zzi.zzd(this.asGoogleApiClient(), this.getApplicationContext(), (GoogleSignInOptions)this.getApiOptions(), this.zzl() == zze.zzek), (PendingResultUtil.ResultConverter)zzef);
    }

    public Task<Void> signOut() {
        return PendingResultUtil.toVoidTask(zzi.zzd(this.asGoogleApiClient(), this.getApplicationContext(), this.zzl() == zze.zzek));
    }

    public Task<Void> revokeAccess() {
        return PendingResultUtil.toVoidTask(zzi.zze(this.asGoogleApiClient(), this.getApplicationContext(), this.zzl() == zze.zzek));
    }

    private static final class zzd
    implements PendingResultUtil.ResultConverter<GoogleSignInResult, GoogleSignInAccount> {
        private zzd() {
        }

        public final /* synthetic */ Object convert(Result result) {
            return ((GoogleSignInResult)result).getSignInAccount();
        }

        /* synthetic */ zzd(com.google.android.gms.auth.api.signin.zzd zzd2) {
            this();
        }
    }

    @VisibleForTesting
    static final class zze {
        public static final /* enum */ int zzei = 1;
        public static final /* enum */ int zzej = 2;
        public static final /* enum */ int zzek = 3;
        public static final /* enum */ int zzel = 4;
        private static final /* synthetic */ int[] zzem;

        public static int[] values$50KLMJ33DTMIUPRFDTJMOP9FC5N68SJFD5I2UPRDECNM2TBKD0NM2S395TPMIPRED5N2UHRFDTJMOPAJD5JMSIBE8DM6IPBEEGI4IRBGDHIMQPBEEHGN8QBFDOTG____0() {
            return (int[])zzem.clone();
        }

        static {
            zzem = new int[]{zzei, zzej, zzek, zzel};
        }
    }
}

