/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin.internal;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.util.Log;
import android.view.accessibility.AccessibilityEvent;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.SignInAccount;
import com.google.android.gms.auth.api.signin.internal.SignInConfiguration;
import com.google.android.gms.auth.api.signin.internal.zzf;
import com.google.android.gms.auth.api.signin.internal.zzq;
import com.google.android.gms.auth.api.signin.internal.zzz;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;

@KeepName
public class SignInHubActivity
extends FragmentActivity {
    private static boolean zzfg = false;
    private boolean zzfh = false;
    private SignInConfiguration zzfi;
    private boolean zzfj;
    private int zzfk;
    private Intent zzfl;

    public SignInHubActivity() {
    }

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        Intent intent = this.getIntent();
        String string = intent.getAction();
        if ("com.google.android.gms.auth.NO_IMPL".equals(string)) {
            this.zzd(12500);
            return;
        }
        if (!string.equals("com.google.android.gms.auth.GOOGLE_SIGN_IN") && !string.equals("com.google.android.gms.auth.APPAUTH_SIGN_IN")) {
            String string2 = String.valueOf(intent.getAction());
            Log.e((String)"AuthSignInClient", (String)(string2.length() != 0 ? "Unknown action: ".concat(string2) : new String("Unknown action: ")));
            this.finish();
            return;
        }
        Bundle bundle2 = intent.getBundleExtra("config");
        this.zzfi = (SignInConfiguration)bundle2.getParcelable("config");
        if (this.zzfi == null) {
            Log.e((String)"AuthSignInClient", (String)"Activity started with invalid configuration.");
            this.setResult(0);
            this.finish();
            return;
        }
        if (bundle == null) {
            if (zzfg) {
                this.setResult(0);
                this.zzd(12502);
                return;
            }
            zzfg = true;
            String string3 = string;
            SignInHubActivity signInHubActivity = this;
            Intent intent2 = new Intent(string3);
            if (string3.equals("com.google.android.gms.auth.GOOGLE_SIGN_IN")) {
                intent2.setPackage("com.google.android.gms");
            } else {
                intent2.setPackage(signInHubActivity.getPackageName());
            }
            intent2.putExtra("config", (Parcelable)signInHubActivity.zzfi);
            try {
                signInHubActivity.startActivityForResult(intent2, 40962);
                return;
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                signInHubActivity.zzfh = true;
                Log.w((String)"AuthSignInClient", (String)"Could not launch sign in Intent. Google Play Service is probably being updated...");
                signInHubActivity.zzd(17);
                return;
            }
        }
        this.zzfj = bundle.getBoolean("signingInGoogleApiClients");
        if (this.zzfj) {
            this.zzfk = bundle.getInt("signInResultCode");
            this.zzfl = (Intent)bundle.getParcelable("signInResultData");
            this.zzu();
        }
    }

    protected void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean("signingInGoogleApiClients", this.zzfj);
        if (this.zzfj) {
            bundle.putInt("signInResultCode", this.zzfk);
            bundle.putParcelable("signInResultData", (Parcelable)this.zzfl);
        }
    }

    protected void onActivityResult(int n, int n2, Intent intent) {
        if (this.zzfh) {
            return;
        }
        this.setResult(0);
        switch (n) {
            case 40962: {
                Intent intent2 = intent;
                SignInHubActivity signInHubActivity = this;
                if (intent2 != null) {
                    SignInAccount signInAccount = (SignInAccount)intent2.getParcelableExtra("signInAccount");
                    if (signInAccount != null && signInAccount.getGoogleSignInAccount() != null) {
                        GoogleSignInAccount googleSignInAccount = signInAccount.getGoogleSignInAccount();
                        zzq.zze((Context)signInHubActivity).zzd(signInHubActivity.zzfi.zzt(), googleSignInAccount);
                        intent2.removeExtra("signInAccount");
                        intent2.putExtra("googleSignInAccount", (Parcelable)googleSignInAccount);
                        signInHubActivity.zzfj = true;
                        signInHubActivity.zzfk = n2;
                        signInHubActivity.zzfl = intent2;
                        signInHubActivity.zzu();
                        return;
                    }
                    if (intent2.hasExtra("errorCode")) {
                        int n3 = intent2.getIntExtra("errorCode", 8);
                        signInHubActivity.zzd(n3);
                        return;
                    }
                }
                signInHubActivity.zzd(8);
            }
        }
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        return true;
    }

    private final void zzu() {
        this.getSupportLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)new zzd(null));
        zzfg = false;
    }

    private final void zzd(int n) {
        Status status = new Status(n);
        Intent intent = new Intent();
        intent.putExtra("googleSignInStatus", (Parcelable)status);
        this.setResult(0, intent);
        this.finish();
        zzfg = false;
    }

    private final class zzd
    implements LoaderManager.LoaderCallbacks<Void> {
        private zzd() {
        }

        public final Loader<Void> onCreateLoader(int n, Bundle bundle) {
            return new zzf((Context)SignInHubActivity.this, GoogleApiClient.getAllClients());
        }

        public final void onLoaderReset(Loader<Void> loader) {
        }

        public final /* synthetic */ void onLoadFinished(Loader loader, Object object) {
            zzd zzd2 = this;
            zzd2.SignInHubActivity.this.setResult(zzd2.SignInHubActivity.this.zzfk, zzd2.SignInHubActivity.this.zzfl);
            zzd2.SignInHubActivity.this.finish();
        }

        /* synthetic */ zzd(zzz zzz2) {
            this();
        }
    }
}

