/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.api.credentials.CredentialPickerConfig;
import com.google.android.gms.auth.api.credentials.zzf;
import com.google.android.gms.auth.api.credentials.zzg;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

@SafeParcelable.Class(creator="CredentialRequestCreator")
public final class CredentialRequest
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<CredentialRequest> CREATOR = new zzg();
    @SafeParcelable.Field(id=1000)
    private final int zzu;
    @SafeParcelable.Field(id=1, getter="isPasswordLoginSupported")
    private final boolean zzz;
    @SafeParcelable.Field(id=2, getter="getAccountTypes")
    private final String[] zzaa;
    @SafeParcelable.Field(id=3, getter="getCredentialPickerConfig")
    private final CredentialPickerConfig zzab;
    @SafeParcelable.Field(id=4, getter="getCredentialHintPickerConfig")
    private final CredentialPickerConfig zzac;
    @SafeParcelable.Field(id=5, getter="isIdTokenRequested")
    private final boolean zzad;
    @SafeParcelable.Field(id=6, getter="getServerClientId")
    private final String zzae;
    @SafeParcelable.Field(id=7, getter="getIdTokenNonce")
    private final String zzaf;
    @SafeParcelable.Field(id=8, getter="getRequireUserMediation")
    private final boolean zzag;

    @SafeParcelable.Constructor
    CredentialRequest(@SafeParcelable.Param(id=1000) int n, @SafeParcelable.Param(id=1) boolean bl, @SafeParcelable.Param(id=2) String[] stringArray, @SafeParcelable.Param(id=3) CredentialPickerConfig credentialPickerConfig, @SafeParcelable.Param(id=4) CredentialPickerConfig credentialPickerConfig2, @SafeParcelable.Param(id=5) boolean bl2, @SafeParcelable.Param(id=6) String string, @SafeParcelable.Param(id=7) String string2, @SafeParcelable.Param(id=8) boolean bl3) {
        this.zzu = n;
        this.zzz = bl;
        this.zzaa = (String[])Preconditions.checkNotNull((Object)stringArray);
        this.zzab = credentialPickerConfig == null ? new CredentialPickerConfig.Builder().build() : credentialPickerConfig;
        CredentialPickerConfig credentialPickerConfig3 = this.zzac = credentialPickerConfig2 == null ? new CredentialPickerConfig.Builder().build() : credentialPickerConfig2;
        if (n < 3) {
            this.zzad = true;
            this.zzae = null;
            this.zzaf = null;
        } else {
            this.zzad = bl2;
            this.zzae = string;
            this.zzaf = string2;
        }
        this.zzag = bl3;
    }

    private CredentialRequest(Builder builder) {
        this(4, builder.zzz, builder.zzaa, builder.zzab, builder.zzac, builder.zzad, builder.zzae, builder.zzaf, false);
    }

    @Deprecated
    public final boolean getSupportsPasswordLogin() {
        return this.isPasswordLoginSupported();
    }

    public final boolean isPasswordLoginSupported() {
        return this.zzz;
    }

    @NonNull
    public final String[] getAccountTypes() {
        return this.zzaa;
    }

    @NonNull
    public final Set<String> getAccountTypesSet() {
        return new HashSet<String>(Arrays.asList(this.zzaa));
    }

    @NonNull
    public final CredentialPickerConfig getCredentialPickerConfig() {
        return this.zzab;
    }

    @NonNull
    public final CredentialPickerConfig getCredentialHintPickerConfig() {
        return this.zzac;
    }

    public final boolean isIdTokenRequested() {
        return this.zzad;
    }

    @Nullable
    public final String getServerClientId() {
        return this.zzae;
    }

    @Nullable
    public final String getIdTokenNonce() {
        return this.zzaf;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CredentialRequest credentialRequest = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)1, (boolean)credentialRequest.isPasswordLoginSupported());
        SafeParcelWriter.writeStringArray((Parcel)parcel2, (int)2, (String[])credentialRequest.getAccountTypes(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)3, (Parcelable)credentialRequest.getCredentialPickerConfig(), (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)4, (Parcelable)credentialRequest.getCredentialHintPickerConfig(), (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)5, (boolean)credentialRequest.isIdTokenRequested());
        SafeParcelWriter.writeString((Parcel)parcel2, (int)6, (String)credentialRequest.getServerClientId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)credentialRequest.getIdTokenNonce(), (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1000, (int)credentialRequest.zzu);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)8, (boolean)credentialRequest.zzag);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ CredentialRequest(Builder builder, zzf zzf2) {
        this(builder);
    }

    public static final class Builder {
        private boolean zzz;
        private String[] zzaa;
        private CredentialPickerConfig zzab;
        private CredentialPickerConfig zzac;
        private boolean zzad = false;
        private boolean zzag = false;
        @Nullable
        private String zzae = null;
        @Nullable
        private String zzaf;

        @Deprecated
        public final Builder setSupportsPasswordLogin(boolean bl) {
            return this.setPasswordLoginSupported(bl);
        }

        public final Builder setPasswordLoginSupported(boolean bl) {
            this.zzz = bl;
            return this;
        }

        public final Builder setAccountTypes(String ... stringArray) {
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            this.zzaa = stringArray;
            return this;
        }

        public final Builder setCredentialPickerConfig(CredentialPickerConfig credentialPickerConfig) {
            this.zzab = credentialPickerConfig;
            return this;
        }

        public final Builder setCredentialHintPickerConfig(CredentialPickerConfig credentialPickerConfig) {
            this.zzac = credentialPickerConfig;
            return this;
        }

        public final Builder setIdTokenRequested(boolean bl) {
            this.zzad = bl;
            return this;
        }

        public final Builder setServerClientId(@Nullable String string) {
            this.zzae = string;
            return this;
        }

        public final Builder setIdTokenNonce(@Nullable String string) {
            this.zzaf = string;
            return this;
        }

        public final CredentialRequest build() {
            if (this.zzaa == null) {
                this.zzaa = new String[0];
            }
            if (!this.zzz && this.zzaa.length == 0) {
                throw new IllegalStateException("At least one authentication method must be specified");
            }
            return new CredentialRequest(this, null);
        }
    }
}

