/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.auth-api;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.api.identity.BeginSignInRequest;
import com.google.android.gms.auth.api.identity.BeginSignInResult;
import com.google.android.gms.auth.api.identity.SignInClient;
import com.google.android.gms.auth.api.identity.SignInCredential;
import com.google.android.gms.auth.api.identity.SignInOptions;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.RemoteCall;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.internal.auth-api.zzae;
import com.google.android.gms.internal.auth-api.zzag;
import com.google.android.gms.internal.auth-api.zzah;
import com.google.android.gms.internal.auth-api.zzak;
import com.google.android.gms.internal.auth-api.zzal;
import com.google.android.gms.internal.auth-api.zzam;
import com.google.android.gms.tasks.Task;
import java.util.Iterator;

public final class zzaf
extends GoogleApi<SignInOptions>
implements SignInClient {
    private static final Api.ClientKey<zzak> CLIENT_KEY = new Api.ClientKey();
    private static final Api.AbstractClientBuilder<zzak, SignInOptions> zzbm = new zzag();
    private static final Api<SignInOptions> API = new Api("Auth.Api.Identity.SignIn.API", zzbm, CLIENT_KEY);

    public zzaf(@NonNull Context context, @NonNull SignInOptions signInOptions) {
        super(context, API, (Api.ApiOptions)SignInOptions.Builder.zzc(signInOptions).zze(zzal.zzs()).build(), GoogleApi.Settings.DEFAULT_SETTINGS);
    }

    public zzaf(@NonNull Activity activity, @NonNull SignInOptions signInOptions) {
        super(activity, API, (Api.ApiOptions)SignInOptions.Builder.zzc(signInOptions).zze(zzal.zzs()).build(), GoogleApi.Settings.DEFAULT_SETTINGS);
    }

    @Override
    public final Task<BeginSignInResult> beginSignIn(@NonNull BeginSignInRequest beginSignInRequest) {
        BeginSignInRequest beginSignInRequest2 = BeginSignInRequest.zzc(beginSignInRequest).zzd(((SignInOptions)this.getApiOptions()).zzg()).build();
        return this.doRead(TaskApiCall.builder().setFeatures(new Feature[]{zzam.zzcz}).run((RemoteCall)new zzae(this, beginSignInRequest2)).setAutoResolveMissingFeatures(false).build());
    }

    @Override
    public final Task<Void> signOut() {
        this.getApplicationContext().getSharedPreferences("com.google.android.gms.signin", 0).edit().clear().apply();
        Iterator iterator = GoogleApiClient.getAllClients().iterator();
        while (iterator.hasNext()) {
            ((GoogleApiClient)iterator.next()).maybeSignOut();
        }
        GoogleApiManager.reportSignOut();
        return this.doRead(TaskApiCall.builder().setFeatures(new Feature[]{zzam.zzda}).run((RemoteCall)new zzah(this)).setAutoResolveMissingFeatures(false).build());
    }

    @Override
    public final SignInCredential getSignInCredentialFromIntent(@Nullable Intent intent) throws ApiException {
        if (intent == null) {
            throw new ApiException(Status.RESULT_INTERNAL_ERROR);
        }
        Status status = (Status)SafeParcelableSerializer.deserializeFromIntentExtra((Intent)intent, (String)"status", (Parcelable.Creator)Status.CREATOR);
        if (status == null) {
            throw new ApiException(Status.RESULT_CANCELED);
        }
        if (!status.isSuccess()) {
            throw new ApiException(status);
        }
        SignInCredential signInCredential = (SignInCredential)SafeParcelableSerializer.deserializeFromIntentExtra((Intent)intent, (String)"sign_in_credential", SignInCredential.CREATOR);
        if (signInCredential == null) {
            throw new ApiException(Status.RESULT_INTERNAL_ERROR);
        }
        return signInCredential;
    }
}

