/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.auth.api.credentials.CredentialPickerConfig;
import com.google.android.gms.auth.api.credentials.zbe;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;

@SafeParcelable.Class(creator="HintRequestCreator")
public final class HintRequest
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @RecentlyNonNull
    public static final Parcelable.Creator<HintRequest> CREATOR;
    @SafeParcelable.Field(id=1000)
    final int zba;
    @SafeParcelable.Field(id=1, getter="getHintPickerConfig")
    private final CredentialPickerConfig zbb;
    @SafeParcelable.Field(id=2, getter="isEmailAddressIdentifierSupported")
    private final boolean zbc;
    @SafeParcelable.Field(id=3, getter="isPhoneNumberIdentifierSupported")
    private final boolean zbd;
    @SafeParcelable.Field(id=4, getter="getAccountTypes")
    private final String[] zbe;
    @SafeParcelable.Field(id=5, getter="isIdTokenRequested")
    private final boolean zbf;
    @SafeParcelable.Field(id=6, getter="getServerClientId")
    @Nullable
    private final String zbg;
    @SafeParcelable.Field(id=7, getter="getIdTokenNonce")
    @Nullable
    private final String zbh;

    @NonNull
    public CredentialPickerConfig getHintPickerConfig() {
        return this.zbb;
    }

    @RecentlyNullable
    public String getIdTokenNonce() {
        return this.zbh;
    }

    @RecentlyNullable
    public String getServerClientId() {
        return this.zbg;
    }

    static {
        zbe zbe2;
        CREATOR = zbe2 = new zbe();
    }

    @SafeParcelable.Constructor
    HintRequest(@SafeParcelable.Param(id=1000) int n, @SafeParcelable.Param(id=1) CredentialPickerConfig credentialPickerConfig, @SafeParcelable.Param(id=2) boolean bl, @SafeParcelable.Param(id=3) boolean bl2, @SafeParcelable.Param(id=4) String[] stringArray, @SafeParcelable.Param(id=5) boolean bl3, @SafeParcelable.Param(id=6) @Nullable String string, @SafeParcelable.Param(id=7) @Nullable String string2) {
        this.zba = n;
        this.zbb = (CredentialPickerConfig)((Object)Preconditions.checkNotNull((Object)((Object)credentialPickerConfig)));
        this.zbc = bl;
        this.zbd = bl2;
        this.zbe = (String[])Preconditions.checkNotNull((Object)stringArray);
        if (this.zba < 2) {
            this.zbf = true;
            this.zbg = null;
            this.zbh = null;
            return;
        }
        this.zbf = bl3;
        this.zbg = string;
        this.zbh = string2;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@RecentlyNonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)1, (Parcelable)this.getHintPickerConfig(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)2, (boolean)this.isEmailAddressIdentifierSupported());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)3, (boolean)this.zbd);
        SafeParcelWriter.writeStringArray((Parcel)var1_1, (int)4, (String[])this.getAccountTypes(), (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)5, (boolean)this.isIdTokenRequested());
        SafeParcelWriter.writeString((Parcel)var1_1, (int)6, (String)this.getServerClientId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)7, (String)this.getIdTokenNonce(), (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)1000, (int)this.zba);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean isEmailAddressIdentifierSupported() {
        return this.zbc;
    }

    public boolean isIdTokenRequested() {
        return this.zbf;
    }

    @NonNull
    public String[] getAccountTypes() {
        return this.zbe;
    }

    public static final class Builder {
        private boolean zba;
        private boolean zbb;
        private String[] zbc;
        private CredentialPickerConfig zbd;
        private boolean zbe;
        @Nullable
        private String zbf;
        @Nullable
        private String zbg;

        @RecentlyNonNull
        public Builder setAccountTypes(String ... accountTypes) {
            String[] stringArray;
            if (accountTypes == null) {
                stringArray = new String[]{};
            }
            this.zbc = stringArray;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder setEmailAddressIdentifierSupported(boolean emailAddressIdentifierSupported) {
            void var1_1;
            this.zba = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder setHintPickerConfig(@RecentlyNonNull CredentialPickerConfig hintPickerConfig) {
            void var1_1;
            this.zbd = (CredentialPickerConfig)((Object)Preconditions.checkNotNull((Object)var1_1));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder setIdTokenNonce(@Nullable String idTokenNonce) {
            void var1_1;
            this.zbg = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder setIdTokenRequested(boolean idTokenRequested) {
            void var1_1;
            this.zbe = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder setPhoneNumberIdentifierSupported(boolean phoneNumberIdentifierSupported) {
            void var1_1;
            this.zbb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder setServerClientId(@Nullable String serverClientId) {
            void var1_1;
            this.zbf = var1_1;
            return this;
        }

        @RecentlyNonNull
        public HintRequest build() {
            boolean bl;
            if (((Builder)this_).zbc == null) {
                ((Builder)this_).zbc = new String[0];
            }
            if (!(bl = ((Builder)this_).zba) && !((Builder)this_).zbb && ((Builder)this_).zbc.length == 0) {
                Object this_ = new IllegalStateException("At least one authentication method must be specified");
                throw this_;
            }
            HintRequest hintRequest = new HintRequest(2, ((Builder)this_).zbd, bl, ((Builder)this_).zbb, ((Builder)this_).zbc, ((Builder)this_).zbe, ((Builder)this_).zbf, ((Builder)this_).zbg);
            return hintRequest;
        }

        public Builder() {
            CredentialPickerConfig.Builder builder = new CredentialPickerConfig.Builder();
            this.zbd = builder.build();
            this.zbe = false;
        }
    }
}

