/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.auth-api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.api.identity.BeginSignInRequest;
import com.google.android.gms.auth.api.identity.BeginSignInResult;
import com.google.android.gms.auth.api.identity.GetSignInIntentRequest;
import com.google.android.gms.auth.api.identity.SignInClient;
import com.google.android.gms.auth.api.identity.SignInCredential;
import com.google.android.gms.auth.api.identity.zbl;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.IStatusCallback;
import com.google.android.gms.common.api.internal.RemoteCall;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.internal.auth-api.zbag;
import com.google.android.gms.internal.auth-api.zban;
import com.google.android.gms.internal.auth-api.zbao;
import com.google.android.gms.internal.auth-api.zbap;
import com.google.android.gms.internal.auth-api.zbaq;
import com.google.android.gms.internal.auth-api.zbas;
import com.google.android.gms.internal.auth-api.zbav;
import com.google.android.gms.internal.auth-api.zbaw;
import com.google.android.gms.internal.auth-api.zbax;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;

public final class zbau
extends GoogleApi<zbl>
implements SignInClient {
    private static final Api.ClientKey<zbav> zba;
    private static final Api.AbstractClientBuilder<zbav, zbl> zbb;
    private static final Api<zbl> zbc;
    private final String zbd = zbax.zba();

    @Override
    public final SignInCredential getSignInCredentialFromIntent(@Nullable Intent intent) throws ApiException {
        Object object;
        if (intent == null) {
            object = new ApiException(Status.RESULT_INTERNAL_ERROR);
            throw object;
        }
        object = (Status)SafeParcelableSerializer.deserializeFromIntentExtra((Intent)intent, (String)"status", (Parcelable.Creator)Status.CREATOR);
        if (object == null) {
            object = new ApiException(Status.RESULT_CANCELED);
            throw object;
        }
        if (!object.isSuccess()) {
            intent = new ApiException((Status)object);
            throw intent;
        }
        object = (SignInCredential)SafeParcelableSerializer.deserializeFromIntentExtra((Intent)intent, (String)"sign_in_credential", SignInCredential.CREATOR);
        if (object == null) {
            object = new ApiException(Status.RESULT_INTERNAL_ERROR);
            throw object;
        }
        return object;
    }

    @Override
    public final Task<BeginSignInResult> beginSignIn(@NonNull BeginSignInRequest object) {
        object = BeginSignInRequest.zba(object);
        ((BeginSignInRequest.Builder)object).zba(this.zbd);
        object = ((BeginSignInRequest.Builder)object).build();
        TaskApiCall.Builder builder = TaskApiCall.builder();
        Object object2 = new Feature[]{zbaw.zba};
        builder = builder.setFeatures(object2);
        object2 = new zbao(this, (BeginSignInRequest)((Object)object));
        return this.doRead(builder.run((RemoteCall)object2).setAutoResolveMissingFeatures(false).setMethodKey(1553).build());
    }

    @Override
    public final Task<PendingIntent> getSignInIntent(@NonNull GetSignInIntentRequest object) {
        object = GetSignInIntentRequest.zba(object);
        ((GetSignInIntentRequest.Builder)object).zba(this.zbd);
        object = ((GetSignInIntentRequest.Builder)object).build();
        TaskApiCall.Builder builder = TaskApiCall.builder();
        Object object2 = new Feature[]{zbaw.zbf};
        builder = builder.setFeatures(object2);
        object2 = new zbap(this, (GetSignInIntentRequest)((Object)object));
        return this.doRead(builder.run((RemoteCall)object2).setMethodKey(1555).build());
    }

    @Override
    public final Task<Void> signOut() {
        this.getApplicationContext().getSharedPreferences("com.google.android.gms.signin", 0).edit().clear().apply();
        TaskApiCall.Builder builder = GoogleApiClient.getAllClients().iterator();
        while (builder.hasNext()) {
            ((GoogleApiClient)builder.next()).maybeSignOut();
        }
        GoogleApiManager.reportSignOut();
        builder = TaskApiCall.builder();
        Object object = new Feature[]{zbaw.zbb};
        builder = builder.setFeatures(object);
        object = new zban(this);
        return this.doRead(builder.run((RemoteCall)object).setAutoResolveMissingFeatures(false).setMethodKey(1554).build());
    }

    static {
        Object object;
        zba = object = new Api.ClientKey();
        zbb = object = new zbaq();
        zbc = object = new Api("Auth.Api.Identity.SignIn.API", zbb, zba);
    }

    public zbau(@NonNull Activity activity, @NonNull zbl zbl2) {
        super(activity, zbc, (Api.ApiOptions)zbl2, GoogleApi.Settings.DEFAULT_SETTINGS);
    }

    public zbau(@NonNull Context context, @NonNull zbl zbl2) {
        super(context, zbc, (Api.ApiOptions)zbl2, GoogleApi.Settings.DEFAULT_SETTINGS);
    }

    public final /* synthetic */ void zba(zbav zbav2, TaskCompletionSource taskCompletionSource) throws RemoteException {
        zbas zbas2 = new zbas(this, taskCompletionSource);
        ((zbag)zbav2.getService()).zbe((IStatusCallback)zbas2, this.zbd);
    }
}

