/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.api.credentials.IdToken;
import com.google.android.gms.auth.api.credentials.zba;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

@Deprecated
@SafeParcelable.Reserved(value={1000, 1001, 1002})
@SafeParcelable.Class(creator="CredentialCreator")
public class Credential
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @NonNull
    public static final String EXTRA_KEY = "com.google.android.gms.credentials.Credential";
    @NonNull
    public static final Parcelable.Creator<Credential> CREATOR = new zba();
    @Nonnull
    @SafeParcelable.Field(id=1, getter="getId")
    private final String zba;
    @SafeParcelable.Field(id=2, getter="getName")
    @Nullable
    private final String zbb;
    @SafeParcelable.Field(id=3, getter="getProfilePictureUri")
    @Nullable
    private final Uri zbc;
    @Nonnull
    @SafeParcelable.Field(id=4, getter="getIdTokens")
    private final List zbd;
    @SafeParcelable.Field(id=5, getter="getPassword")
    @Nullable
    private final String zbe;
    @SafeParcelable.Field(id=6, getter="getAccountType")
    @Nullable
    private final String zbf;
    @SafeParcelable.Field(id=9, getter="getGivenName")
    @Nullable
    private final String zbg;
    @SafeParcelable.Field(id=10, getter="getFamilyName")
    @Nullable
    private final String zbh;

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zba, this.zbb, this.zbc, this.zbe, this.zbf});
    }

    @Nullable
    public Uri getProfilePictureUri() {
        return this.zbc;
    }

    @Nullable
    public String getAccountType() {
        return this.zbf;
    }

    @Nullable
    public String getFamilyName() {
        return this.zbh;
    }

    @Nullable
    public String getGivenName() {
        return this.zbg;
    }

    @Nonnull
    public String getId() {
        return this.zba;
    }

    @Nullable
    public String getName() {
        return this.zbb;
    }

    @Nullable
    public String getPassword() {
        return this.zbe;
    }

    @Nonnull
    public List<IdToken> getIdTokens() {
        return this.zbd;
    }

    /*
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    Credential(@SafeParcelable.Param(id=1) String uri, @SafeParcelable.Param(id=2) @Nullable String string, @SafeParcelable.Param(id=3) @Nullable Uri uri2, @SafeParcelable.Param(id=4) List list, @SafeParcelable.Param(id=5) @Nullable String string2, @SafeParcelable.Param(id=6) @Nullable String string3, @SafeParcelable.Param(id=9) @Nullable String string4, @SafeParcelable.Param(id=10) @Nullable String string5) {
        String string6 = ((String)Preconditions.checkNotNull((Object)uri, (Object)"credential identifier cannot be null")).trim();
        Preconditions.checkNotEmpty((String)string6, (Object)"credential identifier cannot be empty");
        if (string2 != null && TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Password must not be empty if set");
        }
        if (string3 != null) {
            if (TextUtils.isEmpty((CharSequence)string3)) {
                uri = Boolean.valueOf(false);
            } else {
                uri = Uri.parse((String)string3);
                if (!uri.isAbsolute() || !uri.isHierarchical() || TextUtils.isEmpty((CharSequence)uri.getScheme()) || TextUtils.isEmpty((CharSequence)uri.getAuthority())) {
                    uri = Boolean.valueOf(false);
                } else {
                    String string7 = uri.getScheme();
                    boolean bl = !"http".equalsIgnoreCase(string7) ? "https".equalsIgnoreCase((String)(uri = uri.getScheme())) : true;
                    uri = Boolean.valueOf(bl);
                }
            }
            if (!uri.booleanValue()) {
                throw new IllegalArgumentException("Account type must be a valid Http/Https URI");
            }
        }
        if (!TextUtils.isEmpty((CharSequence)string3) && !TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Password and AccountType are mutually exclusive");
        }
        if (string != null && TextUtils.isEmpty((CharSequence)string.trim())) {
            string = null;
        }
        this.zbb = string;
        this.zbc = uri2;
        uri = list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
        this.zbd = uri;
        this.zba = string6;
        this.zbe = string2;
        this.zbf = string3;
        this.zbg = string4;
        this.zbh = string5;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)1, (String)this.getId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.getName(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)3, (Parcelable)this.getProfilePictureUri(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)4, this.getIdTokens(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)5, (String)this.getPassword(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)6, (String)this.getAccountType(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)9, (String)this.getGivenName(), (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeString((Parcel)v1, (int)10, (String)this.getFamilyName(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n);
    }

    public boolean equals(@Nullable Object other) {
        Credential credential;
        if (this == credential) {
            return true;
        }
        if (!(credential instanceof Credential)) {
            return false;
        }
        credential = credential;
        return TextUtils.equals((CharSequence)this.zba, (CharSequence)credential.zba) && TextUtils.equals((CharSequence)this.zbb, (CharSequence)credential.zbb) && Objects.equal((Object)this.zbc, (Object)credential.zbc) && TextUtils.equals((CharSequence)this.zbe, (CharSequence)credential.zbe) && TextUtils.equals((CharSequence)this.zbf, (CharSequence)credential.zbf);
    }

    @Deprecated
    public static class Builder {
        private final String zba;
        @Nullable
        private String zbb;
        @Nullable
        private Uri zbc;
        private List zbd;
        @Nullable
        private String zbe;
        @Nullable
        private String zbf;
        @Nullable
        private String zbg;
        @Nullable
        private String zbh;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAccountType(@NonNull String accountType) {
            void var1_1;
            this.zbf = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setName(@NonNull String name) {
            void var1_1;
            this.zbb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setPassword(@Nullable String password) {
            void var1_1;
            this.zbe = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setProfilePictureUri(@NonNull Uri profilePictureUri) {
            void var1_1;
            this.zbc = var1_1;
            return this;
        }

        @NonNull
        public Credential build() {
            return new Credential(this.zba, this.zbb, this.zbc, this.zbd, this.zbe, this.zbf, this.zbg, this.zbh);
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull Credential credential) {
            void var1_1;
            this.zba = ((Credential)var1_1).zba;
            this.zbb = ((Credential)var1_1).zbb;
            this.zbc = ((Credential)var1_1).zbc;
            this.zbd = ((Credential)var1_1).zbd;
            this.zbe = ((Credential)var1_1).zbe;
            this.zbf = ((Credential)var1_1).zbf;
            this.zbg = ((Credential)var1_1).zbg;
            this.zbh = ((Credential)var1_1).zbh;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull String id) {
            void var1_1;
            this.zba = var1_1;
        }
    }
}

