/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.credentials.IdToken;
import com.google.android.gms.auth.api.credentials.zza;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import java.util.Collections;
import java.util.List;

public class Credential
implements SafeParcelable {
    public static final String EXTRA_KEY = "com.google.android.gms.credentials.Credential";
    public static final Parcelable.Creator<Credential> CREATOR = new zza();
    final int mVersionCode;
    private final String zzxX;
    private final String mName;
    private final Uri zzUy;
    private final List<IdToken> zzUz;
    private final String zzUA;
    private final String zzUB;
    private final String zzUC;
    private final String zzUD;

    Credential(int version, String id, String name, Uri profilePictureUri, List<IdToken> idTokens, String password, String accountType, String generatedPassword, String generatedHintId) {
        this.mVersionCode = version;
        String string = ((String)zzx.zzb((Object)id, (Object)"credential identifier cannot be null")).trim();
        zzx.zzh((String)string, (Object)"credential identifier cannot be empty");
        this.zzxX = string;
        this.mName = name;
        this.zzUy = profilePictureUri;
        this.zzUz = idTokens == null ? Collections.emptyList() : Collections.unmodifiableList(idTokens);
        this.zzUA = password;
        if (password != null && password.isEmpty()) {
            throw new IllegalArgumentException("password cannot be empty");
        }
        if (!TextUtils.isEmpty((CharSequence)accountType)) {
            Uri uri = Uri.parse((String)accountType);
            String string2 = uri.getScheme();
            zzx.zzab(("http".equalsIgnoreCase(string2) || "https".equalsIgnoreCase(string2) ? 1 : 0) != 0);
        }
        this.zzUB = accountType;
        this.zzUC = generatedPassword;
        this.zzUD = generatedHintId;
        if (!TextUtils.isEmpty((CharSequence)this.zzUA) && !TextUtils.isEmpty((CharSequence)this.zzUB)) {
            throw new IllegalStateException("password and accountType cannot both be set");
        }
    }

    public String getId() {
        return this.zzxX;
    }

    public String getName() {
        return this.mName;
    }

    public Uri getProfilePictureUri() {
        return this.zzUy;
    }

    public List<IdToken> getIdTokens() {
        return this.zzUz;
    }

    public String getPassword() {
        return this.zzUA;
    }

    public String getGeneratedPassword() {
        return this.zzUC;
    }

    public String getAccountType() {
        return this.zzUB;
    }

    public String zzmg() {
        return this.zzUD;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zza.zza(this, out, flags);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Credential)) {
            return false;
        }
        Credential credential = (Credential)other;
        return TextUtils.equals((CharSequence)this.zzxX, (CharSequence)credential.zzxX) && TextUtils.equals((CharSequence)this.mName, (CharSequence)credential.mName) && zzw.equal((Object)this.zzUy, (Object)credential.zzUy) && TextUtils.equals((CharSequence)this.zzUA, (CharSequence)credential.zzUA) && TextUtils.equals((CharSequence)this.zzUB, (CharSequence)credential.zzUB) && TextUtils.equals((CharSequence)this.zzUC, (CharSequence)credential.zzUC);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzxX, this.mName, this.zzUy, this.zzUA, this.zzUB, this.zzUC});
    }

    public static class Builder {
        private final String zzxX;
        private String mName;
        private Uri zzUy;
        private List<IdToken> zzUz;
        private String zzUA;
        private String zzUB;
        private String zzUC;
        private String zzUD;

        public Builder(String id) {
            this.zzxX = id;
        }

        public Builder(Credential credential) {
            this.zzxX = credential.zzxX;
            this.mName = credential.mName;
            this.zzUy = credential.zzUy;
            this.zzUz = credential.zzUz;
            this.zzUA = credential.zzUA;
            this.zzUB = credential.zzUB;
            this.zzUC = credential.zzUC;
            this.zzUD = credential.zzUD;
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setProfilePictureUri(Uri profilePictureUri) {
            this.zzUy = profilePictureUri;
            return this;
        }

        public Builder setPassword(String password) {
            this.zzUA = password;
            return this;
        }

        public Builder setAccountType(String accountType) {
            this.zzUB = accountType;
            return this;
        }

        public Credential build() {
            return new Credential(3, this.zzxX, this.mName, this.zzUy, this.zzUz, this.zzUA, this.zzUB, this.zzUC, this.zzUD);
        }
    }
}

