/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.auth.api.credentials.CredentialPickerConfig;
import com.google.android.gms.auth.api.credentials.zzd;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;

public final class HintRequest
implements SafeParcelable {
    public static final Parcelable.Creator<HintRequest> CREATOR = new zzd();
    final int mVersionCode;
    private final CredentialPickerConfig zzUK;
    private final boolean zzUL;
    private final boolean zzUM;
    private final String[] zzUH;

    HintRequest(int version, CredentialPickerConfig hintPickerConfig, boolean emailAddressIdentifierSupported, boolean phoneNumberIdentifierSupported, String[] accountTypes) {
        this.mVersionCode = version;
        this.zzUK = (CredentialPickerConfig)zzx.zzy((Object)hintPickerConfig);
        this.zzUL = emailAddressIdentifierSupported;
        this.zzUM = phoneNumberIdentifierSupported;
        this.zzUH = (String[])zzx.zzy((Object)accountTypes);
    }

    private HintRequest(Builder builder) {
        this(1, builder.zzUK, builder.zzUL, builder.zzUM, builder.zzUH);
    }

    public CredentialPickerConfig getHintPickerConfig() {
        return this.zzUK;
    }

    public boolean isEmailAddressIdentifierSupported() {
        return this.zzUL;
    }

    public boolean zzmh() {
        return this.zzUM;
    }

    public String[] getAccountTypes() {
        return this.zzUH;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzd.zza(this, out, flags);
    }

    public static final class Builder {
        private boolean zzUL;
        private boolean zzUM;
        private String[] zzUH;
        private CredentialPickerConfig zzUK = new CredentialPickerConfig.Builder().build();

        public Builder setEmailAddressIdentifierSupported(boolean emailAddressIdentifierSupported) {
            this.zzUL = emailAddressIdentifierSupported;
            return this;
        }

        public Builder setAccountTypes(String ... accountTypes) {
            if (accountTypes == null) {
                accountTypes = new String[]{};
            }
            this.zzUH = accountTypes;
            return this;
        }

        public Builder setHintPickerConfig(CredentialPickerConfig hintPickerConfig) {
            this.zzUK = (CredentialPickerConfig)zzx.zzy((Object)hintPickerConfig);
            return this;
        }

        public HintRequest build() {
            if (this.zzUH == null) {
                this.zzUH = new String[0];
            }
            if (!this.zzUL && !this.zzUM && this.zzUH.length == 0) {
                throw new IllegalStateException("At least one authentication method must be specified");
            }
            return new HintRequest(this);
        }
    }
}

