/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.auth.api.credentials.CredentialPickerConfig;
import com.google.android.gms.auth.api.credentials.zzc;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;

public final class CredentialRequest
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<CredentialRequest> CREATOR = new zzc();
    final int mVersionCode;
    private final boolean zzabD;
    private final String[] zzabE;
    private final CredentialPickerConfig zzabF;
    private final CredentialPickerConfig zzabG;

    CredentialRequest(int n, boolean bl, String[] stringArray, CredentialPickerConfig credentialPickerConfig, CredentialPickerConfig credentialPickerConfig2) {
        this.mVersionCode = n;
        this.zzabD = bl;
        this.zzabE = (String[])zzaa.zzz((Object)stringArray);
        this.zzabF = credentialPickerConfig == null ? new CredentialPickerConfig.Builder().build() : credentialPickerConfig;
        this.zzabG = credentialPickerConfig2 == null ? new CredentialPickerConfig.Builder().build() : credentialPickerConfig2;
    }

    private CredentialRequest(Builder builder) {
        this(2, builder.zzabD, builder.zzabE, builder.zzabF, builder.zzabG);
    }

    @Deprecated
    public boolean getSupportsPasswordLogin() {
        return this.isPasswordLoginSupported();
    }

    public boolean isPasswordLoginSupported() {
        return this.zzabD;
    }

    @NonNull
    public String[] getAccountTypes() {
        return this.zzabE;
    }

    @NonNull
    public CredentialPickerConfig getCredentialPickerConfig() {
        return this.zzabF;
    }

    @NonNull
    public CredentialPickerConfig getCredentialHintPickerConfig() {
        return this.zzabG;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzc.zza(this, parcel, n);
    }

    public static final class Builder {
        private boolean zzabD;
        private String[] zzabE;
        private CredentialPickerConfig zzabF;
        private CredentialPickerConfig zzabG;

        @Deprecated
        public Builder setSupportsPasswordLogin(boolean bl) {
            return this.setPasswordLoginSupported(bl);
        }

        public Builder setPasswordLoginSupported(boolean bl) {
            this.zzabD = bl;
            return this;
        }

        public Builder setAccountTypes(String ... stringArray) {
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            this.zzabE = stringArray;
            return this;
        }

        public Builder setCredentialPickerConfig(CredentialPickerConfig credentialPickerConfig) {
            this.zzabF = credentialPickerConfig;
            return this;
        }

        public Builder setCredentialHintPickerConfig(CredentialPickerConfig credentialPickerConfig) {
            this.zzabG = credentialPickerConfig;
            return this;
        }

        public CredentialRequest build() {
            if (this.zzabE == null) {
                this.zzabE = new String[0];
            }
            if (!this.zzabD && this.zzabE.length == 0) {
                throw new IllegalStateException("At least one authentication method must be specified");
            }
            return new CredentialRequest(this);
        }
    }
}

