/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin.internal;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.util.Log;
import android.view.accessibility.AccessibilityEvent;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.SignInAccount;
import com.google.android.gms.auth.api.signin.internal.SignInConfiguration;
import com.google.android.gms.auth.api.signin.internal.zzb;
import com.google.android.gms.auth.api.signin.internal.zzk;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;

@KeepName
public class SignInHubActivity
extends FragmentActivity {
    private zzk zzacV;
    private SignInConfiguration zzacW;
    private boolean zzacX;
    private int zzacY;
    private Intent zzacZ;

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.zzacV = zzk.zzab((Context)this);
        Intent intent = this.getIntent();
        if (!"com.google.android.gms.auth.GOOGLE_SIGN_IN".equals(intent.getAction())) {
            String string = String.valueOf(intent.getAction());
            Log.e((String)"AuthSignInClient", (String)(string.length() != 0 ? "Unknown action: ".concat(string) : new String("Unknown action: ")));
            this.finish();
        }
        this.zzacW = (SignInConfiguration)intent.getParcelableExtra("config");
        if (this.zzacW == null) {
            Log.e((String)"AuthSignInClient", (String)"Activity started with invalid configuration.");
            this.setResult(0);
            this.finish();
            return;
        }
        if (bundle == null) {
            this.zzj(new Intent("com.google.android.gms.auth.GOOGLE_SIGN_IN"));
        } else {
            this.zzacX = bundle.getBoolean("signingInGoogleApiClients");
            if (this.zzacX) {
                this.zzacY = bundle.getInt("signInResultCode");
                this.zzacZ = (Intent)bundle.getParcelable("signInResultData");
                this.zzpB();
            }
        }
    }

    protected void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean("signingInGoogleApiClients", this.zzacX);
        if (this.zzacX) {
            bundle.putInt("signInResultCode", this.zzacY);
            bundle.putParcelable("signInResultData", (Parcelable)this.zzacZ);
        }
    }

    protected void onActivityResult(int n, int n2, Intent intent) {
        this.setResult(0);
        switch (n) {
            case 40962: {
                this.zza(n2, intent);
            }
        }
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        return true;
    }

    private void zza(int n, Intent intent) {
        if (intent != null) {
            SignInAccount signInAccount = (SignInAccount)intent.getParcelableExtra("signInAccount");
            if (signInAccount != null && signInAccount.zzpp() != null) {
                GoogleSignInAccount googleSignInAccount = signInAccount.zzpp();
                this.zzacV.zzb(googleSignInAccount, this.zzacW.zzpA());
                intent.removeExtra("signInAccount");
                intent.putExtra("googleSignInAccount", (Parcelable)googleSignInAccount);
                this.zzacX = true;
                this.zzacY = n;
                this.zzacZ = intent;
                this.zzpB();
                return;
            }
            if (intent.hasExtra("errorCode")) {
                int n2 = intent.getIntExtra("errorCode", 8);
                this.zzbc(n2);
                return;
            }
        }
        this.zzbc(8);
    }

    private void zzj(Intent intent) {
        intent.setPackage("com.google.android.gms");
        intent.putExtra("config", (Parcelable)this.zzacW);
        try {
            this.startActivityForResult(intent, 40962);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            Log.w((String)"AuthSignInClient", (String)"Could not launch sign in Intent. Google Play Service is probably being updated...");
            this.zzbc(8);
        }
    }

    private void zzpB() {
        this.getSupportLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)new zza());
    }

    private void zzbc(int n) {
        Status status = new Status(n);
        Intent intent = new Intent();
        intent.putExtra("googleSignInStatus", (Parcelable)status);
        this.setResult(0, intent);
        this.finish();
    }

    private class zza
    implements LoaderManager.LoaderCallbacks<Void> {
        private zza() {
        }

        public Loader<Void> onCreateLoader(int n, Bundle bundle) {
            return new zzb((Context)SignInHubActivity.this, GoogleApiClient.zzrq());
        }

        public void zza(Loader<Void> loader, Void void_) {
            SignInHubActivity.this.setResult(SignInHubActivity.this.zzacY, SignInHubActivity.this.zzacZ);
            SignInHubActivity.this.finish();
        }

        public void onLoaderReset(Loader<Void> loader) {
        }

        public /* synthetic */ void onLoadFinished(Loader loader, Object object) {
            this.zza((Loader<Void>)loader, (Void)object);
        }
    }
}

