/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin.internal;

import android.accounts.Account;
import android.content.Context;
import android.content.Intent;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.auth.api.Auth;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInApi;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.auth.api.signin.GoogleSignInResult;
import com.google.android.gms.auth.api.signin.internal.zzd;
import com.google.android.gms.auth.api.signin.internal.zzh;
import com.google.android.gms.auth.api.signin.internal.zzk;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.OptionalPendingResult;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.PendingResults;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zznt;
import com.google.android.gms.internal.zzox;
import java.util.HashSet;

public class zzc
implements GoogleSignInApi {
    @Override
    public Intent getSignInIntent(GoogleApiClient googleApiClient) {
        zzaa.zzz((Object)googleApiClient);
        return ((zzd)googleApiClient.zza(Auth.zzabn)).zzpt();
    }

    @Override
    public OptionalPendingResult<GoogleSignInResult> silentSignIn(GoogleApiClient googleApiClient) {
        GoogleSignInOptions googleSignInOptions = this.zzb(googleApiClient);
        GoogleSignInResult googleSignInResult = this.zza(googleApiClient.getContext(), googleSignInOptions);
        if (googleSignInResult != null) {
            return PendingResults.zzb((Result)googleSignInResult, (GoogleApiClient)googleApiClient);
        }
        return this.zza(googleApiClient, googleSignInOptions);
    }

    public GoogleSignInResult zza(Context context, GoogleSignInOptions googleSignInOptions) {
        HashSet hashSet;
        HashSet hashSet2;
        Log.d((String)"GoogleSignInApiImpl", (String)"getSavedSignInResultIfEligible");
        zzaa.zzz((Object)googleSignInOptions);
        zzk zzk2 = zzk.zzab((Context)context);
        GoogleSignInOptions googleSignInOptions2 = zzk2.zzpD();
        if (googleSignInOptions2 == null) {
            return null;
        }
        if (!this.zza(googleSignInOptions2.getAccount(), googleSignInOptions.getAccount())) {
            return null;
        }
        if (googleSignInOptions.zzpl()) {
            return null;
        }
        if (googleSignInOptions.zzpk()) {
            if (!googleSignInOptions2.zzpk()) {
                return null;
            }
            if (!googleSignInOptions.zzpn().equals(googleSignInOptions2.zzpn())) {
                return null;
            }
        }
        if (!(hashSet2 = new HashSet(googleSignInOptions2.zzpj())).containsAll(hashSet = new HashSet(googleSignInOptions.zzpj()))) {
            return null;
        }
        GoogleSignInAccount googleSignInAccount = zzk2.zzpC();
        if (googleSignInAccount != null && !googleSignInAccount.zza()) {
            return new GoogleSignInResult(googleSignInAccount, Status.zzalw);
        }
        return null;
    }

    private boolean zza(Account account, Account account2) {
        if (account == null) {
            return account2 == null;
        }
        return account.equals((Object)account2);
    }

    private OptionalPendingResult<GoogleSignInResult> zza(GoogleApiClient googleApiClient, final GoogleSignInOptions googleSignInOptions) {
        Log.d((String)"GoogleSignInApiImpl", (String)"trySilentSignIn");
        zznt.zza zza2 = googleApiClient.zzc((zznt.zza)new zza<GoogleSignInResult>(googleApiClient){

            protected void zza(zzd zzd2) throws RemoteException {
                final zzk zzk2 = zzk.zzab((Context)zzd2.getContext());
                ((zzh)zzd2.zztm()).zza(new com.google.android.gms.auth.api.signin.internal.zza(){

                    @Override
                    public void zza(GoogleSignInAccount googleSignInAccount, Status status) throws RemoteException {
                        if (googleSignInAccount != null) {
                            zzk2.zzb(googleSignInAccount, googleSignInOptions);
                        }
                        this.zzb(new GoogleSignInResult(googleSignInAccount, status));
                    }
                }, googleSignInOptions);
            }

            protected GoogleSignInResult zzm(Status status) {
                return new GoogleSignInResult(null, status);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzm(status);
            }
        });
        return new zzox((PendingResult)zza2);
    }

    @Override
    public PendingResult<Status> signOut(GoogleApiClient googleApiClient) {
        zzk zzk2 = zzk.zzab((Context)googleApiClient.getContext());
        zzk2.zzpE();
        for (GoogleApiClient googleApiClient2 : GoogleApiClient.zzrq()) {
            googleApiClient2.zzrr();
        }
        return googleApiClient.zzd((zznt.zza)new zza<Status>(googleApiClient){

            protected void zza(zzd zzd2) throws RemoteException {
                ((zzh)zzd2.zztm()).zzb(new com.google.android.gms.auth.api.signin.internal.zza(){

                    @Override
                    public void zzk(Status status) throws RemoteException {
                        this.zzb((Result)status);
                    }
                }, zzd2.zzpu());
            }

            protected Status zzb(Status status) {
                return status;
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzb(status);
            }
        });
    }

    @Override
    public PendingResult<Status> revokeAccess(GoogleApiClient googleApiClient) {
        zzk zzk2 = zzk.zzab((Context)googleApiClient.getContext());
        zzk2.zzpE();
        for (GoogleApiClient googleApiClient2 : GoogleApiClient.zzrq()) {
            googleApiClient2.zzrr();
        }
        return googleApiClient.zzd((zznt.zza)new zza<Status>(googleApiClient){

            protected void zza(zzd zzd2) throws RemoteException {
                ((zzh)zzd2.zztm()).zzc(new com.google.android.gms.auth.api.signin.internal.zza(){

                    @Override
                    public void zzl(Status status) throws RemoteException {
                        this.zzb((Result)status);
                    }
                }, zzd2.zzpu());
            }

            protected Status zzb(Status status) {
                return status;
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzb(status);
            }
        });
    }

    @Override
    public GoogleSignInResult getSignInResultFromIntent(Intent intent) {
        if (intent == null || !intent.hasExtra("googleSignInStatus") && !intent.hasExtra("googleSignInAccount")) {
            return null;
        }
        GoogleSignInAccount googleSignInAccount = (GoogleSignInAccount)intent.getParcelableExtra("googleSignInAccount");
        Status status = (Status)intent.getParcelableExtra("googleSignInStatus");
        if (googleSignInAccount != null) {
            status = Status.zzalw;
        }
        return new GoogleSignInResult(googleSignInAccount, status);
    }

    private GoogleSignInOptions zzb(GoogleApiClient googleApiClient) {
        return ((zzd)googleApiClient.zza(Auth.zzabn)).zzpu();
    }

    private abstract class zza<R extends Result>
    extends zznt.zza<R, zzd> {
        public zza(GoogleApiClient googleApiClient) {
            super(Auth.GOOGLE_SIGN_IN_API, googleApiClient);
        }
    }
}

