/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.contextmanager;

import com.google.android.gms.internal.contextmanager.zzjn;
import com.google.android.gms.internal.contextmanager.zzlc;
import com.google.android.gms.internal.contextmanager.zzli;
import com.google.android.gms.internal.contextmanager.zzmx;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzjq
extends zzjn<Boolean>
implements zzli<Boolean>,
zzmx,
RandomAccess {
    private static final zzjq zzyy = new zzjq(new boolean[0], 0);
    private boolean[] zzyz;
    private int size;

    zzjq() {
        this(new boolean[10], 0);
    }

    private zzjq(boolean[] blArray, int n) {
        this.zzyz = blArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzcj();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzyz, n2, this.zzyz, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzjq)) {
            return super.equals(object);
        }
        zzjq zzjq2 = (zzjq)object;
        if (this.size != zzjq2.size) {
            return false;
        }
        boolean[] blArray = zzjq2.zzyz;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzyz[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzlc.zze(this.zzyz[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void addBoolean(boolean bl) {
        this.zzcj();
        if (this.size == this.zzyz.length) {
            boolean[] blArray = new boolean[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzyz, 0, blArray, 0, this.size);
            this.zzyz = blArray;
        }
        this.zzyz[this.size++] = bl;
    }

    @Override
    public final boolean addAll(Collection<? extends Boolean> collection) {
        this.zzcj();
        zzlc.checkNotNull(collection);
        if (!(collection instanceof zzjq)) {
            return super.addAll(collection);
        }
        zzjq zzjq2 = (zzjq)collection;
        if (zzjq2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzjq2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzjq2.size;
        if (n > this.zzyz.length) {
            this.zzyz = Arrays.copyOf(this.zzyz, n);
        }
        System.arraycopy(zzjq2.zzyz, 0, this.zzyz, this.size, zzjq2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzcj();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzyz[i])) continue;
            System.arraycopy(this.zzyz, i + 1, this.zzyz, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzat(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzau(n));
        }
    }

    private final String zzau(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        zzjq zzjq2 = this;
        zzjq2.zzcj();
        zzjq2.zzat(n);
        boolean bl3 = zzjq2.zzyz[n];
        zzjq2.zzyz[n] = bl2;
        return bl3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzjq zzjq2 = this;
        zzjq2.zzcj();
        zzjq2.zzat(n);
        boolean bl = zzjq2.zzyz[n];
        if (n < zzjq2.size - 1) {
            System.arraycopy(zzjq2.zzyz, n + 1, zzjq2.zzyz, n, zzjq2.size - n - 1);
        }
        --zzjq2.size;
        ++zzjq2.modCount;
        return bl;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        zzjq zzjq2 = this;
        zzjq2.zzcj();
        if (n < 0 || n > zzjq2.size) {
            throw new IndexOutOfBoundsException(zzjq2.zzau(n));
        }
        if (zzjq2.size < zzjq2.zzyz.length) {
            System.arraycopy(zzjq2.zzyz, n, zzjq2.zzyz, n + 1, zzjq2.size - n);
        } else {
            boolean[] blArray = new boolean[zzjq2.size * 3 / 2 + 1];
            System.arraycopy(zzjq2.zzyz, 0, blArray, 0, n);
            System.arraycopy(zzjq2.zzyz, n, blArray, n + 1, zzjq2.size - n);
            zzjq2.zzyz = blArray;
        }
        zzjq2.zzyz[n] = bl2;
        ++zzjq2.size;
        ++zzjq2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Boolean bl = (Boolean)object;
        this.addBoolean(bl);
        return true;
    }

    @Override
    public final /* synthetic */ zzli zzav(int n) {
        int n2 = n;
        zzjq zzjq2 = this;
        if (n2 < zzjq2.size) {
            throw new IllegalArgumentException();
        }
        return new zzjq(Arrays.copyOf(zzjq2.zzyz, n2), zzjq2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzjq zzjq2 = this;
        zzjq2.zzat(n);
        return zzjq2.zzyz[n];
    }

    static {
        zzyy.zzci();
    }
}

