/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.contextmanager;

import com.google.android.gms.internal.contextmanager.zzjn;
import com.google.android.gms.internal.contextmanager.zzlc;
import com.google.android.gms.internal.contextmanager.zzli;
import com.google.android.gms.internal.contextmanager.zzmx;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzkk
extends zzjn<Double>
implements zzli<Double>,
zzmx,
RandomAccess {
    private static final zzkk zzzw = new zzkk(new double[0], 0);
    private double[] zzzx;
    private int size;

    zzkk() {
        this(new double[10], 0);
    }

    private zzkk(double[] dArray, int n) {
        this.zzzx = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzcj();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzzx, n2, this.zzzx, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzkk)) {
            return super.equals(object);
        }
        zzkk zzkk2 = (zzkk)object;
        if (this.size != zzkk2.size) {
            return false;
        }
        double[] dArray = zzkk2.zzzx;
        for (int i = 0; i < this.size; ++i) {
            if (Double.doubleToLongBits(this.zzzx[i]) == Double.doubleToLongBits(dArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzzx[i]);
            n = n * 31 + zzlc.zzz(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzg(double d) {
        this.zzcj();
        if (this.size == this.zzzx.length) {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzzx, 0, dArray, 0, this.size);
            this.zzzx = dArray;
        }
        this.zzzx[this.size++] = d;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzcj();
        zzlc.checkNotNull(collection);
        if (!(collection instanceof zzkk)) {
            return super.addAll(collection);
        }
        zzkk zzkk2 = (zzkk)collection;
        if (zzkk2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzkk2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzkk2.size;
        if (n > this.zzzx.length) {
            this.zzzx = Arrays.copyOf(this.zzzx, n);
        }
        System.arraycopy(zzkk2.zzzx, 0, this.zzzx, this.size, zzkk2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzcj();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzzx[i])) continue;
            System.arraycopy(this.zzzx, i + 1, this.zzzx, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzat(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzau(n));
        }
    }

    private final String zzau(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzkk zzkk2 = this;
        zzkk2.zzcj();
        zzkk2.zzat(n);
        double d3 = zzkk2.zzzx[n];
        zzkk2.zzzx[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzkk zzkk2 = this;
        zzkk2.zzcj();
        zzkk2.zzat(n);
        double d = zzkk2.zzzx[n];
        if (n < zzkk2.size - 1) {
            System.arraycopy(zzkk2.zzzx, n + 1, zzkk2.zzzx, n, zzkk2.size - n - 1);
        }
        --zzkk2.size;
        ++zzkk2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzkk zzkk2 = this;
        zzkk2.zzcj();
        if (n < 0 || n > zzkk2.size) {
            throw new IndexOutOfBoundsException(zzkk2.zzau(n));
        }
        if (zzkk2.size < zzkk2.zzzx.length) {
            System.arraycopy(zzkk2.zzzx, n, zzkk2.zzzx, n + 1, zzkk2.size - n);
        } else {
            double[] dArray = new double[zzkk2.size * 3 / 2 + 1];
            System.arraycopy(zzkk2.zzzx, 0, dArray, 0, n);
            System.arraycopy(zzkk2.zzzx, n, dArray, n + 1, zzkk2.size - n);
            zzkk2.zzzx = dArray;
        }
        zzkk2.zzzx[n] = d2;
        ++zzkk2.size;
        ++zzkk2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Double d = (Double)object;
        this.zzg(d);
        return true;
    }

    @Override
    public final /* synthetic */ zzli zzav(int n) {
        int n2 = n;
        zzkk zzkk2 = this;
        if (n2 < zzkk2.size) {
            throw new IllegalArgumentException();
        }
        return new zzkk(Arrays.copyOf(zzkk2.zzzx, n2), zzkk2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzkk zzkk2 = this;
        zzkk2.zzat(n);
        return zzkk2.zzzx[n];
    }

    static {
        zzzw.zzci();
    }
}

