/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.awareness;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.awareness.Awareness;
import com.google.android.gms.awareness.AwarenessOptions;
import com.google.android.gms.awareness.snapshot.BeaconStateResponse;
import com.google.android.gms.awareness.snapshot.DetectedActivityResponse;
import com.google.android.gms.awareness.snapshot.HeadphoneStateResponse;
import com.google.android.gms.awareness.snapshot.LocationResponse;
import com.google.android.gms.awareness.snapshot.TimeIntervalsResponse;
import com.google.android.gms.awareness.state.BeaconState;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.Response;
import com.google.android.gms.common.api.internal.ApiExceptionMapper;
import com.google.android.gms.common.api.internal.StatusExceptionMapper;
import com.google.android.gms.common.internal.PendingResultUtil;
import com.google.android.gms.tasks.Task;
import java.util.Collection;

public class SnapshotClient
extends GoogleApi<AwarenessOptions> {
    SnapshotClient(@NonNull Activity activity, @Nullable AwarenessOptions awarenessOptions) {
        super(activity, Awareness.API, null, (StatusExceptionMapper)new ApiExceptionMapper());
    }

    SnapshotClient(@NonNull Context context, @Nullable AwarenessOptions awarenessOptions) {
        super(context, Awareness.API, null, (StatusExceptionMapper)new ApiExceptionMapper());
    }

    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public Task<BeaconStateResponse> getBeaconState(@NonNull Collection<BeaconState.TypeFilter> collection) {
        return PendingResultUtil.toResponseTask(Awareness.SnapshotApi.getBeaconState(this.asGoogleApiClient(), collection), (Response)new BeaconStateResponse());
    }

    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public Task<BeaconStateResponse> getBeaconState(BeaconState.TypeFilter ... typeFilterArray) {
        return PendingResultUtil.toResponseTask(Awareness.SnapshotApi.getBeaconState(this.asGoogleApiClient(), typeFilterArray), (Response)new BeaconStateResponse());
    }

    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public Task<TimeIntervalsResponse> getTimeIntervals() {
        return PendingResultUtil.toResponseTask(Awareness.SnapshotApi.getTimeIntervals(this.asGoogleApiClient()), (Response)new TimeIntervalsResponse());
    }

    @RequiresPermission(value="com.google.android.gms.permission.ACTIVITY_RECOGNITION")
    public Task<DetectedActivityResponse> getDetectedActivity() {
        return PendingResultUtil.toResponseTask(Awareness.SnapshotApi.getDetectedActivity(this.asGoogleApiClient()), (Response)new DetectedActivityResponse());
    }

    public Task<HeadphoneStateResponse> getHeadphoneState() {
        return PendingResultUtil.toResponseTask(Awareness.SnapshotApi.getHeadphoneState(this.asGoogleApiClient()), (Response)new HeadphoneStateResponse());
    }

    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public Task<LocationResponse> getLocation() {
        return PendingResultUtil.toResponseTask(Awareness.SnapshotApi.getLocation(this.asGoogleApiClient()), (Response)new LocationResponse());
    }
}

