/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.contextmanager;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.awareness.state.BeaconState;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.contextmanager.zzax;
import com.google.android.gms.internal.contextmanager.zzdm;
import com.google.android.gms.internal.contextmanager.zzjk;
import com.google.android.gms.internal.contextmanager.zzk;
import com.google.android.gms.internal.contextmanager.zzkd;
import com.google.android.gms.internal.contextmanager.zzkq;
import com.google.android.gms.internal.contextmanager.zzkz;
import java.util.Arrays;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="TypeFilterImplCreator")
public final class zzt
extends BeaconState.TypeFilter {
    public static final Parcelable.Creator<zzt> CREATOR = new zzax();
    @SafeParcelable.Field(id=2, getter="getTypeFilterAsBytes", type="byte[]")
    private final zzdm.zza zzw;

    @SafeParcelable.Constructor
    zzt(@SafeParcelable.Param(id=2) byte[] byArray) {
        zzdm.zza zza2 = null;
        try {
            zza2 = zzdm.zza.zza(byArray, zzkd.zzcv());
        }
        catch (zzkz zzkz2) {
            zzk.zza("BeaconStateImpl", "Could not deserialize BeaconFence.BeaconTypeFilter");
        }
        this.zzw = zza2;
    }

    public zzt(String string, String string2) {
        this.zzw = (zzdm.zza)((zzkq)zzdm.zza.zzaf().zzb(Preconditions.checkNotEmpty((String)string)).zzc(Preconditions.checkNotEmpty((String)string2)).zzds());
    }

    public zzt(String string, String string2, byte[] byArray) {
        this.zzw = (zzdm.zza)((zzkq)zzdm.zza.zzaf().zzb(Preconditions.checkNotEmpty((String)string)).zzc(Preconditions.checkNotEmpty((String)string2)).zza(zzjk.zza((byte[])Preconditions.checkNotNull((Object)byArray))).zzds());
    }

    private final String getNamespace() {
        if (this.zzw == null) {
            return null;
        }
        return this.zzw.getNamespace();
    }

    private final String getType() {
        if (this.zzw == null) {
            return null;
        }
        return this.zzw.getType();
    }

    private final byte[] getContent() {
        if (this.zzw == null || this.zzw.zzae().size() == 0) {
            return null;
        }
        return this.zzw.zzae().toByteArray();
    }

    public final zzdm.zza zzf() {
        return this.zzw;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getNamespace(), this.getType(), this.getContent() == null ? 0 : Arrays.hashCode(this.getContent())});
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzt)) {
            return false;
        }
        zzt zzt2 = (zzt)((Object)object);
        return TextUtils.equals((CharSequence)this.getNamespace(), (CharSequence)zzt2.getNamespace()) && TextUtils.equals((CharSequence)this.getType(), (CharSequence)zzt2.getType()) && Arrays.equals(this.getContent(), zzt2.getContent());
    }

    public final String toString() {
        String string = this.getNamespace();
        String string2 = this.getType();
        String string3 = this.getContent() == null ? "null" : new String(this.getContent());
        return new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("(").append(string).append(",").append(string2).append(",").append(string3).append(")").toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzt zzt2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeByteArray((Parcel)parcel2, (int)2, (byte[])zzt2.zzw.toByteArray(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }
}

