/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.awareness;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.awareness.Awareness;
import com.google.android.gms.awareness.AwarenessOptions;
import com.google.android.gms.awareness.fence.FenceQueryRequest;
import com.google.android.gms.awareness.fence.FenceQueryResponse;
import com.google.android.gms.awareness.fence.FenceUpdateRequest;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.Response;
import com.google.android.gms.common.api.internal.ApiExceptionMapper;
import com.google.android.gms.common.api.internal.StatusExceptionMapper;
import com.google.android.gms.common.internal.PendingResultUtil;
import com.google.android.gms.tasks.Task;

public class FenceClient
extends GoogleApi<AwarenessOptions> {
    @VisibleForTesting(otherwise=3)
    public FenceClient(@NonNull Activity activity, AwarenessOptions awarenessOptions) {
        super(activity, Awareness.API, (Api.ApiOptions)awarenessOptions, (StatusExceptionMapper)new ApiExceptionMapper());
        awarenessOptions.zza(this.getContextAttributionTag());
    }

    @VisibleForTesting(otherwise=3)
    public FenceClient(@NonNull Context context, AwarenessOptions awarenessOptions) {
        super(context, Awareness.API, (Api.ApiOptions)awarenessOptions, (StatusExceptionMapper)new ApiExceptionMapper());
        awarenessOptions.zza(this.getContextAttributionTag());
    }

    public Task<Void> updateFences(@NonNull FenceUpdateRequest fenceUpdateRequest) {
        return PendingResultUtil.toVoidTask(Awareness.FenceApi.updateFences(this.asGoogleApiClient(), fenceUpdateRequest));
    }

    public Task<FenceQueryResponse> queryFences(@NonNull FenceQueryRequest fenceQueryRequest) {
        return PendingResultUtil.toResponseTask(Awareness.FenceApi.queryFences(this.asGoogleApiClient(), fenceQueryRequest), (Response)new FenceQueryResponse());
    }
}

