/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.contextmanager;

import com.google.android.gms.internal.contextmanager.zzja;
import com.google.android.gms.internal.contextmanager.zzkp;
import com.google.android.gms.internal.contextmanager.zzkv;
import com.google.android.gms.internal.contextmanager.zzmk;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzjx
extends zzja<Double>
implements zzkv<Double>,
zzmk,
RandomAccess {
    private static final zzjx zzaad = new zzjx(new double[0], 0);
    private double[] zzaae;
    private int size;

    zzjx() {
        this(new double[10], 0);
    }

    private zzjx(double[] dArray, int n) {
        this.zzaae = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzck();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzaae, n2, this.zzaae, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzjx)) {
            return super.equals(object);
        }
        zzjx zzjx2 = (zzjx)object;
        if (this.size != zzjx2.size) {
            return false;
        }
        double[] dArray = zzjx2.zzaae;
        for (int i = 0; i < this.size; ++i) {
            if (Double.doubleToLongBits(this.zzaae[i]) == Double.doubleToLongBits(dArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzaae[i]);
            n = n * 31 + zzkp.zzz(l);
        }
        return n;
    }

    @Override
    public final int indexOf(Object object) {
        if (!(object instanceof Double)) {
            return -1;
        }
        double d = (Double)object;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzaae[i] != d) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzg(double d) {
        this.zzck();
        if (this.size == this.zzaae.length) {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzaae, 0, dArray, 0, this.size);
            this.zzaae = dArray;
        }
        this.zzaae[this.size++] = d;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzck();
        zzkp.checkNotNull(collection);
        if (!(collection instanceof zzjx)) {
            return super.addAll(collection);
        }
        zzjx zzjx2 = (zzjx)collection;
        if (zzjx2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzjx2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzjx2.size;
        if (n > this.zzaae.length) {
            this.zzaae = Arrays.copyOf(this.zzaae, n);
        }
        System.arraycopy(zzjx2.zzaae, 0, this.zzaae, this.size, zzjx2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzck();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzaae[i])) continue;
            System.arraycopy(this.zzaae, i + 1, this.zzaae, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzaw(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzax(n));
        }
    }

    private final String zzax(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        double d = (Double)object;
        zzjx zzjx2 = this;
        zzjx2.zzck();
        zzjx2.zzaw(n);
        double d2 = zzjx2.zzaae[n];
        zzjx2.zzaae[n] = d;
        return d2;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzjx zzjx2 = this;
        zzjx2.zzck();
        zzjx2.zzaw(n);
        double d = zzjx2.zzaae[n];
        if (n < zzjx2.size - 1) {
            System.arraycopy(zzjx2.zzaae, n + 1, zzjx2.zzaae, n, zzjx2.size - n - 1);
        }
        --zzjx2.size;
        ++zzjx2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        double d = (Double)object;
        zzjx zzjx2 = this;
        zzjx2.zzck();
        if (n < 0 || n > zzjx2.size) {
            throw new IndexOutOfBoundsException(zzjx2.zzax(n));
        }
        if (zzjx2.size < zzjx2.zzaae.length) {
            System.arraycopy(zzjx2.zzaae, n, zzjx2.zzaae, n + 1, zzjx2.size - n);
        } else {
            double[] dArray = new double[zzjx2.size * 3 / 2 + 1];
            System.arraycopy(zzjx2.zzaae, 0, dArray, 0, n);
            System.arraycopy(zzjx2.zzaae, n, dArray, n + 1, zzjx2.size - n);
            zzjx2.zzaae = dArray;
        }
        zzjx2.zzaae[n] = d;
        ++zzjx2.size;
        ++zzjx2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        this.zzg((Double)object);
        return true;
    }

    @Override
    public final /* synthetic */ zzkv zzay(int n) {
        int n2 = n;
        zzjx zzjx2 = this;
        if (n2 < zzjx2.size) {
            throw new IllegalArgumentException();
        }
        return new zzjx(Arrays.copyOf(zzjx2.zzaae, n2), zzjx2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzjx zzjx2 = this;
        zzjx2.zzaw(n);
        return zzjx2.zzaae[n];
    }

    static {
        zzaad.zzcj();
    }
}

