/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.contextmanager;

import com.google.android.gms.internal.contextmanager.zzja;
import com.google.android.gms.internal.contextmanager.zzkp;
import com.google.android.gms.internal.contextmanager.zzkt;
import com.google.android.gms.internal.contextmanager.zzkv;
import com.google.android.gms.internal.contextmanager.zzmk;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzkq
extends zzja<Integer>
implements zzkt,
zzmk,
RandomAccess {
    private static final zzkq zzaeq = new zzkq(new int[0], 0);
    private int[] zzaer;
    private int size;

    public static zzkq zzdx() {
        return zzaeq;
    }

    zzkq() {
        this(new int[10], 0);
    }

    private zzkq(int[] nArray, int n) {
        this.zzaer = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzck();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzaer, n2, this.zzaer, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzkq)) {
            return super.equals(object);
        }
        zzkq zzkq2 = (zzkq)object;
        if (this.size != zzkq2.size) {
            return false;
        }
        int[] nArray = zzkq2.zzaer;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzaer[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzaer[i];
        }
        return n;
    }

    @Override
    public final zzkt zzbs(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException();
        }
        return new zzkq(Arrays.copyOf(this.zzaer, n), this.size);
    }

    public final int getInt(int n) {
        this.zzaw(n);
        return this.zzaer[n];
    }

    @Override
    public final int indexOf(Object object) {
        if (!(object instanceof Integer)) {
            return -1;
        }
        int n = (Integer)object;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            if (this.zzaer[i] != n) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final void zzbt(int n) {
        this.zzck();
        if (this.size == this.zzaer.length) {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzaer, 0, nArray, 0, this.size);
            this.zzaer = nArray;
        }
        this.zzaer[this.size++] = n;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzck();
        zzkp.checkNotNull(collection);
        if (!(collection instanceof zzkq)) {
            return super.addAll(collection);
        }
        zzkq zzkq2 = (zzkq)collection;
        if (zzkq2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzkq2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzkq2.size;
        if (n > this.zzaer.length) {
            this.zzaer = Arrays.copyOf(this.zzaer, n);
        }
        System.arraycopy(zzkq2.zzaer, 0, this.zzaer, this.size, zzkq2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzck();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzaer[i])) continue;
            System.arraycopy(this.zzaer, i + 1, this.zzaer, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzaw(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzax(n));
        }
    }

    private final String zzax(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        int n2 = (Integer)object;
        zzkq zzkq2 = this;
        zzkq2.zzck();
        zzkq2.zzaw(n);
        int n3 = zzkq2.zzaer[n];
        zzkq2.zzaer[n] = n2;
        return n3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzkq zzkq2 = this;
        zzkq2.zzck();
        zzkq2.zzaw(n);
        int n2 = zzkq2.zzaer[n];
        if (n < zzkq2.size - 1) {
            System.arraycopy(zzkq2.zzaer, n + 1, zzkq2.zzaer, n, zzkq2.size - n - 1);
        }
        --zzkq2.size;
        ++zzkq2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        int n2 = (Integer)object;
        zzkq zzkq2 = this;
        zzkq2.zzck();
        if (n < 0 || n > zzkq2.size) {
            throw new IndexOutOfBoundsException(zzkq2.zzax(n));
        }
        if (zzkq2.size < zzkq2.zzaer.length) {
            System.arraycopy(zzkq2.zzaer, n, zzkq2.zzaer, n + 1, zzkq2.size - n);
        } else {
            int[] nArray = new int[zzkq2.size * 3 / 2 + 1];
            System.arraycopy(zzkq2.zzaer, 0, nArray, 0, n);
            System.arraycopy(zzkq2.zzaer, n, nArray, n + 1, zzkq2.size - n);
            zzkq2.zzaer = nArray;
        }
        zzkq2.zzaer[n] = n2;
        ++zzkq2.size;
        ++zzkq2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        this.zzbt((Integer)object);
        return true;
    }

    @Override
    public final /* synthetic */ zzkv zzay(int n) {
        return this.zzbs(n);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzaeq.zzcj();
    }
}

