/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.contextmanager;

import com.google.android.gms.internal.contextmanager.zzja;
import com.google.android.gms.internal.contextmanager.zzkp;
import com.google.android.gms.internal.contextmanager.zzkv;
import com.google.android.gms.internal.contextmanager.zzmk;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzlm
extends zzja<Long>
implements zzkv<Long>,
zzmk,
RandomAccess {
    private static final zzlm zzafu = new zzlm(new long[0], 0);
    private long[] zzafv;
    private int size;

    zzlm() {
        this(new long[10], 0);
    }

    private zzlm(long[] lArray, int n) {
        this.zzafv = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzck();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzafv, n2, this.zzafv, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzlm)) {
            return super.equals(object);
        }
        zzlm zzlm2 = (zzlm)object;
        if (this.size != zzlm2.size) {
            return false;
        }
        long[] lArray = zzlm2.zzafv;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzafv[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzkp.zzz(this.zzafv[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzaw(n);
        return this.zzafv[n];
    }

    @Override
    public final int indexOf(Object object) {
        if (!(object instanceof Long)) {
            return -1;
        }
        long l = (Long)object;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzafv[i] != l) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzaa(long l) {
        this.zzck();
        if (this.size == this.zzafv.length) {
            long[] lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzafv, 0, lArray, 0, this.size);
            this.zzafv = lArray;
        }
        this.zzafv[this.size++] = l;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzck();
        zzkp.checkNotNull(collection);
        if (!(collection instanceof zzlm)) {
            return super.addAll(collection);
        }
        zzlm zzlm2 = (zzlm)collection;
        if (zzlm2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzlm2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzlm2.size;
        if (n > this.zzafv.length) {
            this.zzafv = Arrays.copyOf(this.zzafv, n);
        }
        System.arraycopy(zzlm2.zzafv, 0, this.zzafv, this.size, zzlm2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzck();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzafv[i])) continue;
            System.arraycopy(this.zzafv, i + 1, this.zzafv, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzaw(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzax(n));
        }
    }

    private final String zzax(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        long l = (Long)object;
        zzlm zzlm2 = this;
        zzlm2.zzck();
        zzlm2.zzaw(n);
        long l2 = zzlm2.zzafv[n];
        zzlm2.zzafv[n] = l;
        return l2;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzlm zzlm2 = this;
        zzlm2.zzck();
        zzlm2.zzaw(n);
        long l = zzlm2.zzafv[n];
        if (n < zzlm2.size - 1) {
            System.arraycopy(zzlm2.zzafv, n + 1, zzlm2.zzafv, n, zzlm2.size - n - 1);
        }
        --zzlm2.size;
        ++zzlm2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        long l = (Long)object;
        zzlm zzlm2 = this;
        zzlm2.zzck();
        if (n < 0 || n > zzlm2.size) {
            throw new IndexOutOfBoundsException(zzlm2.zzax(n));
        }
        if (zzlm2.size < zzlm2.zzafv.length) {
            System.arraycopy(zzlm2.zzafv, n, zzlm2.zzafv, n + 1, zzlm2.size - n);
        } else {
            long[] lArray = new long[zzlm2.size * 3 / 2 + 1];
            System.arraycopy(zzlm2.zzafv, 0, lArray, 0, n);
            System.arraycopy(zzlm2.zzafv, n, lArray, n + 1, zzlm2.size - n);
            zzlm2.zzafv = lArray;
        }
        zzlm2.zzafv[n] = l;
        ++zzlm2.size;
        ++zzlm2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        this.zzaa((Long)object);
        return true;
    }

    @Override
    public final /* synthetic */ zzkv zzay(int n) {
        int n2 = n;
        zzlm zzlm2 = this;
        if (n2 < zzlm2.size) {
            throw new IllegalArgumentException();
        }
        return new zzlm(Arrays.copyOf(zzlm2.zzafv, n2), zzlm2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzafu.zzcj();
    }
}

