/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.auth.api.signin.internal.zzl;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzm;
import com.google.android.gms.internal.zzaaa;
import com.google.android.gms.internal.zzaac;
import com.google.android.gms.internal.zzaan;
import com.google.android.gms.internal.zzaar;
import com.google.android.gms.internal.zzaau;
import com.google.android.gms.internal.zzaav;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzaba;
import com.google.android.gms.internal.zzabi;
import com.google.android.gms.internal.zzabl;
import com.google.android.gms.internal.zzabp;
import com.google.android.gms.internal.zzabq;
import com.google.android.gms.internal.zzabx;
import com.google.android.gms.internal.zzaxn;
import com.google.android.gms.internal.zzaxo;
import com.google.android.gms.internal.zzzt;
import com.google.android.gms.internal.zzzv;
import com.google.android.gms.internal.zzzx;
import com.google.android.gms.internal.zzzy;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;

public final class zzaal
extends GoogleApiClient
implements zzaau.zza {
    private final Lock zzazn;
    private boolean zzayb;
    private final zzm zzaAj;
    private zzaau zzaAk = null;
    private final int zzaxV;
    private final Context mContext;
    private final Looper zzrx;
    final Queue<zzzv.zza<?, ?>> zzaAl = new LinkedList();
    private volatile boolean zzaAm;
    private long zzaAn = 120000L;
    private long zzaAo = 5000L;
    private final zza zzaAp;
    private final GoogleApiAvailability zzaxX;
    zzaar zzaAq;
    final Map<Api.zzc<?>, Api.zze> zzaAr;
    Set<Scope> zzaAs = new HashSet<Scope>();
    final zzg zzazs;
    final Map<Api<?>, Integer> zzazu;
    final Api.zza<? extends zzaxn, zzaxo> zzaxY;
    private final zzaba zzaAt = new zzaba();
    private final ArrayList<zzzy> zzaAu;
    private Integer zzaAv = null;
    Set<zzabp> zzaAw = null;
    final zzabq zzaAx;
    private final zzm.zza zzaAy = new zzm.zza(){

        @Override
        public boolean isConnected() {
            return zzaal.this.isConnected();
        }

        @Override
        public Bundle zzud() {
            return null;
        }
    };

    public zzaal(Context context, Lock lock, Looper looper, zzg zzg2, GoogleApiAvailability googleApiAvailability, Api.zza<? extends zzaxn, zzaxo> zza2, Map<Api<?>, Integer> map, List<GoogleApiClient.ConnectionCallbacks> list, List<GoogleApiClient.OnConnectionFailedListener> list2, Map<Api.zzc<?>, Api.zze> map2, int n, int n2, ArrayList<zzzy> arrayList, boolean bl) {
        this.mContext = context;
        this.zzazn = lock;
        this.zzayb = bl;
        this.zzaAj = new zzm(looper, this.zzaAy);
        this.zzrx = looper;
        this.zzaAp = new zza(looper);
        this.zzaxX = googleApiAvailability;
        this.zzaxV = n;
        if (this.zzaxV >= 0) {
            this.zzaAv = n2;
        }
        this.zzazu = map;
        this.zzaAr = map2;
        this.zzaAu = arrayList;
        this.zzaAx = new zzabq(this.zzaAr);
        for (GoogleApiClient.ConnectionCallbacks object : list) {
            this.zzaAj.registerConnectionCallbacks(object);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : list2) {
            this.zzaAj.registerConnectionFailedListener(onConnectionFailedListener);
        }
        this.zzazs = zzg2;
        this.zzaxY = zza2;
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzzv.zza<R, A>> T zza(@NonNull T t) {
        zzac.zzb((t.zzuH() != null ? 1 : 0) != 0, (Object)"This task can not be enqueued (it's probably a Batch or malformed)");
        String string2 = t.getApi() != null ? t.getApi().getName() : "the API";
        zzac.zzb((boolean)this.zzaAr.containsKey(t.zzuH()), (Object)new StringBuilder(65 + String.valueOf(string2).length()).append("GoogleApiClient is not configured to use ").append(string2).append(" required for this call.").toString());
        this.zzazn.lock();
        try {
            if (this.zzaAk == null) {
                this.zzaAl.add(t);
                string2 = t;
                return (T)string2;
            }
            string2 = this.zzaAk.zza(t);
            return (T)string2;
        }
        finally {
            this.zzazn.unlock();
        }
    }

    @Override
    public <A extends Api.zzb, T extends zzzv.zza<? extends Result, A>> T zzb(@NonNull T t) {
        zzac.zzb((t.zzuH() != null ? 1 : 0) != 0, (Object)"This task can not be executed (it's probably a Batch or malformed)");
        Object object = t.getApi() != null ? t.getApi().getName() : "the API";
        zzac.zzb((boolean)this.zzaAr.containsKey(t.zzuH()), (Object)new StringBuilder(65 + String.valueOf(object).length()).append("GoogleApiClient is not configured to use ").append((String)object).append(" required for this call.").toString());
        this.zzazn.lock();
        try {
            if (this.zzaAk == null) {
                throw new IllegalStateException("GoogleApiClient is not connected yet.");
            }
            if (this.isResuming()) {
                this.zzaAl.add(t);
                while (!this.zzaAl.isEmpty()) {
                    object = this.zzaAl.remove();
                    this.zzaAx.zzb((zzzx<? extends Result>)object);
                    ((zzzv.zza)object).zzA(Status.zzayj);
                }
                object = t;
                return (T)object;
            }
            object = this.zzaAk.zzb(t);
            return (T)object;
        }
        finally {
            this.zzazn.unlock();
        }
    }

    @Override
    public <L> zzaaz<L> zzr(@NonNull L l) {
        this.zzazn.lock();
        try {
            zzaaz<L> zzaaz2 = this.zzaAt.zzb(l, this.zzrx);
            return zzaaz2;
        }
        finally {
            this.zzazn.unlock();
        }
    }

    @Override
    @NonNull
    public <C extends Api.zze> C zza(@NonNull Api.zzc<C> zzc2) {
        Api.zze zze2 = this.zzaAr.get(zzc2);
        zzac.zzb((Object)zze2, (Object)"Appropriate Api was not requested.");
        return (C)zze2;
    }

    <C extends Api.zze> C zzb(Api.zzc<?> zzc2) {
        Api.zze zze2 = this.zzaAr.get(zzc2);
        zzac.zzb((Object)zze2, (Object)"Appropriate Api was not requested.");
        return (C)zze2;
    }

    @Override
    public boolean zza(@NonNull Api<?> api) {
        return this.zzaAr.containsKey(api.zzuH());
    }

    @Override
    public boolean hasConnectedApi(@NonNull Api<?> api) {
        if (!this.isConnected()) {
            return false;
        }
        Api.zze zze2 = this.zzaAr.get(api.zzuH());
        return zze2 != null && zze2.isConnected();
    }

    @Override
    @NonNull
    public ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        this.zzazn.lock();
        try {
            if (!this.isConnected() && !this.isResuming()) {
                throw new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
            }
            if (this.zzaAr.containsKey(api.zzuH())) {
                ConnectionResult connectionResult = this.zzaAk.getConnectionResult(api);
                if (connectionResult == null) {
                    if (this.isResuming()) {
                        ConnectionResult connectionResult2 = ConnectionResult.zzawX;
                        return connectionResult2;
                    }
                    Log.w((String)"GoogleApiClientImpl", (String)this.zzvN());
                    Log.wtf((String)"GoogleApiClientImpl", (String)String.valueOf(api.getName()).concat(" requested in getConnectionResult is not connected but is not present in the failed  connections map"), (Throwable)new Exception());
                    ConnectionResult connectionResult3 = new ConnectionResult(8, null);
                    return connectionResult3;
                }
                ConnectionResult connectionResult4 = connectionResult;
                return connectionResult4;
            }
            throw new IllegalArgumentException(String.valueOf(api.getName()).concat(" was never registered with GoogleApiClient"));
        }
        finally {
            this.zzazn.unlock();
        }
    }

    @Override
    public void connect() {
        this.zzazn.lock();
        try {
            if (this.zzaxV >= 0) {
                zzac.zza((this.zzaAv != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzaAv == null) {
                this.zzaAv = zzaal.zza(this.zzaAr.values(), false);
            } else if (this.zzaAv == 2) {
                throw new IllegalStateException("Cannot call connect() when SignInMode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.connect(this.zzaAv);
        }
        finally {
            this.zzazn.unlock();
        }
    }

    @Override
    public void connect(int n) {
        this.zzazn.lock();
        try {
            zzac.zzb((n == 3 || n == 1 || n == 2 ? 1 : 0) != 0, (Object)new StringBuilder(33).append("Illegal sign-in mode: ").append(n).toString());
            this.zzcx(n);
            this.zzvI();
        }
        finally {
            this.zzazn.unlock();
        }
    }

    @Override
    public ConnectionResult blockingConnect() {
        zzac.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        this.zzazn.lock();
        try {
            if (this.zzaxV >= 0) {
                zzac.zza((this.zzaAv != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzaAv == null) {
                this.zzaAv = zzaal.zza(this.zzaAr.values(), false);
            } else if (this.zzaAv == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzcx(this.zzaAv);
            this.zzaAj.zzxr();
            ConnectionResult connectionResult = this.zzaAk.blockingConnect();
            return connectionResult;
        }
        finally {
            this.zzazn.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        zzac.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        zzac.zzb((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        this.zzazn.lock();
        try {
            if (this.zzaAv == null) {
                this.zzaAv = zzaal.zza(this.zzaAr.values(), false);
            } else if (this.zzaAv == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzcx(this.zzaAv);
            this.zzaAj.zzxr();
            ConnectionResult connectionResult = this.zzaAk.blockingConnect(l, timeUnit);
            return connectionResult;
        }
        finally {
            this.zzazn.unlock();
        }
    }

    @Override
    public void disconnect() {
        this.zzazn.lock();
        try {
            this.zzaAx.release();
            if (this.zzaAk != null) {
                this.zzaAk.disconnect();
            }
            this.zzaAt.release();
            for (zzzv.zza zza2 : this.zzaAl) {
                zza2.zza(null);
                zza2.cancel();
            }
            this.zzaAl.clear();
            if (this.zzaAk == null) {
                return;
            }
            this.zzvL();
            this.zzaAj.zzxq();
        }
        finally {
            this.zzazn.unlock();
        }
    }

    @Override
    public void reconnect() {
        this.disconnect();
        this.connect();
    }

    @Override
    public PendingResult<Status> clearDefaultAccountAndReconnect() {
        zzac.zza((boolean)this.isConnected(), (Object)"GoogleApiClient is not connected yet.");
        zzac.zza((this.zzaAv != 2 ? 1 : 0) != 0, (Object)"Cannot use clearDefaultAccountAndReconnect with GOOGLE_SIGN_IN_API");
        final zzabl zzabl2 = new zzabl(this);
        if (this.zzaAr.containsKey(zzabx.zzahc)) {
            this.zza(this, zzabl2, false);
        } else {
            final AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = new GoogleApiClient.ConnectionCallbacks(){

                @Override
                public void onConnected(Bundle bundle) {
                    zzaal.this.zza((GoogleApiClient)atomicReference.get(), zzabl2, true);
                }

                @Override
                public void onConnectionSuspended(int n) {
                }
            };
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = new GoogleApiClient.OnConnectionFailedListener(this){

                @Override
                public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
                    zzabl2.zzb(new Status(8));
                }
            };
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(this.mContext).addApi(zzabx.API).addConnectionCallbacks(connectionCallbacks).addOnConnectionFailedListener(onConnectionFailedListener).setHandler(this.zzaAp).build();
            atomicReference.set(googleApiClient);
            googleApiClient.connect();
        }
        return zzabl2;
    }

    private void zza(final GoogleApiClient googleApiClient, final zzabl zzabl2, final boolean bl) {
        zzabx.zzaFp.zzg(googleApiClient).setResultCallback(new ResultCallback<Status>(){

            public void zzp(@NonNull Status status) {
                zzl.zzaa(zzaal.this.mContext).zzre();
                if (status.isSuccess() && zzaal.this.isConnected()) {
                    zzaal.this.reconnect();
                }
                zzabl2.zzb(status);
                if (bl) {
                    googleApiClient.disconnect();
                }
            }

            public /* synthetic */ void onResult(@NonNull Result result) {
                this.zzp((Status)result);
            }
        });
    }

    @Override
    public void stopAutoManage(@NonNull FragmentActivity fragmentActivity) {
        this.zzb(new zzaav((Activity)fragmentActivity));
    }

    private void zzb(@NonNull zzaav zzaav2) {
        if (this.zzaxV < 0) {
            throw new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
        }
        zzzt.zza(zzaav2).zzcu(this.zzaxV);
    }

    @Override
    public boolean isConnected() {
        return this.zzaAk != null && this.zzaAk.isConnected();
    }

    @Override
    public boolean isConnecting() {
        return this.zzaAk != null && this.zzaAk.isConnecting();
    }

    boolean isResuming() {
        return this.zzaAm;
    }

    private void zzcx(int n) {
        if (this.zzaAv == null) {
            this.zzaAv = n;
        } else if (this.zzaAv != n) {
            String string2 = String.valueOf(zzaal.zzcy(n));
            String string3 = String.valueOf(zzaal.zzcy(this.zzaAv));
            throw new IllegalStateException(new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Cannot use sign-in mode: ").append(string2).append(". Mode was already set to ").append(string3).toString());
        }
        if (this.zzaAk != null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Api.zze zze2 : this.zzaAr.values()) {
            if (zze2.zzqD()) {
                bl = true;
            }
            if (!zze2.zzqS()) continue;
            bl2 = true;
        }
        switch (this.zzaAv) {
            case 3: {
                break;
            }
            case 1: {
                if (!bl) {
                    throw new IllegalStateException("SIGN_IN_MODE_REQUIRED cannot be used on a GoogleApiClient that does not contain any authenticated APIs. Use connect() instead.");
                }
                if (!bl2) break;
                throw new IllegalStateException("Cannot use SIGN_IN_MODE_REQUIRED with GOOGLE_SIGN_IN_API. Use connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            case 2: {
                if (!bl) break;
                this.zzaAk = zzaaa.zza(this.mContext, this, this.zzazn, this.zzrx, this.zzaxX, this.zzaAr, this.zzazs, this.zzazu, this.zzaxY, this.zzaAu);
                return;
            }
        }
        this.zzaAk = this.zzayb && !bl2 ? new zzaac(this.mContext, this.zzazn, this.zzrx, this.zzaxX, this.zzaAr, this.zzazs, this.zzazu, this.zzaxY, this.zzaAu, this) : new zzaan(this.mContext, this, this.zzazn, this.zzrx, this.zzaxX, this.zzaAr, this.zzazs, this.zzazu, this.zzaxY, this.zzaAu, this);
    }

    private void zzvI() {
        this.zzaAj.zzxr();
        this.zzaAk.connect();
    }

    private void resume() {
        this.zzazn.lock();
        try {
            if (this.isResuming()) {
                this.zzvI();
            }
        }
        finally {
            this.zzazn.unlock();
        }
    }

    private void zzvJ() {
        this.zzazn.lock();
        try {
            boolean bl = this.zzvL();
            if (bl) {
                this.zzvI();
            }
        }
        finally {
            this.zzazn.unlock();
        }
    }

    void zzvK() {
        if (this.isResuming()) {
            return;
        }
        this.zzaAm = true;
        if (this.zzaAq == null) {
            this.zzaAq = this.zzaxX.zza(this.mContext.getApplicationContext(), new zzb(this));
        }
        this.zzaAp.sendMessageDelayed(this.zzaAp.obtainMessage(1), this.zzaAn);
        this.zzaAp.sendMessageDelayed(this.zzaAp.obtainMessage(2), this.zzaAo);
    }

    boolean zzvL() {
        if (!this.isResuming()) {
            return false;
        }
        this.zzaAm = false;
        this.zzaAp.removeMessages(2);
        this.zzaAp.removeMessages(1);
        if (this.zzaAq != null) {
            this.zzaAq.unregister();
            this.zzaAq = null;
        }
        return true;
    }

    @Override
    public void registerConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zzaAj.registerConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public boolean isConnectionCallbacksRegistered(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        return this.zzaAj.isConnectionCallbacksRegistered(connectionCallbacks);
    }

    @Override
    public void unregisterConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zzaAj.unregisterConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public void registerConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zzaAj.registerConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public boolean isConnectionFailedListenerRegistered(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return this.zzaAj.isConnectionFailedListenerRegistered(onConnectionFailedListener);
    }

    @Override
    public void unregisterConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zzaAj.unregisterConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public void zzo(Bundle bundle) {
        while (!this.zzaAl.isEmpty()) {
            this.zzb(this.zzaAl.remove());
        }
        this.zzaAj.zzq(bundle);
    }

    @Override
    public void zzc(ConnectionResult connectionResult) {
        if (!this.zzaxX.zzd(this.mContext, connectionResult.getErrorCode())) {
            this.zzvL();
        }
        if (!this.isResuming()) {
            this.zzaAj.zzo(connectionResult);
            this.zzaAj.zzxq();
        }
    }

    @Override
    public void zzc(int n, boolean bl) {
        if (n == 1 && !bl) {
            this.zzvK();
        }
        this.zzaAx.zzww();
        this.zzaAj.zzcP(n);
        this.zzaAj.zzxq();
        if (n == 2) {
            this.zzvI();
        }
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @Override
    public Looper getLooper() {
        return this.zzrx;
    }

    @Override
    public boolean zza(zzabi zzabi2) {
        return this.zzaAk != null && this.zzaAk.zza(zzabi2);
    }

    @Override
    public void zzuN() {
        if (this.zzaAk != null) {
            this.zzaAk.zzuN();
        }
    }

    @Override
    public void zza(zzabp zzabp2) {
        this.zzazn.lock();
        try {
            if (this.zzaAw == null) {
                this.zzaAw = new HashSet<zzabp>();
            }
            this.zzaAw.add(zzabp2);
        }
        finally {
            this.zzazn.unlock();
        }
    }

    @Override
    public void zzb(zzabp zzabp2) {
        this.zzazn.lock();
        try {
            if (this.zzaAw == null) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Attempted to remove pending transform when no transforms are registered.", (Throwable)new Exception());
            } else if (!this.zzaAw.remove(zzabp2)) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Failed to remove pending transform - this may lead to memory leaks!", (Throwable)new Exception());
            } else if (!this.zzvM()) {
                this.zzaAk.zzvj();
            }
        }
        finally {
            this.zzazn.unlock();
        }
    }

    boolean zzvM() {
        this.zzazn.lock();
        try {
            if (this.zzaAw == null) {
                return false;
            }
            boolean bl = !this.zzaAw.isEmpty();
            return bl;
        }
        finally {
            this.zzazn.unlock();
        }
    }

    String zzvN() {
        StringWriter stringWriter = new StringWriter();
        this.dump("", null, new PrintWriter(stringWriter), null);
        return stringWriter.toString();
    }

    @Override
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("mContext=").println(this.mContext);
        printWriter.append(string2).append("mResuming=").print(this.zzaAm);
        printWriter.append(" mWorkQueue.size()=").print(this.zzaAl.size());
        this.zzaAx.dump(printWriter);
        if (this.zzaAk != null) {
            this.zzaAk.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    public int getSessionId() {
        return System.identityHashCode(this);
    }

    public static int zza(Iterable<Api.zze> iterable, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (Api.zze zze2 : iterable) {
            if (zze2.zzqD()) {
                bl2 = true;
            }
            if (!zze2.zzqS()) continue;
            bl3 = true;
        }
        if (bl2) {
            if (bl3 && bl) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    static String zzcy(int n) {
        switch (n) {
            case 3: {
                return "SIGN_IN_MODE_NONE";
            }
            case 1: {
                return "SIGN_IN_MODE_REQUIRED";
            }
            case 2: {
                return "SIGN_IN_MODE_OPTIONAL";
            }
        }
        return "UNKNOWN";
    }

    final class zza
    extends Handler {
        zza(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    zzaal.this.zzvJ();
                    break;
                }
                case 2: {
                    zzaal.this.resume();
                    break;
                }
                default: {
                    int n = message.what;
                    Log.w((String)"GoogleApiClientImpl", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                }
            }
        }
    }

    static class zzb
    extends zzaar.zza {
        private WeakReference<zzaal> zzaAD;

        zzb(zzaal zzaal2) {
            this.zzaAD = new WeakReference<zzaal>(zzaal2);
        }

        @Override
        public void zzvb() {
            zzaal zzaal2 = (zzaal)this.zzaAD.get();
            if (zzaal2 == null) {
                return;
            }
            zzaal2.resume();
        }
    }
}

