/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.common.util.zzs;

public final class zzabt
extends Drawable
implements Drawable.Callback {
    private int zzaDe = 0;
    private long zzaed;
    private int mFrom;
    private int zzaDf;
    private int zzaDg = 255;
    private int zzaDh;
    private int zzaDi = 0;
    private boolean zzaCZ = true;
    private boolean zzaDj;
    private zzb zzaDk;
    private Drawable zzaDl;
    private Drawable zzaDm;
    private boolean zzaDn;
    private boolean zzaDo;
    private boolean zzaDp;
    private int zzaDq;

    public zzabt(Drawable drawable2, Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = zza.zzaDr;
        }
        this.zzaDl = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.zzaDk.zzaDt |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = zza.zzaDr;
        }
        this.zzaDm = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.zzaDk.zzaDt |= drawable3.getChangingConfigurations();
    }

    zzabt(zzb zzb2) {
        this.zzaDk = new zzb(zzb2);
    }

    @TargetApi(value=11)
    public void invalidateDrawable(Drawable drawable2) {
        Drawable.Callback callback;
        if (zzs.zzyx() && (callback = this.getCallback()) != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    @TargetApi(value=11)
    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        Drawable.Callback callback;
        if (zzs.zzyx() && (callback = this.getCallback()) != null) {
            callback.scheduleDrawable((Drawable)this, runnable, l);
        }
    }

    @TargetApi(value=11)
    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        Drawable.Callback callback;
        if (zzs.zzyx() && (callback = this.getCallback()) != null) {
            callback.unscheduleDrawable((Drawable)this, runnable);
        }
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.zzaDk.mChangingConfigurations | this.zzaDk.zzaDt;
    }

    public void setAlpha(int n) {
        if (this.zzaDi == this.zzaDg) {
            this.zzaDi = n;
        }
        this.zzaDg = n;
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.zzaDl.setColorFilter(colorFilter);
        this.zzaDm.setColorFilter(colorFilter);
    }

    public int getIntrinsicWidth() {
        return Math.max(this.zzaDl.getIntrinsicWidth(), this.zzaDm.getIntrinsicWidth());
    }

    public int getIntrinsicHeight() {
        return Math.max(this.zzaDl.getIntrinsicHeight(), this.zzaDm.getIntrinsicHeight());
    }

    protected void onBoundsChange(Rect rect) {
        this.zzaDl.setBounds(rect);
        this.zzaDm.setBounds(rect);
    }

    public Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.zzaDk.mChangingConfigurations = this.getChangingConfigurations();
            return this.zzaDk;
        }
        return null;
    }

    public int getOpacity() {
        if (!this.zzaDp) {
            this.zzaDq = Drawable.resolveOpacity((int)this.zzaDl.getOpacity(), (int)this.zzaDm.getOpacity());
            this.zzaDp = true;
        }
        return this.zzaDq;
    }

    public boolean canConstantState() {
        if (!this.zzaDn) {
            this.zzaDo = this.zzaDl.getConstantState() != null && this.zzaDm.getConstantState() != null;
            this.zzaDn = true;
        }
        return this.zzaDo;
    }

    public Drawable mutate() {
        if (!this.zzaDj && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.zzaDl.mutate();
            this.zzaDm.mutate();
            this.zzaDj = true;
        }
        return this;
    }

    public Drawable zzwM() {
        return this.zzaDm;
    }

    public void startTransition(int n) {
        this.mFrom = 0;
        this.zzaDf = this.zzaDg;
        this.zzaDi = 0;
        this.zzaDh = n;
        this.zzaDe = 1;
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.zzaDe) {
            case 1: {
                this.zzaed = SystemClock.uptimeMillis();
                bl = false;
                this.zzaDe = 2;
                break;
            }
            case 2: {
                if (this.zzaed < 0L) break;
                float f = (float)(SystemClock.uptimeMillis() - this.zzaed) / (float)this.zzaDh;
                boolean bl2 = bl = f >= 1.0f;
                if (bl) {
                    this.zzaDe = 0;
                }
                f = Math.min(f, 1.0f);
                this.zzaDi = (int)(0.0f + (float)(this.zzaDf - 0) * f);
            }
        }
        int n = this.zzaDi;
        boolean bl3 = this.zzaCZ;
        Drawable drawable2 = this.zzaDl;
        Drawable drawable3 = this.zzaDm;
        if (bl) {
            if (!bl3 || n == 0) {
                drawable2.draw(canvas);
            }
            if (n == this.zzaDg) {
                drawable3.setAlpha(this.zzaDg);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl3) {
            drawable2.setAlpha(this.zzaDg - n);
        }
        drawable2.draw(canvas);
        if (bl3) {
            drawable2.setAlpha(this.zzaDg);
        }
        if (n > 0) {
            drawable3.setAlpha(n);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.zzaDg);
        }
        this.invalidateSelf();
    }

    private static final class com.google.android.gms.internal.zzabt$zza
    extends Drawable {
        private static final com.google.android.gms.internal.zzabt$zza zzaDr = new com.google.android.gms.internal.zzabt$zza();
        private static final zza zzaDs = new zza();

        private com.google.android.gms.internal.zzabt$zza() {
        }

        public void draw(Canvas canvas) {
        }

        public void setAlpha(int n) {
        }

        public void setColorFilter(ColorFilter colorFilter) {
        }

        public int getOpacity() {
            return -2;
        }

        public Drawable.ConstantState getConstantState() {
            return zzaDs;
        }

        private static final class zza
        extends Drawable.ConstantState {
            private zza() {
            }

            public Drawable newDrawable() {
                return zzaDr;
            }

            public int getChangingConfigurations() {
                return 0;
            }
        }
    }

    static final class zzb
    extends Drawable.ConstantState {
        int mChangingConfigurations;
        int zzaDt;

        zzb(zzb zzb2) {
            if (zzb2 != null) {
                this.mChangingConfigurations = zzb2.mChangingConfigurations;
                this.zzaDt = zzb2.zzaDt;
            }
        }

        public Drawable newDrawable() {
            return new zzabt(this);
        }

        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }
    }
}

