/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.images.zzb;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class WebImage
extends zza {
    public static final Parcelable.Creator<WebImage> CREATOR = new zzb();
    final int zzaiI;
    private final Uri zzata;
    private final int zzrC;
    private final int zzrD;

    WebImage(int n, Uri uri, int n2, int n3) {
        this.zzaiI = n;
        this.zzata = uri;
        this.zzrC = n2;
        this.zzrD = n3;
    }

    public WebImage(Uri uri, int n, int n2) throws IllegalArgumentException {
        this(1, uri, n, n2);
        if (uri == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("width and height must not be negative");
        }
    }

    public WebImage(Uri uri) throws IllegalArgumentException {
        this(uri, 0, 0);
    }

    public WebImage(JSONObject jSONObject) throws IllegalArgumentException {
        this(WebImage.zzs(jSONObject), jSONObject.optInt("width", 0), jSONObject.optInt("height", 0));
    }

    private static Uri zzs(JSONObject jSONObject) {
        Uri uri = null;
        if (jSONObject.has("url")) {
            try {
                uri = Uri.parse((String)jSONObject.getString("url"));
            }
            catch (JSONException jSONException) {}
        }
        return uri;
    }

    public Uri getUrl() {
        return this.zzata;
    }

    public int getWidth() {
        return this.zzrC;
    }

    public int getHeight() {
        return this.zzrD;
    }

    public String toString() {
        return String.format(Locale.US, "Image %dx%d %s", this.zzrC, this.zzrD, this.zzata.toString());
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("url", (Object)this.zzata.toString());
            jSONObject.put("width", this.zzrC);
            jSONObject.put("height", this.zzrD);
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof WebImage)) {
            return false;
        }
        WebImage webImage = (WebImage)((Object)object);
        return zzaa.equal((Object)this.zzata, (Object)webImage.zzata) && this.zzrC == webImage.zzrC && this.zzrD == webImage.zzrD;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzata, this.zzrC, this.zzrD});
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }
}

