/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamic;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zze;
import java.util.LinkedList;

public abstract class zza<T extends LifecycleDelegate> {
    private T zzaRA;
    private Bundle zzaRB;
    private LinkedList<zza> zzaRC;
    private final zze<T> zzaRD = new zze<T>(){

        public void zza(T t) {
            zza.this.zzaRA = t;
            for (zza zza2 : zza.this.zzaRC) {
                zza2.zzb(zza.this.zzaRA);
            }
            zza.this.zzaRC.clear();
            zza.this.zzaRB = null;
        }
    };

    public T zzBN() {
        return this.zzaRA;
    }

    private void zzgt(int n) {
        while (!this.zzaRC.isEmpty() && this.zzaRC.getLast().getState() >= n) {
            this.zzaRC.removeLast();
        }
    }

    private void zza(Bundle bundle, zza zza2) {
        if (this.zzaRA != null) {
            zza2.zzb((LifecycleDelegate)this.zzaRA);
            return;
        }
        if (this.zzaRC == null) {
            this.zzaRC = new LinkedList();
        }
        this.zzaRC.add(zza2);
        if (bundle != null) {
            if (this.zzaRB == null) {
                this.zzaRB = (Bundle)bundle.clone();
            } else {
                this.zzaRB.putAll(bundle);
            }
        }
        this.zza(this.zzaRD);
    }

    protected abstract void zza(zze<T> var1);

    public void onInflate(final Activity activity, final Bundle bundle, final Bundle bundle2) {
        this.zza(bundle2, new zza(){

            @Override
            public int getState() {
                return 0;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzaRA.onInflate(activity, bundle, bundle2);
            }
        });
    }

    public void onCreate(final Bundle bundle) {
        this.zza(bundle, new zza(){

            @Override
            public int getState() {
                return 1;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzaRA.onCreate(bundle);
            }
        });
    }

    public View onCreateView(final LayoutInflater layoutInflater, final ViewGroup viewGroup, final Bundle bundle) {
        final FrameLayout frameLayout = new FrameLayout(layoutInflater.getContext());
        this.zza(bundle, new zza(){

            @Override
            public int getState() {
                return 2;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                frameLayout.removeAllViews();
                frameLayout.addView(zza.this.zzaRA.onCreateView(layoutInflater, viewGroup, bundle));
            }
        });
        if (this.zzaRA == null) {
            this.zza(frameLayout);
        }
        return frameLayout;
    }

    protected void zza(FrameLayout frameLayout) {
        zza.zzb(frameLayout);
    }

    public static void zzb(FrameLayout frameLayout) {
        zza.zza(frameLayout, GoogleApiAvailability.getInstance());
    }

    @VisibleForTesting
    static void zza(FrameLayout frameLayout, GoogleApiAvailability googleApiAvailability) {
        final Context context = frameLayout.getContext();
        int n = googleApiAvailability.isGooglePlayServicesAvailable(context);
        String string2 = zzh.zzi(context, n);
        String string3 = zzh.zzk(context, n);
        LinearLayout linearLayout = new LinearLayout(frameLayout.getContext());
        linearLayout.setOrientation(1);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        frameLayout.addView((View)linearLayout);
        TextView textView = new TextView(frameLayout.getContext());
        textView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        textView.setText((CharSequence)string2);
        linearLayout.addView((View)textView);
        final Intent intent = googleApiAvailability.zzb(context, n, null);
        if (intent != null) {
            Button button = new Button(context);
            button.setId(16908313);
            button.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
            button.setText((CharSequence)string3);
            linearLayout.addView((View)button);
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    try {
                        context.startActivity(intent);
                    }
                    catch (ActivityNotFoundException activityNotFoundException) {
                        Log.e((String)"DeferredLifecycleHelper", (String)"Failed to start resolution intent", (Throwable)activityNotFoundException);
                    }
                }
            });
        }
    }

    public void onStart() {
        this.zza(null, new zza(){

            @Override
            public int getState() {
                return 4;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzaRA.onStart();
            }
        });
    }

    public void onResume() {
        this.zza(null, new zza(){

            @Override
            public int getState() {
                return 5;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzaRA.onResume();
            }
        });
    }

    public void onPause() {
        if (this.zzaRA != null) {
            this.zzaRA.onPause();
        } else {
            this.zzgt(5);
        }
    }

    public void onStop() {
        if (this.zzaRA != null) {
            this.zzaRA.onStop();
        } else {
            this.zzgt(4);
        }
    }

    public void onDestroyView() {
        if (this.zzaRA != null) {
            this.zzaRA.onDestroyView();
        } else {
            this.zzgt(2);
        }
    }

    public void onDestroy() {
        if (this.zzaRA != null) {
            this.zzaRA.onDestroy();
        } else {
            this.zzgt(1);
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        if (this.zzaRA != null) {
            this.zzaRA.onSaveInstanceState(bundle);
        } else if (this.zzaRB != null) {
            bundle.putAll(this.zzaRB);
        }
    }

    public void onLowMemory() {
        if (this.zzaRA != null) {
            this.zzaRA.onLowMemory();
        }
    }

    private static interface zza {
        public int getState();

        public void zzb(LifecycleDelegate var1);
    }
}

