/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzaam;
import com.google.android.gms.internal.zzaax;
import com.google.android.gms.internal.zzaay;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzabi;
import com.google.android.gms.internal.zzabm;
import com.google.android.gms.internal.zzabr;
import com.google.android.gms.internal.zzabs;
import com.google.android.gms.internal.zzabv;
import com.google.android.gms.internal.zzabz;
import com.google.android.gms.internal.zzzy;
import com.google.android.gms.internal.zzzz;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;

public abstract class zzc<O extends Api.ApiOptions> {
    private final Context mContext;
    private final Api<O> zzaxf;
    private final O zzayT;
    private final zzzz<O> zzayU;
    private final Looper zzrs;
    private final int mId;
    private final GoogleApiClient zzayV;
    private final zzabs zzayW;
    private final Account zzahh;
    protected final zzaax zzayX;

    protected zzc(@NonNull Context context, Api<O> api, Looper looper) {
        zzac.zzb((Object)context, (Object)"Null context is not permitted.");
        zzac.zzb(api, (Object)"Api must not be null.");
        zzac.zzb((Object)looper, (Object)"Looper must not be null.");
        this.mContext = context.getApplicationContext();
        this.zzaxf = api;
        this.zzayT = null;
        this.zzrs = looper;
        this.zzayU = zzzz.zzb(api);
        this.zzayV = new zzaay(this);
        this.zzayX = zzaax.zzaP(this.mContext);
        this.mId = this.zzayX.zzwz();
        this.zzayW = new zzzy();
        this.zzahh = null;
    }

    @Deprecated
    @MainThread
    public zzc(@NonNull Activity activity, Api<O> api, O o, Looper looper, zzabs zzabs2) {
        this(activity, api, o, new zza.zza().zzb(looper).zza(zzabs2).zzvk());
    }

    @Deprecated
    public zzc(@NonNull Context context, Api<O> api, O o, Looper looper, zzabs zzabs2) {
        this(context, api, o, new zza.zza().zzb(looper).zza(zzabs2).zzvk());
    }

    @MainThread
    public zzc(@NonNull Activity activity, Api<O> api, O o, zza zza2) {
        zzac.zzb((Object)activity, (Object)"Null activity is not permitted.");
        zzac.zzb(api, (Object)"Api must not be null.");
        zzac.zzb((Object)zza2, (Object)"Settings must not be null; use Settings.createDefault() instead.");
        this.mContext = activity.getApplicationContext();
        this.zzaxf = api;
        this.zzayT = o;
        this.zzrs = zza2.zzaza;
        this.zzayU = zzzz.zza(this.zzaxf, this.zzayT);
        this.zzayV = new zzaay(this);
        this.zzayX = zzaax.zzaP(this.mContext);
        this.mId = this.zzayX.zzwz();
        this.zzayW = zza2.zzayZ;
        this.zzahh = zza2.account;
        zzaam.zza(activity, this.zzayX, this.zzayU);
        this.zzayX.zzb(this);
    }

    public zzc(@NonNull Context context, Api<O> api, O o, zza zza2) {
        zzac.zzb((Object)context, (Object)"Null context is not permitted.");
        zzac.zzb(api, (Object)"Api must not be null.");
        zzac.zzb((Object)zza2, (Object)"Settings must not be null; use Settings.createDefault() instead.");
        this.mContext = context.getApplicationContext();
        this.zzaxf = api;
        this.zzayT = o;
        this.zzrs = zza2.zzaza;
        this.zzayU = zzzz.zza(this.zzaxf, this.zzayT);
        this.zzayV = new zzaay(this);
        this.zzayX = zzaax.zzaP(this.mContext);
        this.mId = this.zzayX.zzwz();
        this.zzayW = zza2.zzayZ;
        this.zzahh = zza2.account;
        this.zzayX.zzb(this);
    }

    @Deprecated
    public zzc(@NonNull Activity activity, Api<O> api, O o, zzabs zzabs2) {
        this(activity, api, o, new zza.zza().zza(zzabs2).zzb(activity.getMainLooper()).zzvk());
    }

    @Deprecated
    public zzc(@NonNull Context context, Api<O> api, O o, zzabs zzabs2) {
        this(context, api, o, new zza.zza().zza(zzabs2).zzvk());
    }

    private <A extends Api.zzb, T extends zzaad.zza<? extends Result, A>> T zza(int n, @NonNull T t) {
        t.zzvI();
        this.zzayX.zza(this, n, t);
        return t;
    }

    private <TResult, A extends Api.zzb> Task<TResult> zza(int n, @NonNull zzabv<A, TResult> zzabv2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzayX.zza(this, n, zzabv2, taskCompletionSource, this.zzayW);
        return taskCompletionSource.getTask();
    }

    public <A extends Api.zzb, T extends zzaad.zza<? extends Result, A>> T doRead(@NonNull T t) {
        return this.zza(0, t);
    }

    public <TResult, A extends Api.zzb> Task<TResult> doRead(zzabv<A, TResult> zzabv2) {
        return this.zza(0, zzabv2);
    }

    public <A extends Api.zzb, T extends zzaad.zza<? extends Result, A>> T doWrite(@NonNull T t) {
        return this.zza(1, t);
    }

    public <TResult, A extends Api.zzb> Task<TResult> doWrite(zzabv<A, TResult> zzabv2) {
        return this.zza(1, zzabv2);
    }

    public <A extends Api.zzb, T extends zzaad.zza<? extends Result, A>> T doBestEffortWrite(@NonNull T t) {
        return this.zza(2, t);
    }

    public <TResult, A extends Api.zzb> Task<TResult> doBestEffortWrite(zzabv<A, TResult> zzabv2) {
        return this.zza(2, zzabv2);
    }

    public <A extends Api.zzb, T extends zzabm<A, ?>, U extends zzabz<A, ?>> Task<Void> doRegisterEventListener(@NonNull T t, U u) {
        zzac.zzw(t);
        zzac.zzw(u);
        zzac.zzb(t.zzwW(), (Object)"Listener has already been released.");
        zzac.zzb(u.zzwW(), (Object)"Listener has already been released.");
        zzac.zzb((boolean)t.zzwW().equals(u.zzwW()), (Object)"Listener registration and unregistration methods must be constructed with the same ListenerHolder.");
        return this.zzayX.zza(this, t, u);
    }

    public Task<Void> doUnregisterEventListener(@NonNull zzabh.zzb<?> zzb2) {
        zzac.zzb(zzb2, (Object)"Listener key cannot be null.");
        return this.zzayX.zza(this, zzb2);
    }

    public <L> zzabh<L> registerListener(@NonNull L l, String string) {
        return zzabi.zzb(l, this.zzrs, string);
    }

    @WorkerThread
    public Api.zze buildApiClient(Looper looper, zzaax.zza<O> zza2) {
        zzg zzg2 = new GoogleApiClient.Builder(this.mContext).zze(this.zzahh).zzvp();
        return this.zzaxf.zzvf().zza(this.mContext, looper, zzg2, this.zzayT, zza2, zza2);
    }

    public Api<O> getApi() {
        return this.zzaxf;
    }

    public O getApiOptions() {
        return this.zzayT;
    }

    public zzzz<O> getApiKey() {
        return this.zzayU;
    }

    public int getInstanceId() {
        return this.mId;
    }

    public GoogleApiClient asGoogleApiClient() {
        return this.zzayV;
    }

    public Looper getLooper() {
        return this.zzrs;
    }

    public Context getApplicationContext() {
        return this.mContext;
    }

    public zzabr createSignInCoordinator(Context context, Handler handler) {
        return new zzabr(context, handler);
    }

    public static class com.google.android.gms.common.api.zzc$zza {
        public static final com.google.android.gms.common.api.zzc$zza zzayY = new zza().zzvk();
        public final zzabs zzayZ;
        public final Account account;
        public final Looper zzaza;

        private com.google.android.gms.common.api.zzc$zza(zzabs zzabs2, Account account, Looper looper) {
            this.zzayZ = zzabs2;
            this.account = account;
            this.zzaza = looper;
        }

        public static class zza {
            private zzabs zzayW;
            private Looper zzrs;

            public zza zza(zzabs zzabs2) {
                zzac.zzb((Object)zzabs2, (Object)"StatusExceptionMapper must not be null.");
                this.zzayW = zzabs2;
                return this;
            }

            public zza zzb(Looper looper) {
                zzac.zzb((Object)looper, (Object)"Looper must not be null.");
                this.zzrs = looper;
                return this;
            }

            public com.google.android.gms.common.api.zzc$zza zzvk() {
                if (this.zzayW == null) {
                    this.zzayW = new zzzy();
                }
                if (this.zzrs == null) {
                    this.zzrs = Looper.myLooper() != null ? Looper.myLooper() : Looper.getMainLooper();
                }
                return new com.google.android.gms.common.api.zzc$zza(this.zzayW, null, this.zzrs);
            }
        }
    }
}

