/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.SimpleArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.util.zzj;
import com.google.android.gms.internal.zzadg;

public final class zzh {
    private static final SimpleArrayMap<String, String> zzaFE = new SimpleArrayMap();

    @Nullable
    public static String zzg(Context context, int n) {
        Resources resources = context.getResources();
        switch (n) {
            case 4: 
            case 6: 
            case 18: {
                return null;
            }
            case 1: {
                return resources.getString(R.string.common_google_play_services_install_title);
            }
            case 3: {
                return resources.getString(R.string.common_google_play_services_enable_title);
            }
            case 2: {
                return resources.getString(R.string.common_google_play_services_update_title);
            }
            case 9: {
                Log.e((String)"GoogleApiAvailability", (String)"Google Play services is invalid. Cannot recover.");
                return null;
            }
            case 7: {
                Log.e((String)"GoogleApiAvailability", (String)"Network error occurred. Please retry request later.");
                return zzh.zzC(context, "common_google_play_services_network_error_title");
            }
            case 8: {
                Log.e((String)"GoogleApiAvailability", (String)"Internal error occurred. Please see logs for detailed information");
                return null;
            }
            case 10: {
                Log.e((String)"GoogleApiAvailability", (String)"Developer error occurred. Please see logs for detailed information");
                return null;
            }
            case 5: {
                Log.e((String)"GoogleApiAvailability", (String)"An invalid account was specified when connecting. Please provide a valid account.");
                return zzh.zzC(context, "common_google_play_services_invalid_account_title");
            }
            case 11: {
                Log.e((String)"GoogleApiAvailability", (String)"The application is not licensed to the user.");
                return null;
            }
            case 16: {
                Log.e((String)"GoogleApiAvailability", (String)"One of the API components you attempted to connect to is not available.");
                return null;
            }
            case 17: {
                Log.e((String)"GoogleApiAvailability", (String)"The specified account could not be signed in.");
                return zzh.zzC(context, "common_google_play_services_sign_in_failed_title");
            }
            case 20: {
                Log.e((String)"GoogleApiAvailability", (String)"The current user profile is restricted and could not use authenticated features.");
                return zzh.zzC(context, "common_google_play_services_restricted_profile_title");
            }
        }
        Log.e((String)"GoogleApiAvailability", (String)new StringBuilder(33).append("Unexpected error code ").append(n).toString());
        return null;
    }

    @NonNull
    public static String zzh(Context context, int n) {
        String string2 = n == 6 ? zzh.zzC(context, "common_google_play_services_resolution_required_title") : zzh.zzg(context, n);
        if (string2 == null) {
            string2 = context.getResources().getString(R.string.common_google_play_services_notification_ticker);
        }
        return string2;
    }

    @NonNull
    public static String zzi(Context context, int n) {
        Resources resources = context.getResources();
        String string2 = zzh.zzaT(context);
        switch (n) {
            case 1: {
                return resources.getString(R.string.common_google_play_services_install_text, new Object[]{string2});
            }
            case 3: {
                return resources.getString(R.string.common_google_play_services_enable_text, new Object[]{string2});
            }
            case 18: {
                return resources.getString(R.string.common_google_play_services_updating_text, new Object[]{string2});
            }
            case 2: {
                if (zzj.zzba((Context)context)) {
                    return resources.getString(R.string.common_google_play_services_wear_update_text);
                }
                return resources.getString(R.string.common_google_play_services_update_text, new Object[]{string2});
            }
            case 9: {
                return resources.getString(R.string.common_google_play_services_unsupported_text, new Object[]{string2});
            }
            case 7: {
                return zzh.zzo(context, "common_google_play_services_network_error_text", string2);
            }
            case 5: {
                return zzh.zzo(context, "common_google_play_services_invalid_account_text", string2);
            }
            case 16: {
                return zzh.zzo(context, "common_google_play_services_api_unavailable_text", string2);
            }
            case 17: {
                return zzh.zzo(context, "common_google_play_services_sign_in_failed_text", string2);
            }
            case 20: {
                return zzh.zzo(context, "common_google_play_services_restricted_profile_text", string2);
            }
        }
        return resources.getString(R.string.common_google_play_services_unknown_issue, new Object[]{string2});
    }

    @NonNull
    public static String zzj(Context context, int n) {
        if (n == 6) {
            return zzh.zzo(context, "common_google_play_services_resolution_required_text", zzh.zzaT(context));
        }
        return zzh.zzi(context, n);
    }

    @NonNull
    public static String zzk(Context context, int n) {
        Resources resources = context.getResources();
        switch (n) {
            case 1: {
                return resources.getString(R.string.common_google_play_services_install_button);
            }
            case 3: {
                return resources.getString(R.string.common_google_play_services_enable_button);
            }
            case 2: {
                return resources.getString(R.string.common_google_play_services_update_button);
            }
        }
        return resources.getString(17039370);
    }

    public static String zzaT(Context context) {
        String string2 = context.getApplicationInfo().name;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = context.getPackageName();
            try {
                string2 = zzadg.zzbi((Context)context).zzdA(context.getPackageName()).toString();
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        return string2;
    }

    private static String zzo(Context context, String string2, String string3) {
        Resources resources = context.getResources();
        String string4 = zzh.zzC(context, string2);
        if (string4 == null) {
            string4 = resources.getString(R.string.common_google_play_services_unknown_issue);
        }
        return String.format(resources.getConfiguration().locale, string4, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String zzC(Context context, String string2) {
        SimpleArrayMap<String, String> simpleArrayMap = zzaFE;
        synchronized (simpleArrayMap) {
            String string3 = (String)zzaFE.get((Object)string2);
            if (string3 != null) {
                return string3;
            }
            Resources resources = GooglePlayServicesUtil.getRemoteResource(context);
            if (resources == null) {
                return null;
            }
            int n = resources.getIdentifier(string2, "string", "com.google.android.gms");
            if (n == 0) {
                String string4 = String.valueOf(string2);
                Log.w((String)"GoogleApiAvailability", (String)(string4.length() != 0 ? "Missing resource: ".concat(string4) : new String("Missing resource: ")));
                return null;
            }
            string3 = resources.getString(n);
            if (TextUtils.isEmpty((CharSequence)string3)) {
                String string5 = String.valueOf(string2);
                Log.w((String)"GoogleApiAvailability", (String)(string5.length() != 0 ? "Got empty resource: ".concat(string5) : new String("Got empty resource: ")));
                return null;
            }
            zzaFE.put((Object)string2, (Object)string3);
            return string3;
        }
    }
}

