/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Application;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzal;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.util.zzt;
import com.google.android.gms.internal.zzaab;
import com.google.android.gms.internal.zzaac;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzaah;
import com.google.android.gms.internal.zzaal;
import com.google.android.gms.internal.zzaam;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzabl;
import com.google.android.gms.internal.zzabm;
import com.google.android.gms.internal.zzabn;
import com.google.android.gms.internal.zzabr;
import com.google.android.gms.internal.zzabs;
import com.google.android.gms.internal.zzabv;
import com.google.android.gms.internal.zzabz;
import com.google.android.gms.internal.zzbai;
import com.google.android.gms.internal.zzzx;
import com.google.android.gms.internal.zzzz;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class zzaax
implements Handler.Callback {
    public static final Status zzaCn = new Status(4, "Sign-out occurred while this API call was in progress.");
    private static final Status zzaCo = new Status(4, "The user must be signed in to make this API call.");
    private long zzaBN = 5000L;
    private long zzaBM = 120000L;
    private long zzaCp = 10000L;
    private static final Object zztX = new Object();
    private static zzaax zzaCq;
    private final Context mContext;
    private final GoogleApiAvailability zzazn;
    private int zzaCr = -1;
    private final AtomicInteger zzaCs = new AtomicInteger(1);
    private final AtomicInteger zzaCt = new AtomicInteger(0);
    private final Map<zzzz<?>, zza<?>> zzaAM = new ConcurrentHashMap(5, 0.75f, 1);
    private zzaam zzaCu = null;
    private final Set<zzzz<?>> zzaCv = new com.google.android.gms.common.util.zza();
    private final Set<zzzz<?>> zzaCw = new com.google.android.gms.common.util.zza();
    private final Handler mHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzaax zzaP(Context context) {
        Object object = zztX;
        synchronized (object) {
            if (zzaCq == null) {
                Looper looper = zzaax.zzwy();
                zzaCq = new zzaax(context.getApplicationContext(), looper, GoogleApiAvailability.getInstance());
            }
            return zzaCq;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzaax zzww() {
        Object object = zztX;
        synchronized (object) {
            zzac.zzb((Object)zzaCq, (Object)"Must guarantee manager is non-null before using getInstance");
            return zzaCq;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzwx() {
        Object object = zztX;
        synchronized (object) {
            if (zzaCq != null) {
                zzaCq.signOut();
            }
        }
    }

    private static Looper zzwy() {
        HandlerThread handlerThread = new HandlerThread("GoogleApiHandler", 9);
        handlerThread.start();
        return handlerThread.getLooper();
    }

    private zzaax(Context context, Looper looper, GoogleApiAvailability googleApiAvailability) {
        this.mContext = context;
        this.mHandler = new Handler(looper, (Handler.Callback)this);
        this.zzazn = googleApiAvailability;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6));
    }

    public int zzwz() {
        return this.zzaCs.getAndIncrement();
    }

    @WorkerThread
    private void zzwA() {
        zzt.zzzg();
        if (this.mContext.getApplicationContext() instanceof Application) {
            Application application = (Application)this.mContext.getApplicationContext();
            zzaac.zza((Application)application);
            zzaac.zzvB().zza(new zzaac.zza(){

                public void zzas(boolean bl) {
                    zzaax.this.mHandler.sendMessage(zzaax.this.mHandler.obtainMessage(1, (Object)bl));
                }
            });
            boolean bl = zzaac.zzvB().zzar(true);
            if (!bl) {
                this.zzaCp = 300000L;
            }
        }
    }

    public void zzb(zzc<?> zzc2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, zzc2));
    }

    @WorkerThread
    private void zzc(zzc<?> zzc2) {
        zzzz<?> zzzz2 = zzc2.getApiKey();
        zza<?> zza2 = this.zzaAM.get(zzzz2);
        if (zza2 == null) {
            zza2 = new zza(zzc2);
            this.zzaAM.put(zzzz2, zza2);
        }
        if (zza2.zzrd()) {
            this.zzaCw.add(zzzz2);
        }
        zza2.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(@NonNull zzaam zzaam2) {
        Object object = zztX;
        synchronized (object) {
            if (this.zzaCu != zzaam2) {
                this.zzaCu = zzaam2;
                this.zzaCv.clear();
                this.zzaCv.addAll((Collection<zzzz<?>>)zzaam2.zzwb());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzb(@NonNull zzaam zzaam2) {
        Object object = zztX;
        synchronized (object) {
            if (this.zzaCu == zzaam2) {
                this.zzaCu = null;
                this.zzaCv.clear();
            }
        }
    }

    public Task<Void> zza(Iterable<? extends zzc<?>> iterable) {
        zzaab zzaab2 = new zzaab(iterable);
        for (zzc<?> zzc2 : iterable) {
            zza<?> zza2 = this.zzaAM.get(zzc2.getApiKey());
            if (zza2 != null && zza2.isConnected()) continue;
            this.mHandler.sendMessage(this.mHandler.obtainMessage(2, (Object)zzaab2));
            return zzaab2.getTask();
        }
        zzaab2.zzvA();
        return zzaab2.getTask();
    }

    @WorkerThread
    private void zza(zzaab zzaab2) {
        Set<zzzz<?>> set = zzaab2.zzvz();
        for (zzzz<?> zzzz2 : set) {
            zza<?> zza2 = this.zzaAM.get(zzzz2);
            if (zza2 == null) {
                ConnectionResult connectionResult = new ConnectionResult(13);
                zzaab2.zza(zzzz2, connectionResult);
                return;
            }
            if (zza2.isConnected()) {
                zzaab2.zza(zzzz2, ConnectionResult.zzayj);
                continue;
            }
            if (zza2.zzwK() != null) {
                zzaab2.zza(zzzz2, zza2.zzwK());
                continue;
            }
            zza2.zzb(zzaab2);
        }
    }

    public void zzvx() {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3));
    }

    @WorkerThread
    private void zzwB() {
        for (zza<?> zza2 : this.zzaAM.values()) {
            zza2.zzwJ();
            zza2.connect();
        }
    }

    public void signOut() {
        this.zzaCt.incrementAndGet();
        this.mHandler.sendMessageAtFrontOfQueue(this.mHandler.obtainMessage(10));
    }

    void zzvn() {
        this.zzaCt.incrementAndGet();
        this.mHandler.sendMessage(this.mHandler.obtainMessage(10));
    }

    @WorkerThread
    private void zzwC() {
        for (zzzz<?> zzzz2 : this.zzaCw) {
            this.zzaAM.remove(zzzz2).signOut();
        }
        this.zzaCw.clear();
    }

    public <O extends Api.ApiOptions> void zza(zzc<O> zzc2, int n, zzaad.zza<? extends Result, Api.zzb> zza2) {
        zzzx.zzb<zzaad.zza<? extends Result, Api.zzb>> zzb2 = new zzzx.zzb<zzaad.zza<? extends Result, Api.zzb>>(n, zza2);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)new zzabl(zzb2, this.zzaCt.get(), zzc2)));
    }

    public <O extends Api.ApiOptions, TResult> void zza(zzc<O> zzc2, int n, zzabv<Api.zzb, TResult> zzabv2, TaskCompletionSource<TResult> taskCompletionSource, zzabs zzabs2) {
        zzzx.zzd<TResult> zzd2 = new zzzx.zzd<TResult>(n, zzabv2, taskCompletionSource, zzabs2);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)new zzabl(zzd2, this.zzaCt.get(), zzc2)));
    }

    @WorkerThread
    private void zza(zzabl zzabl2) {
        zza<?> zza2 = this.zzaAM.get(zzabl2.zzaDe.getApiKey());
        if (zza2 == null) {
            this.zzc(zzabl2.zzaDe);
            zza2 = this.zzaAM.get(zzabl2.zzaDe.getApiKey());
        }
        if (zza2.zzrd() && this.zzaCt.get() != zzabl2.zzaDd) {
            zzabl2.zzaDc.zzz(zzaCn);
            zza2.signOut();
            return;
        }
        zza2.zza(zzabl2.zzaDc);
    }

    public <O extends Api.ApiOptions> Task<Void> zza(@NonNull zzc<O> zzc2, @NonNull zzabm<Api.zzb, ?> zzabm2, @NonNull zzabz<Api.zzb, ?> zzabz2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzzx.zzc zzc3 = new zzzx.zzc(new zzabn(zzabm2, zzabz2), (TaskCompletionSource<Void>)taskCompletionSource);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(8, (Object)new zzabl(zzc3, this.zzaCt.get(), zzc2)));
        return taskCompletionSource.getTask();
    }

    public <O extends Api.ApiOptions> Task<Void> zza(@NonNull zzc<O> zzc2, @NonNull zzabh.zzb<?> zzb2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzzx.zze zze2 = new zzzx.zze(zzb2, (TaskCompletionSource<Void>)taskCompletionSource);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(13, (Object)new zzabl(zze2, this.zzaCt.get(), zzc2)));
        return taskCompletionSource.getTask();
    }

    @WorkerThread
    public boolean handleMessage(Message message) {
        switch (message.what) {
            case 1: {
                this.zzau((Boolean)message.obj);
                break;
            }
            case 2: {
                this.zza((zzaab)message.obj);
                break;
            }
            case 3: {
                this.zzwB();
                break;
            }
            case 4: 
            case 8: 
            case 13: {
                this.zza((zzabl)message.obj);
                break;
            }
            case 5: {
                this.zza(message.arg1, (ConnectionResult)message.obj);
                break;
            }
            case 6: {
                this.zzwA();
                break;
            }
            case 7: {
                this.zzc((zzc)message.obj);
                break;
            }
            case 9: {
                if (!this.zzaAM.containsKey(message.obj)) break;
                this.zzaAM.get(message.obj).resume();
                break;
            }
            case 10: {
                this.zzwC();
                break;
            }
            case 11: {
                if (!this.zzaAM.containsKey(message.obj)) break;
                this.zzaAM.get(message.obj).zzwn();
                break;
            }
            case 12: {
                if (!this.zzaAM.containsKey(message.obj)) break;
                this.zzaAM.get(message.obj).zzwN();
                break;
            }
            default: {
                int n = message.what;
                Log.w((String)"GoogleApiManager", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                return false;
            }
        }
        return true;
    }

    PendingIntent zza(zzzz<?> zzzz2, int n) {
        zza<?> zza2 = this.zzaAM.get(zzzz2);
        if (zza2 == null) {
            return null;
        }
        zzbai zzbai2 = this.zzaAM.get(zzzz2).zzwO();
        if (zzbai2 == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)n, (Intent)zzbai2.zzrs(), (int)0x8000000);
    }

    boolean zzc(ConnectionResult connectionResult, int n) {
        return this.zzazn.zza(this.mContext, connectionResult, n);
    }

    public void zza(ConnectionResult connectionResult, int n) {
        if (!this.zzc(connectionResult, n)) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(5, n, 0, (Object)connectionResult));
        }
    }

    @WorkerThread
    private void zza(int n, ConnectionResult connectionResult) {
        zza<?> zza2 = null;
        for (zza<?> zza3 : this.zzaAM.values()) {
            if (zza3.getInstanceId() != n) continue;
            zza2 = zza3;
            break;
        }
        if (zza2 != null) {
            zza<?> zza3;
            String string2 = String.valueOf(this.zzazn.getErrorString(connectionResult.getErrorCode()));
            zza3 = String.valueOf(connectionResult.getErrorMessage());
            zza2.zzD(new Status(17, new StringBuilder(69 + String.valueOf(string2).length() + String.valueOf(zza3).length()).append("Error resolution was canceled by the user, original error message: ").append(string2).append(": ").append((String)((Object)zza3)).toString()));
        } else {
            Log.wtf((String)"GoogleApiManager", (String)new StringBuilder(76).append("Could not find API instance ").append(n).append(" while trying to fail enqueued calls.").toString(), (Throwable)new Exception());
        }
    }

    @WorkerThread
    private void zzau(boolean bl) {
        this.zzaCp = bl ? 10000L : 300000L;
        this.mHandler.removeMessages(12);
        for (zzzz<?> zzzz2 : this.zzaAM.keySet()) {
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(12, zzzz2), this.zzaCp);
        }
    }

    private class zzb
    implements zzf.zzf,
    zzabr.zza {
        private final Api.zze zzaAJ;
        private final zzzz<?> zzayU;
        private zzr zzaBw = null;
        private Set<Scope> zzakq = null;
        private boolean zzaCI = false;

        public zzb(Api.zze zze2, zzzz<?> zzzz2) {
            this.zzaAJ = zze2;
            this.zzayU = zzzz2;
        }

        public void zzg(final @NonNull ConnectionResult connectionResult) {
            zzaax.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (connectionResult.isSuccess()) {
                        zzb.this.zzaCI = true;
                        if (zzb.this.zzaAJ.zzrd()) {
                            zzb.this.zzwP();
                        } else {
                            zzb.this.zzaAJ.zza(null, Collections.emptySet());
                        }
                    } else {
                        ((zza)zzaax.this.zzaAM.get(zzb.this.zzayU)).onConnectionFailed(connectionResult);
                    }
                }
            });
        }

        @Override
        @WorkerThread
        public void zzi(ConnectionResult connectionResult) {
            ((zza)zzaax.this.zzaAM.get(this.zzayU)).zzi(connectionResult);
        }

        @Override
        @WorkerThread
        public void zzb(zzr zzr2, Set<Scope> set) {
            if (zzr2 == null || set == null) {
                Log.wtf((String)"GoogleApiManager", (String)"Received null response from onSignInSuccess", (Throwable)new Exception());
                this.zzi(new ConnectionResult(4));
            } else {
                this.zzaBw = zzr2;
                this.zzakq = set;
                this.zzwP();
            }
        }

        @WorkerThread
        private void zzwP() {
            if (this.zzaCI && this.zzaBw != null) {
                this.zzaAJ.zza(this.zzaBw, this.zzakq);
            }
        }
    }

    public class zza<O extends Api.ApiOptions>
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener,
    zzaah {
        private final Queue<zzzx> zzaCy = new LinkedList<zzzx>();
        private final Api.zze zzaAJ;
        private final Api.zzb zzaCz;
        private final zzzz<O> zzayU;
        private final zzaal zzaCA;
        private final Set<zzaab> zzaCB = new HashSet<zzaab>();
        private final Map<zzabh.zzb<?>, zzabn> zzaCC = new HashMap();
        private final int zzaCD;
        private final zzabr zzaCE;
        private boolean zzaBL;
        private ConnectionResult zzaCF = null;

        @WorkerThread
        public zza(zzc<O> zzc2) {
            this.zzaAJ = zzc2.buildApiClient(zzaax.this.mHandler.getLooper(), this);
            this.zzaCz = this.zzaAJ instanceof zzal ? ((zzal)this.zzaAJ).zzyn() : this.zzaAJ;
            this.zzayU = zzc2.getApiKey();
            this.zzaCA = new zzaal();
            this.zzaCD = zzc2.getInstanceId();
            this.zzaCE = this.zzaAJ.zzrd() ? zzc2.createSignInCoordinator(zzaax.this.mContext, zzaax.this.mHandler) : null;
        }

        @Override
        public void onConnected(@Nullable Bundle bundle) {
            if (Looper.myLooper() == zzaax.this.mHandler.getLooper()) {
                this.zzwF();
            } else {
                zzaax.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        zza.this.zzwF();
                    }
                });
            }
        }

        @WorkerThread
        private void zzwF() {
            this.zzwJ();
            this.zzj(ConnectionResult.zzayj);
            this.zzwL();
            Iterator<zzabn> iterator = this.zzaCC.values().iterator();
            while (iterator.hasNext()) {
                iterator.next();
                try {
                    new TaskCompletionSource();
                }
                catch (DeadObjectException deadObjectException) {
                    this.onConnectionSuspended(1);
                    this.zzaAJ.disconnect();
                    break;
                }
                catch (RemoteException remoteException) {
                }
            }
            this.zzwH();
            this.zzwM();
        }

        @Override
        public void onConnectionSuspended(int n) {
            if (Looper.myLooper() == zzaax.this.mHandler.getLooper()) {
                this.zzwG();
            } else {
                zzaax.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        zza.this.zzwG();
                    }
                });
            }
        }

        @WorkerThread
        private void zzwG() {
            this.zzwJ();
            this.zzaBL = true;
            this.zzaCA.zzwa();
            zzaax.this.mHandler.sendMessageDelayed(Message.obtain((Handler)zzaax.this.mHandler, (int)9, this.zzayU), zzaax.this.zzaBN);
            zzaax.this.mHandler.sendMessageDelayed(Message.obtain((Handler)zzaax.this.mHandler, (int)11, this.zzayU), zzaax.this.zzaBM);
            zzaax.this.zzaCr = -1;
        }

        @WorkerThread
        public void zzi(@NonNull ConnectionResult connectionResult) {
            zzac.zza((Handler)zzaax.this.mHandler);
            this.zzaAJ.disconnect();
            this.onConnectionFailed(connectionResult);
        }

        @Override
        public void zza(final ConnectionResult connectionResult, Api<?> api, boolean bl) {
            if (Looper.myLooper() == zzaax.this.mHandler.getLooper()) {
                this.onConnectionFailed(connectionResult);
            } else {
                zzaax.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        zza.this.onConnectionFailed(connectionResult);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @WorkerThread
        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            zzac.zza((Handler)zzaax.this.mHandler);
            if (this.zzaCE != null) {
                this.zzaCE.zzwY();
            }
            this.zzwJ();
            zzaax.this.zzaCr = -1;
            this.zzj(connectionResult);
            if (connectionResult.getErrorCode() == 4) {
                this.zzD(zzaCo);
                return;
            }
            if (this.zzaCy.isEmpty()) {
                this.zzaCF = connectionResult;
                return;
            }
            Object object = zztX;
            synchronized (object) {
                if (zzaax.this.zzaCu != null && zzaax.this.zzaCv.contains(this.zzayU)) {
                    zzaax.this.zzaCu.zzb(connectionResult, this.zzaCD);
                    return;
                }
            }
            if (!zzaax.this.zzc(connectionResult, this.zzaCD)) {
                if (connectionResult.getErrorCode() == 18) {
                    this.zzaBL = true;
                }
                if (this.zzaBL) {
                    zzaax.this.mHandler.sendMessageDelayed(Message.obtain((Handler)zzaax.this.mHandler, (int)9, this.zzayU), zzaax.this.zzaBN);
                } else {
                    object = String.valueOf(this.zzayU.zzvw());
                    this.zzD(new Status(17, new StringBuilder(38 + String.valueOf(object).length()).append("API: ").append((String)object).append(" is not available on this device.").toString()));
                }
            }
        }

        @WorkerThread
        private void zzwH() {
            while (this.zzaAJ.isConnected() && !this.zzaCy.isEmpty()) {
                zzzx zzzx2 = this.zzaCy.remove();
                this.zzb(zzzx2);
            }
        }

        @WorkerThread
        public void zza(zzzx zzzx2) {
            zzac.zza((Handler)zzaax.this.mHandler);
            if (this.zzaAJ.isConnected()) {
                this.zzb(zzzx2);
                this.zzwM();
            } else {
                this.zzaCy.add(zzzx2);
                if (this.zzaCF != null && this.zzaCF.hasResolution()) {
                    this.onConnectionFailed(this.zzaCF);
                } else {
                    this.connect();
                }
            }
        }

        @WorkerThread
        public void signOut() {
            zzac.zza((Handler)zzaax.this.mHandler);
            this.zzD(zzaCn);
            this.zzaCA.zzvZ();
            for (zzabh.zzb<?> zzb2 : this.zzaCC.keySet()) {
                this.zza(new zzzx.zze(zzb2, (TaskCompletionSource<Void>)new TaskCompletionSource()));
            }
            this.zzj(new ConnectionResult(4));
            this.zzaAJ.disconnect();
        }

        public Api.zze zzvU() {
            return this.zzaAJ;
        }

        public Map<zzabh.zzb<?>, zzabn> zzwI() {
            return this.zzaCC;
        }

        @WorkerThread
        public void zzwJ() {
            zzac.zza((Handler)zzaax.this.mHandler);
            this.zzaCF = null;
        }

        @WorkerThread
        public ConnectionResult zzwK() {
            zzac.zza((Handler)zzaax.this.mHandler);
            return this.zzaCF;
        }

        @WorkerThread
        private void zzb(zzzx zzzx2) {
            zzzx2.zza(this.zzaCA, this.zzrd());
            try {
                zzzx2.zza(this);
            }
            catch (DeadObjectException deadObjectException) {
                this.onConnectionSuspended(1);
                this.zzaAJ.disconnect();
            }
        }

        @WorkerThread
        public void zzD(Status status) {
            zzac.zza((Handler)zzaax.this.mHandler);
            for (zzzx zzzx2 : this.zzaCy) {
                zzzx2.zzz(status);
            }
            this.zzaCy.clear();
        }

        @WorkerThread
        public void resume() {
            zzac.zza((Handler)zzaax.this.mHandler);
            if (this.zzaBL) {
                this.connect();
            }
        }

        @WorkerThread
        private void zzwL() {
            if (this.zzaBL) {
                zzaax.this.mHandler.removeMessages(11, this.zzayU);
                zzaax.this.mHandler.removeMessages(9, this.zzayU);
                this.zzaBL = false;
            }
        }

        @WorkerThread
        public void zzwn() {
            zzac.zza((Handler)zzaax.this.mHandler);
            if (this.zzaBL) {
                this.zzwL();
                int n = zzaax.this.zzazn.isGooglePlayServicesAvailable(zzaax.this.mContext);
                Status status = n == 18 ? new Status(8, "Connection timed out while waiting for Google Play services update to complete.") : new Status(8, "API failed to connect while resuming due to an unknown error.");
                this.zzD(status);
                this.zzaAJ.disconnect();
            }
        }

        private void zzwM() {
            zzaax.this.mHandler.removeMessages(12, this.zzayU);
            zzaax.this.mHandler.sendMessageDelayed(zzaax.this.mHandler.obtainMessage(12, this.zzayU), zzaax.this.zzaCp);
        }

        @WorkerThread
        public void zzwN() {
            zzac.zza((Handler)zzaax.this.mHandler);
            if (this.zzaAJ.isConnected() && this.zzaCC.size() == 0) {
                if (this.zzaCA.zzvY()) {
                    this.zzwM();
                    return;
                }
                this.zzaAJ.disconnect();
            }
        }

        @WorkerThread
        public void connect() {
            zzac.zza((Handler)zzaax.this.mHandler);
            if (this.zzaAJ.isConnected() || this.zzaAJ.isConnecting()) {
                return;
            }
            if (this.zzaAJ.zzvh() && zzaax.this.zzaCr != 0) {
                zzaax.this.zzaCr = zzaax.this.zzazn.isGooglePlayServicesAvailable(zzaax.this.mContext);
                if (zzaax.this.zzaCr != 0) {
                    ConnectionResult connectionResult = new ConnectionResult(zzaax.this.zzaCr, null);
                    this.onConnectionFailed(connectionResult);
                    return;
                }
            }
            zzb zzb2 = new zzb(this.zzaAJ, this.zzayU);
            if (this.zzaAJ.zzrd()) {
                this.zzaCE.zza(zzb2);
            }
            this.zzaAJ.zza(zzb2);
        }

        @WorkerThread
        public void zzb(zzaab zzaab2) {
            zzac.zza((Handler)zzaax.this.mHandler);
            this.zzaCB.add(zzaab2);
        }

        @WorkerThread
        private void zzj(ConnectionResult connectionResult) {
            for (zzaab zzaab2 : this.zzaCB) {
                zzaab2.zza(this.zzayU, connectionResult);
            }
            this.zzaCB.clear();
        }

        boolean isConnected() {
            return this.zzaAJ.isConnected();
        }

        public boolean zzrd() {
            return this.zzaAJ.zzrd();
        }

        public int getInstanceId() {
            return this.zzaCD;
        }

        zzbai zzwO() {
            return this.zzaCE == null ? null : this.zzaCE.zzwO();
        }
    }
}

