/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Looper;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.OptionalPendingResult;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.zzbcq;
import com.google.android.gms.internal.zzbfo;
import com.google.android.gms.internal.zzbfz;

public final class PendingResults {
    public static PendingResult<Status> immediatePendingResult(Status status) {
        zzbr.zzb((Object)status, (Object)"Result must not be null");
        zzbfz zzbfz2 = new zzbfz(Looper.getMainLooper());
        zzbfz2.setResult(status);
        return zzbfz2;
    }

    public static PendingResult<Status> zza(Status status, GoogleApiClient googleApiClient) {
        zzbr.zzb((Object)status, (Object)"Result must not be null");
        zzbfz zzbfz2 = new zzbfz(googleApiClient);
        zzbfz2.setResult(status);
        return zzbfz2;
    }

    public static <R extends Result> PendingResult<R> zza(R r, GoogleApiClient googleApiClient) {
        zzbr.zzb(r, (Object)"Result must not be null");
        zzbr.zzb((!r.getStatus().isSuccess() ? 1 : 0) != 0, (Object)"Status code must not be SUCCESS");
        zzb<R> zzb2 = new zzb<R>(googleApiClient, r);
        zzb2.setResult(r);
        return zzb2;
    }

    public static <R extends Result> OptionalPendingResult<R> immediatePendingResult(R r) {
        zzbr.zzb(r, (Object)"Result must not be null");
        zzc<R> zzc2 = new zzc<R>(null);
        zzc2.setResult(r);
        return new zzbfo(zzc2);
    }

    public static <R extends Result> OptionalPendingResult<R> zzb(R r, GoogleApiClient googleApiClient) {
        zzbr.zzb(r, (Object)"Result must not be null");
        zzc<R> zzc2 = new zzc<R>(googleApiClient);
        zzc2.setResult(r);
        return new zzbfo(zzc2);
    }

    public static PendingResult<Status> canceledPendingResult() {
        zzbfz zzbfz2 = new zzbfz(Looper.getMainLooper());
        zzbfz2.cancel();
        return zzbfz2;
    }

    public static <R extends Result> PendingResult<R> canceledPendingResult(R r) {
        zzbr.zzb(r, (Object)"Result must not be null");
        zzbr.zzb((r.getStatus().getStatusCode() == 16 ? 1 : 0) != 0, (Object)"Status code must be CommonStatusCodes.CANCELED");
        zza<R> zza2 = new zza<R>(r);
        zza2.cancel();
        return zza2;
    }

    private PendingResults() {
    }

    static final class zza<R extends Result>
    extends zzbcq<R> {
        private final R zzaBk;

        public zza(R r) {
            super(Looper.getMainLooper());
            this.zzaBk = r;
        }

        @Override
        protected final R zzb(Status status) {
            if (status.getStatusCode() != this.zzaBk.getStatus().getStatusCode()) {
                throw new UnsupportedOperationException("Creating failed results is not supported");
            }
            return this.zzaBk;
        }
    }

    static final class zzb<R extends Result>
    extends zzbcq<R> {
        private final R zzaBl;

        public zzb(GoogleApiClient googleApiClient, R r) {
            super(googleApiClient);
            this.zzaBl = r;
        }

        @Override
        protected final R zzb(Status status) {
            return this.zzaBl;
        }
    }

    static final class zzc<R extends Result>
    extends zzbcq<R> {
        public zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        @Override
        protected final R zzb(Status status) {
            throw new UnsupportedOperationException("Creating failed results is not supported");
        }
    }
}

