/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.zzbcm;
import com.google.android.gms.internal.zzbcn;
import com.google.android.gms.internal.zzbfd;
import com.google.android.gms.internal.zzbfe;
import com.google.android.gms.internal.zzbff;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class zzbcg
extends zzbcm {
    private final SparseArray<zza> zzaBD = new SparseArray();

    public static zzbcg zza(zzbfd zzbfd2) {
        zzbff zzbff2 = zzbcg.zzb((zzbfd)zzbfd2);
        zzbcg zzbcg2 = (zzbcg)zzbff2.zza("AutoManageHelper", zzbcg.class);
        if (zzbcg2 != null) {
            return zzbcg2;
        }
        return new zzbcg(zzbff2);
    }

    private zzbcg(zzbff zzbff2) {
        super(zzbff2);
        this.zzaEI.zza("AutoManageHelper", (zzbfe)this);
    }

    public final void zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzbr.zzb((Object)googleApiClient, (Object)"GoogleApiClient instance cannot be null");
        zzbr.zza((this.zzaBD.indexOfKey(n) < 0 ? 1 : 0) != 0, (Object)new StringBuilder(54).append("Already managing a GoogleApiClient with id ").append(n).toString());
        zzbcn zzbcn2 = (zzbcn)this.zzaBP.get();
        boolean bl = this.mStarted;
        String string2 = String.valueOf(zzbcn2);
        Log.d((String)"AutoManageHelper", (String)new StringBuilder(49 + String.valueOf(string2).length()).append("starting AutoManage for client ").append(n).append(" ").append(bl).append(" ").append(string2).toString());
        zza zza2 = new zza(this, n, googleApiClient, onConnectionFailedListener);
        this.zzaBD.put(n, (Object)zza2);
        if (this.mStarted && zzbcn2 == null) {
            string2 = String.valueOf(googleApiClient);
            Log.d((String)"AutoManageHelper", (String)new StringBuilder(11 + String.valueOf(string2).length()).append("connecting ").append(string2).toString());
            googleApiClient.connect();
        }
    }

    public final void zzal(int n) {
        zza zza2 = (zza)this.zzaBD.get(n);
        this.zzaBD.remove(n);
        if (zza2 != null) {
            zza zza3 = zza2;
            zza3.zzaBF.unregisterConnectionFailedListener(zza3);
            zza3.zzaBF.disconnect();
        }
    }

    @Override
    public final void onStart() {
        super.onStart();
        int n = this.mStarted;
        Object object = String.valueOf(this.zzaBD);
        Log.d((String)"AutoManageHelper", (String)new StringBuilder(14 + String.valueOf(object).length()).append("onStart ").append(n != 0).append(" ").append((String)object).toString());
        if (this.zzaBP.get() == null) {
            for (n = 0; n < this.zzaBD.size(); ++n) {
                object = this.zzam(n);
                if (object == null) continue;
                ((zza)object).zzaBF.connect();
            }
        }
    }

    @Override
    public final void onStop() {
        super.onStop();
        for (int i = 0; i < this.zzaBD.size(); ++i) {
            zza zza2 = this.zzam(i);
            if (zza2 == null) continue;
            zza2.zzaBF.disconnect();
        }
    }

    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        for (int i = 0; i < this.zzaBD.size(); ++i) {
            zza zza2 = this.zzam(i);
            if (zza2 == null) continue;
            String[] stringArray2 = stringArray;
            PrintWriter printWriter2 = printWriter;
            FileDescriptor fileDescriptor2 = fileDescriptor;
            String string3 = string2;
            zza zza3 = zza2;
            printWriter2.append(string3).append("GoogleApiClient #").print(zza3.zzaBE);
            printWriter2.println(":");
            zza3.zzaBF.dump(String.valueOf(string3).concat("  "), fileDescriptor2, printWriter2, stringArray2);
        }
    }

    @Override
    protected final void zza(ConnectionResult connectionResult, int n) {
        Log.w((String)"AutoManageHelper", (String)"Unresolved error while connecting client. Stopping auto-manage.");
        if (n < 0) {
            Log.wtf((String)"AutoManageHelper", (String)"AutoManageLifecycleHelper received onErrorResolutionFailed callback but no failing client ID is set", (Throwable)new Exception());
            return;
        }
        zza zza2 = (zza)this.zzaBD.get(n);
        if (zza2 != null) {
            this.zzal(n);
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = zza2.zzaBG;
            if (onConnectionFailedListener != null) {
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
    }

    @Override
    protected final void zzpq() {
        for (int i = 0; i < this.zzaBD.size(); ++i) {
            zza zza2 = this.zzam(i);
            if (zza2 == null) continue;
            zza2.zzaBF.connect();
        }
    }

    @Nullable
    private final zza zzam(int n) {
        if (this.zzaBD.size() <= n) {
            return null;
        }
        return (zza)this.zzaBD.get(this.zzaBD.keyAt(n));
    }

    final class zza
    implements GoogleApiClient.OnConnectionFailedListener {
        public final int zzaBE;
        public final GoogleApiClient zzaBF;
        public final GoogleApiClient.OnConnectionFailedListener zzaBG;
        private /* synthetic */ zzbcg zzaBH;

        public zza(zzbcg zzbcg2, int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.zzaBH = zzbcg2;
            this.zzaBE = n;
            this.zzaBF = googleApiClient;
            this.zzaBG = onConnectionFailedListener;
            googleApiClient.registerConnectionFailedListener(this);
        }

        @Override
        public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            String string2 = String.valueOf(connectionResult);
            Log.d((String)"AutoManageHelper", (String)new StringBuilder(27 + String.valueOf(string2).length()).append("beginFailureResolution for ").append(string2).toString());
            this.zzaBH.zzb(connectionResult, this.zzaBE);
        }
    }
}

