/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Application;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.common.util.zzb;
import com.google.android.gms.internal.zzbca;
import com.google.android.gms.internal.zzbcb;
import com.google.android.gms.internal.zzbcc;
import com.google.android.gms.internal.zzbcd;
import com.google.android.gms.internal.zzbcf;
import com.google.android.gms.internal.zzbch;
import com.google.android.gms.internal.zzbci;
import com.google.android.gms.internal.zzbcj;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbdi;
import com.google.android.gms.internal.zzbeo;
import com.google.android.gms.internal.zzbep;
import com.google.android.gms.internal.zzbfk;
import com.google.android.gms.internal.zzbfp;
import com.google.android.gms.internal.zzbfq;
import com.google.android.gms.internal.zzbfr;
import com.google.android.gms.internal.zzbfy;
import com.google.android.gms.internal.zzbgc;
import com.google.android.gms.internal.zzbgk;
import com.google.android.gms.internal.zzcuw;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzben
implements Handler.Callback {
    public static final Status zzaEe = new Status(4, "Sign-out occurred while this API call was in progress.");
    private static final Status zzaEf = new Status(4, "The user must be signed in to make this API call.");
    private long zzaDE = 5000L;
    private long zzaDD = 120000L;
    private long zzaEg = 10000L;
    private static final Object zzuI = new Object();
    private static zzben zzaEh;
    private final Context mContext;
    private final GoogleApiAvailability zzaBf;
    private int zzaEi = -1;
    private final AtomicInteger zzaEj = new AtomicInteger(1);
    private final AtomicInteger zzaEk = new AtomicInteger(0);
    private final Map<zzbcf<?>, zzbep<?>> zzaCD = new ConcurrentHashMap(5, 0.75f, 1);
    private zzbdi zzaEl = null;
    private final Set<zzbcf<?>> zzaEm = new zzb();
    private final Set<zzbcf<?>> zzaEn = new zzb();
    private final Handler mHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzben zzay(Context context) {
        Object object = zzuI;
        synchronized (object) {
            if (zzaEh == null) {
                HandlerThread handlerThread = new HandlerThread("GoogleApiHandler", 9);
                handlerThread.start();
                Looper looper = handlerThread.getLooper();
                zzaEh = new zzben(context.getApplicationContext(), looper, GoogleApiAvailability.getInstance());
            }
            return zzaEh;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzben zzqi() {
        Object object = zzuI;
        synchronized (object) {
            zzbr.zzb((Object)zzaEh, (Object)"Must guarantee manager is non-null before using getInstance");
            return zzaEh;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzqj() {
        Object object = zzuI;
        synchronized (object) {
            if (zzaEh != null) {
                zzben zzben2 = zzaEh;
                zzben2.zzaEk.incrementAndGet();
                zzben2.mHandler.sendMessageAtFrontOfQueue(zzben2.mHandler.obtainMessage(10));
            }
            return;
        }
    }

    private zzben(Context context, Looper looper, GoogleApiAvailability googleApiAvailability) {
        this.mContext = context;
        this.mHandler = new Handler(looper, (Handler.Callback)this);
        this.zzaBf = googleApiAvailability;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6));
    }

    public final int zzqk() {
        return this.zzaEj.getAndIncrement();
    }

    public final void zzb(GoogleApi<?> googleApi) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, googleApi));
    }

    @WorkerThread
    private final void zzc(GoogleApi<?> googleApi) {
        zzbcf<?> zzbcf2 = googleApi.zzpf();
        zzbep<Object> zzbep2 = this.zzaCD.get(zzbcf2);
        if (zzbep2 == null) {
            zzbep2 = new zzbep(this, googleApi);
            this.zzaCD.put(zzbcf2, zzbep2);
        }
        if (zzbep2.zzmt()) {
            this.zzaEn.add(zzbcf2);
        }
        zzbep2.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(@NonNull zzbdi zzbdi2) {
        Object object = zzuI;
        synchronized (object) {
            if (this.zzaEl != zzbdi2) {
                this.zzaEl = zzbdi2;
                this.zzaEm.clear();
                this.zzaEm.addAll((Collection<zzbcf<?>>)zzbdi2.zzpP());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzb(@NonNull zzbdi zzbdi2) {
        Object object = zzuI;
        synchronized (object) {
            if (this.zzaEl == zzbdi2) {
                this.zzaEl = null;
                this.zzaEm.clear();
            }
            return;
        }
    }

    public final Task<Void> zza(Iterable<? extends GoogleApi<?>> iterable) {
        zzbch zzbch2 = new zzbch(iterable);
        for (GoogleApi<?> googleApi : iterable) {
            zzbep<?> zzbep2 = this.zzaCD.get(googleApi.zzpf());
            if (zzbep2 != null && zzbep2.isConnected()) continue;
            this.mHandler.sendMessage(this.mHandler.obtainMessage(2, (Object)zzbch2));
            return zzbch2.getTask();
        }
        zzbch2.zzps();
        return zzbch2.getTask();
    }

    public final void zzpq() {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3));
    }

    final void zzpj() {
        this.zzaEk.incrementAndGet();
        this.mHandler.sendMessage(this.mHandler.obtainMessage(10));
    }

    @WorkerThread
    private final void zzql() {
        for (zzbcf<?> zzbcf2 : this.zzaEn) {
            this.zzaCD.remove(zzbcf2).signOut();
        }
        this.zzaEn.clear();
    }

    public final <O extends Api.ApiOptions> void zza(GoogleApi<O> googleApi, int n, zzbck<? extends Result, Api.zzb> zzbck2) {
        zzbca<zzbck<? extends Result, Api.zzb>> zzbca2 = new zzbca<zzbck<? extends Result, Api.zzb>>(n, zzbck2);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)new zzbfp(zzbca2, this.zzaEk.get(), googleApi)));
    }

    public final <O extends Api.ApiOptions, TResult> void zza(GoogleApi<O> googleApi, int n, zzbgc<Api.zzb, TResult> zzbgc2, TaskCompletionSource<TResult> taskCompletionSource, zzbfy zzbfy2) {
        zzbcc<TResult> zzbcc2 = new zzbcc<TResult>(n, zzbgc2, taskCompletionSource, zzbfy2);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)new zzbfp(zzbcc2, this.zzaEk.get(), googleApi)));
    }

    public final <O extends Api.ApiOptions> Task<Void> zza(@NonNull GoogleApi<O> googleApi, @NonNull zzbfq<Api.zzb, ?> zzbfq2, @NonNull zzbgk<Api.zzb, ?> zzbgk2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzbcb zzbcb2 = new zzbcb(new zzbfr(zzbfq2, zzbgk2), (TaskCompletionSource<Void>)taskCompletionSource);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(8, (Object)new zzbfp(zzbcb2, this.zzaEk.get(), googleApi)));
        return taskCompletionSource.getTask();
    }

    public final <O extends Api.ApiOptions> Task<Void> zza(@NonNull GoogleApi<O> googleApi, @NonNull zzbfk<?> zzbfk2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzbcd zzbcd2 = new zzbcd(zzbfk2, (TaskCompletionSource<Void>)taskCompletionSource);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(13, (Object)new zzbfp(zzbcd2, this.zzaEk.get(), googleApi)));
        return taskCompletionSource.getTask();
    }

    @WorkerThread
    public final boolean handleMessage(Message message) {
        block0 : switch (message.what) {
            case 1: {
                boolean bl = (Boolean)message.obj;
                zzben zzben2 = this;
                this.zzaEg = bl ? 10000L : 300000L;
                zzben2.mHandler.removeMessages(12);
                for (zzbcf<?> zzbcf2 : zzben2.zzaCD.keySet()) {
                    zzben2.mHandler.sendMessageDelayed(zzben2.mHandler.obtainMessage(12, zzbcf2), zzben2.zzaEg);
                }
                break;
            }
            case 2: {
                zzbch zzbch2 = (zzbch)message.obj;
                zzben zzben3 = this;
                for (zzbcf<?> zzbcf3 : zzbch2.zzpr()) {
                    zzbep<?> zzbep2 = zzben3.zzaCD.get(zzbcf3);
                    if (zzbep2 == null) {
                        ConnectionResult connectionResult = new ConnectionResult(13);
                        zzbch2.zza(zzbcf3, connectionResult);
                        break block0;
                    }
                    if (zzbep2.isConnected()) {
                        zzbch2.zza(zzbcf3, ConnectionResult.zzazZ);
                        continue;
                    }
                    if (zzbep2.zzqs() != null) {
                        zzbch2.zza(zzbcf3, zzbep2.zzqs());
                        continue;
                    }
                    zzbep2.zza(zzbch2);
                }
                break;
            }
            case 3: {
                for (zzbep<?> zzbep3 : this.zzaCD.values()) {
                    zzbep3.zzqr();
                    zzbep3.connect();
                }
                break;
            }
            case 4: 
            case 8: 
            case 13: {
                zzbfp zzbfp2 = (zzbfp)message.obj;
                zzben zzben4 = this;
                zzbep<?> zzbep4 = zzben4.zzaCD.get(zzbfp2.zzaEV.zzpf());
                if (zzbep4 == null) {
                    zzben4.zzc(zzbfp2.zzaEV);
                    zzbep4 = zzben4.zzaCD.get(zzbfp2.zzaEV.zzpf());
                }
                if (zzbep4.zzmt() && zzben4.zzaEk.get() != zzbfp2.zzaEU) {
                    zzbfp2.zzaET.zzp(zzaEe);
                    zzbep4.signOut();
                    break;
                }
                zzbep4.zza(zzbfp2.zzaET);
                break;
            }
            case 5: {
                ConnectionResult connectionResult = (ConnectionResult)message.obj;
                int n = message.arg1;
                zzben zzben5 = this;
                zzbep<?> zzbep5 = null;
                for (zzbep<?> zzbep6 : zzben5.zzaCD.values()) {
                    if (zzbep6.getInstanceId() != n) continue;
                    zzbep5 = zzbep6;
                    break;
                }
                if (zzbep5 != null) {
                    zzbep<?> zzbep6;
                    String string2 = String.valueOf(zzben5.zzaBf.getErrorString(connectionResult.getErrorCode()));
                    zzbep6 = String.valueOf(connectionResult.getErrorMessage());
                    zzbep5.zzt(new Status(17, new StringBuilder(69 + String.valueOf(string2).length() + String.valueOf(zzbep6).length()).append("Error resolution was canceled by the user, original error message: ").append(string2).append(": ").append((String)((Object)zzbep6)).toString()));
                    break;
                }
                Log.wtf((String)"GoogleApiManager", (String)new StringBuilder(76).append("Could not find API instance ").append(n).append(" while trying to fail enqueued calls.").toString(), (Throwable)new Exception());
                break;
            }
            case 6: {
                zzben zzben6 = this;
                if (!(zzben6.mContext.getApplicationContext() instanceof Application)) break;
                zzbci.zza((Application)((Application)zzben6.mContext.getApplicationContext()));
                zzbci.zzpt().zza((zzbcj)new zzbeo(zzben6));
                if (zzbci.zzpt().zzab(true)) break;
                zzben6.zzaEg = 300000L;
                break;
            }
            case 7: {
                this.zzc((GoogleApi)message.obj);
                break;
            }
            case 9: {
                if (!this.zzaCD.containsKey(message.obj)) break;
                this.zzaCD.get(message.obj).resume();
                break;
            }
            case 10: {
                this.zzql();
                break;
            }
            case 11: {
                if (!this.zzaCD.containsKey(message.obj)) break;
                this.zzaCD.get(message.obj).zzqb();
                break;
            }
            case 12: {
                if (!this.zzaCD.containsKey(message.obj)) break;
                this.zzaCD.get(message.obj).zzqv();
                break;
            }
            default: {
                int n = message.what;
                Log.w((String)"GoogleApiManager", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                return false;
            }
        }
        return true;
    }

    final PendingIntent zza(zzbcf<?> zzbcf2, int n) {
        zzbep<?> zzbep2 = this.zzaCD.get(zzbcf2);
        if (zzbep2 == null) {
            return null;
        }
        zzcuw zzcuw2 = zzbep2.zzqw();
        if (zzcuw2 == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)n, (Intent)zzcuw2.zzmF(), (int)0x8000000);
    }

    final boolean zzc(ConnectionResult connectionResult, int n) {
        return this.zzaBf.zza(this.mContext, connectionResult, n);
    }

    public final void zza(ConnectionResult connectionResult, int n) {
        if (!this.zzc(connectionResult, n)) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(5, n, 0, (Object)connectionResult));
        }
    }

    static /* synthetic */ Handler zza(zzben zzben2) {
        return zzben2.mHandler;
    }

    static /* synthetic */ Context zzb(zzben zzben2) {
        return zzben2.mContext;
    }

    static /* synthetic */ long zzc(zzben zzben2) {
        return zzben2.zzaDE;
    }

    static /* synthetic */ long zzd(zzben zzben2) {
        return zzben2.zzaDD;
    }

    static /* synthetic */ int zza(zzben zzben2, int n) {
        zzben2.zzaEi = n;
        return zzben2.zzaEi;
    }

    static /* synthetic */ Status zzqm() {
        return zzaEf;
    }

    static /* synthetic */ Object zzqn() {
        return zzuI;
    }

    static /* synthetic */ zzbdi zze(zzben zzben2) {
        return zzben2.zzaEl;
    }

    static /* synthetic */ Set zzf(zzben zzben2) {
        return zzben2.zzaEm;
    }

    static /* synthetic */ GoogleApiAvailability zzg(zzben zzben2) {
        return zzben2.zzaBf;
    }

    static /* synthetic */ long zzh(zzben zzben2) {
        return zzben2.zzaEg;
    }

    static /* synthetic */ int zzi(zzben zzben2) {
        return zzben2.zzaEi;
    }

    static /* synthetic */ Map zzj(zzben zzben2) {
        return zzben2.zzaCD;
    }
}

